var direct = "__DIRECT__";
if (direct == "__DIR" + "ECT__") direct = "DIRECT;";

var wall_proxy = function(){ return direct; };
var wall_v6_proxy = function(){ return direct; };

var nowall_proxy = function(){ return "__SOCKS5__; __SOCKS__; __PROXY__"; };
var ip_proxy = function(){ return nowall_proxy(); };
var ipv6_proxy = function(){ return wall_v6_proxy(); };

/*
 * Copyright (C) 2014 breakwa11
 * https://github.com/breakwa11/gfw_whitelist
 */

var cnIpRange = [
{},{0x10001:1,0x10002:1,0x10003:1,0x10008:4,0x1000c:4,0x10020:16,0x10030:16,0x10100:1,0x10102:1,0x10103:1,0x10104:4,0x10108:4,0x1010c:4,0x10110:16,0x10120:16,0x10130:16,0x10200:1,0x10201:1,0x10202:1,0x10204:1,0x10205:1,0x10206:1,0x10207:1,0x10208:1,0x10209:1,0x1020a:1,0x1020b:1,0x1020c:4,0x10210:16,0x10220:16,0x10230:16,0x10240:64,0x10300:256,0x10401:1,0x10402:1,0x10403:1,0x10404:1,0x10405:1,0x10406:1,0x10407:1,0x10408:4,0x1040c:4,0x10410:16,0x10420:16,0x10430:16,0x10440:64,0x10800:256,0x10a00:4,0x10a04:4,0x10a08:1,0x10a09:1,0x10a0b:1,0x10a0c:4,0x10a10:16,0x10a20:16,0x10a30:16,0x10a40:64,0x10c00:1024,0x11800:1024,0x11c00:1024,0x12d00:256,0x13000:256,0x13100:256,0x13200:256,0x13300:256,0x13800:1024,0x13c00:1024,0x14400:1024,0x15000:1024,0x15400:1024,0x15800:1024,0x15c00:256,0x15d00:256,0x15e00:256,0x15f00:256,0x17400:1024,0x1b400:1024,0x1b800:256,0x1b900:256,0x1bc00:1024,0x1c000:1024,0x1c400:1024,0x1ca00:256,0x1cb00:256,0x1cc00:1024},{},{},{},{},{},{},{},{},{},{},{},{},{0xe0000:4,0xe0004:4,0xe000c:4,0xe0100:4,0xe0118:4,0xe0160:4,0xe016c:4,0xe1000:1024,0xe1400:1024,0xe1800:1024,0xe1c00:1024,0xe6680:4,0xe669c:4,0xe66b4:4,0xe6700:256,0xe6800:1024,0xe6c00:1024,0xe7000:1024,0xe7400:1024,0xe7800:1024,0xe7c00:1024,0xe8200:256,0xe8300:256,0xe8600:256,0xe8700:256,0xe9000:1024,0xe9400:1024,0xe9800:1024,0xe9c00:1024,0xec004:4,0xec03c:4,0xec04c:4,0xec400:256,0xec500:256,0xecc00:256,0xecd00:256,0xed000:1024,0xed400:1024,0xed800:1024,0xedc00:1024},{},{},{},{},{},{},{},{},{},{},{},{},{0x1b0080:4,0x1b0084:4,0x1b00a0:4,0x1b00a4:4,0x1b00bc:4,0x1b00cc:4,0x1b00d0:4,0x1b00d4:4,0x1b0800:1024,0x1b0c00:1024,0x1b1000:1024,0x1b1400:1024,0x1b1800:1024,0x1b1c00:1024,0x1b22e8:4,0x1b22ec:4,0x1b2400:1024,0x1b2800:1024,0x1b2c00:1024,0x1b3228:4,0x1b322c:4,0x1b3280:64,0x1b32c0:64,0x1b3648:4,0x1b364c:4,0x1b3698:4,0x1b369c:4,0x1b36c0:64,0x1b62d0:16,0x1b62e0:16,0x1b62f0:16,0x1b6380:64,0x1b63c0:64,0x1b6700:256,0x1b6a80:64,0x1b6acc:4,0x1b6d20:16,0x1b6d30:16,0x1b6d7c:4,0x1b7000:64,0x1b7050:16,0x1b7070:4,0x1b7074:4,0x1b7180:64,0x1b7300:64,0x1b7340:64,0x1b742c:4,0x1b7948:4,0x1b794c:4,0x1b7978:4,0x1b797c:4,0x1b8000:256,0x1b8100:256,0x1b83dc:4,0x1b9000:256,0x1b9400:1024,0x1b9800:1024,0x1b9c00:1024,0x1bb800:1024,0x1bbc00:1024,0x1bc000:1024,0x1bc400:1024,0x1bc800:1024,0x1bcc00:1024,0x1bd000:1024,0x1bd400:1024,0x1bd800:1024,0x1bdc00:1024,0x1be000:1024},{},{},{},{},{},{},{},{},{0x240000:4,0x240008:4,0x24000c:4,0x240010:16,0x240020:16,0x240030:16,0x240040:64,0x240080:64,0x2400c0:64,0x240100:256,0x240400:1024,0x241000:1024,0x241400:1024,0x241800:1024,0x241c00:1024,0x242000:1024,0x242400:256,0x242500:16,0x242510:16,0x242524:1,0x242525:1,0x242527:1,0x242528:4,0x24252c:4,0x242530:16,0x242800:1024,0x242c00:1024,0x243000:256,0x243100:256,0x243300:256,0x243800:1024,0x243c00:1024,0x246000:1024,0x246400:1024,0x246800:1024,0x246c00:1024,0x247000:1024,0x247400:1024,0x247800:1024,0x247c00:1024,0x248000:1024,0x248400:1024,0x248800:1024,0x248c00:1024,0x249000:1024,0x249400:1024,0x249800:1024,0x249c00:1024,0x24a000:1024,0x24a400:1024,0x24a800:1024,0x24ac00:1024,0x24b000:1024,0x24b400:1024,0x24b800:1024,0x24bc00:1024,0x24c000:1024,0x24c400:1024,0x24c800:1024,0x24cc00:1024,0x24d000:1024,0x24d400:1024,0x24d800:1024,0x24dc00:1024,0x24f800:1024,0x24fe00:256,0x24ff74:4,0x24ff80:4,0x24ffa4:4,0x24ffac:4,0x24ffb0:4,0x24ffc0:4},{},{},{0x270000:1,0x270002:1,0x270003:1,0x270004:4,0x270008:4,0x27000c:4,0x270010:16,0x270020:16,0x270030:16,0x270040:64,0x270080:64,0x2700c0:64,0x274000:1024,0x274400:1024,0x274800:1024,0x274c00:1024,0x275000:1024,0x275400:1024,0x275800:1024,0x275c00:1024,0x276000:1024,0x276400:1024,0x276800:1024,0x276c00:256,0x278000:1024,0x278400:1024,0x278800:1024,0x278c00:1024,0x279000:1024,0x279400:1024,0x279800:1024,0x279c00:1024,0x27a000:1024,0x27a400:1024,0x27a800:1024,0x27ac00:1024,0x27b000:1024,0x27b400:1024,0x27b800:1024,0x27bc00:1024},{0x284800:256,0x284900:256,0x287d80:64,0x287dc0:64,0x287e40:64},{},{0x2a0000:4,0x2a0008:4,0x2a000c:4,0x2a0010:4,0x2a0014:4,0x2a0018:4,0x2a0020:16,0x2a0030:16,0x2a0080:64,0x2a00c0:64,0x2a0100:16,0x2a0110:16,0x2a0120:16,0x2a0130:4,0x2a0134:4,0x2a0138:4,0x2a0180:64,0x2a01c0:64,0x2a0400:1024,0x2a3000:256,0x2a3100:256,0x2a3200:256,0x2a3300:256,0x2a3400:1024,0x2a3800:1024,0x2a3e00:64,0x2a3e40:64,0x2a3e80:16,0x2a3e90:16,0x2a3ea0:16,0x2a3eb4:4,0x2a3eb8:4,0x2a3ebc:4,0x2a3f00:256,0x2a5000:256,0x2a5100:256,0x2a5340:16,0x2a5350:4,0x2a5358:4,0x2a535c:4,0x2a5360:16,0x2a5370:16,0x2a5380:64,0x2a53c0:64,0x2a5400:1024,0x2a5800:1024,0x2a5c00:1024,0x2a6040:16,0x2a6050:16,0x2a6060:4,0x2a6064:4,0x2a606c:4,0x2a6070:16,0x2a6080:64,0x2a60c0:64,0x2a6100:256,0x2a6300:64,0x2a6340:16,0x2a6350:16,0x2a6360:16,0x2a6370:4,0x2a6378:4,0x2a637c:4,0x2a6400:1024,0x2a7800:256,0x2a7900:256,0x2a7a00:256,0x2a7b00:16,0x2a7b10:16,0x2a7b24:4,0x2a7b28:4,0x2a7b2c:4,0x2a7b30:16,0x2a7b40:64,0x2a7b80:64,0x2a7bc0:64,0x2a8000:1024,0x2a8400:1024,0x2a8800:1024,0x2a8c00:1024,0x2a9c00:16,0x2a9c10:16,0x2a9c24:4,0x2a9c28:4,0x2a9c2c:4,0x2a9c30:16,0x2a9c40:64,0x2a9c80:64,0x2a9cc0:64,0x2a9d00:256,0x2a9e00:256,0x2a9f00:256,0x2aa000:1024,0x2aa400:1024,0x2aa800:1024,0x2aac00:1024,0x2ab000:1024,0x2ab400:1024,0x2ab800:256,0x2ab900:256,0x2aba00:256,0x2abb00:64,0x2abb40:16,0x2abb50:16,0x2abb60:16,0x2abb70:4,0x2abb74:4,0x2abb78:4,0x2abb80:64,0x2abbc0:64,0x2ac000:256,0x2ac100:256,0x2ac200:4,0x2ac204:4,0x2ac208:4,0x2ac20c:4,0x2ac210:16,0x2ac220:16,0x2ac230:16,0x2ac240:64,0x2ac280:64,0x2ac2c0:64,0x2ac300:256,0x2ac400:1024,0x2ac900:64,0x2ac940:64,0x2aca00:256,0x2acb00:256,0x2acc00:1024,0x2ad000:1024,0x2ad400:1024,0x2ad800:1024,0x2adc00:1024,0x2ae000:1024,0x2ae400:1024,0x2ae800:1024,0x2aec00:1024,0x2af000:64,0x2af040:64,0x2af080:64,0x2af0c0:64,0x2af200:256,0x2af300:256,0x2af400:1024,0x2af800:1024,0x2afc00:1024},{0x2be00c:4,0x2be018:4,0x2be02c:4,0x2be034:4,0x2be038:4,0x2be040:4,0x2be044:4,0x2be048:4,0x2be050:4,0x2be064:4,0x2be090:4,0x2be0a0:4,0x2be0b0:4,0x2be0b8:4,0x2be0c8:4,0x2be0cc:4,0x2be0d0:4,0x2be0d4:4,0x2be0d8:4,0x2be0e0:4,0x2be0f0:4,0x2be14c:4,0x2be154:4,0x2be178:4,0x2be17c:4,0x2be18c:4,0x2be1ac:4,0x2be1b4:4,0x2be1d0:4,0x2be1d8:4,0x2be1dc:4,0x2be1e0:4,0x2be1e4:4,0x2be1e8:4,0x2be1ec:4,0x2be1f0:4,0x2be1f4:4,0x2be1fc:4,0x2be220:4,0x2be224:4,0x2be228:4,0x2be22c:4,0x2be230:4,0x2be234:4,0x2be238:4,0x2be23c:4,0x2be240:4,0x2be244:4,0x2be248:4,0x2be24c:4,0x2be250:4,0x2be254:4,0x2be258:4,0x2be25c:4,0x2be260:4,0x2be264:4,0x2be268:4,0x2be26c:4,0x2be270:4,0x2be274:4,0x2be278:4,0x2be280:4,0x2be284:4,0x2be288:4,0x2be28c:4,0x2be290:4,0x2be294:4,0x2be298:4,0x2be29c:4,0x2be2a0:4,0x2be2a4:4,0x2be2a8:4,0x2be2ac:4,0x2be2b0:4,0x2be2b4:4,0x2be2b8:4,0x2be2bc:4,0x2be2c0:4,0x2be2c4:4,0x2be2c8:4,0x2be2cc:4,0x2be2d0:4,0x2be2d4:4,0x2be2ec:4,0x2be2f0:4,0x2be2f4:4,0x2be2f8:4,0x2be2fc:4,0x2be300:4,0x2be304:4,0x2be308:4,0x2be31c:4,0x2be320:4,0x2be324:4,0x2be328:4,0x2be32c:4,0x2be330:4,0x2be334:4,0x2be338:4,0x2be33c:4,0x2be340:4,0x2be344:4,0x2be348:4,0x2be34c:4,0x2be350:4,0x2be354:4,0x2be358:4,0x2be35c:4,0x2be360:4,0x2be364:4,0x2be368:4,0x2be388:4,0x2be38c:4,0x2be390:4,0x2be398:4,0x2be39c:4,0x2be3a0:4,0x2be3a4:4,0x2be3a8:4,0x2be3ac:4,0x2be3b0:4,0x2be3b4:4,0x2be3bc:4,0x2be3c0:4,0x2be3c4:4,0x2be3c8:4,0x2be3cc:4,0x2be3d0:4,0x2be3d4:4,0x2be3d8:4,0x2be3dc:4,0x2be3e8:4,0x2be3f8:4,0x2be3fc:4,0x2be400:4,0x2be404:4,0x2be408:4,0x2be40c:4,0x2be410:4,0x2be414:4,0x2be418:4,0x2be41c:4,0x2be420:4,0x2be424:4,0x2be428:4,0x2be42c:4,0x2be430:4,0x2be434:4,0x2be438:4,0x2be43c:4,0x2be440:4,0x2be444:4,0x2be44c:4,0x2be464:4,0x2be474:4,0x2be478:4,0x2be484:4,0x2be488:4,0x2be494:4,0x2be498:4,0x2be4b4:4,0x2be4bc:4,0x2be4cc:4,0x2be4f0:4,0x2be510:4,0x2be528:4,0x2be530:4,0x2be538:4,0x2be560:4,0x2be56c:4,0x2be578:4,0x2be588:4,0x2be58c:4,0x2be590:4,0x2be5a8:4,0x2be5ac:4,0x2be5b0:4,0x2be5b4:4,0x2be5b8:4,0x2be5bc:4,0x2be5c0:4,0x2be5c4:4,0x2be5d8:4,0x2be5dc:4,0x2be5e8:4,0x2be5ec:4,0x2be614:4,0x2be620:4,0x2be644:4,0x2be648:4,0x2be654:4,0x2be67c:4,0x2be688:4,0x2be6a8:4,0x2be6dc:4,0x2be6e0:4,0x2be6e4:4,0x2be6e8:4,0x2be6ec:4,0x2be6f0:4,0x2be6f4:4,0x2be6f8:4,0x2be6fc:4,0x2be720:4,0x2be724:4,0x2be728:4,0x2be72c:4,0x2be750:4,0x2be754:4,0x2be758:4,0x2be75c:4,0x2be760:4,0x2be764:4,0x2be768:4,0x2be76c:4,0x2be788:4,0x2be78c:4,0x2be790:4,0x2be794:4,0x2be798:4,0x2be79c:4,0x2be7a0:4,0x2be7a4:4,0x2be7a8:4,0x2be7ac:4,0x2be7b0:4,0x2be7b4:4,0x2bec00:4,0x2bec04:4,0x2bec08:4,0x2bec0c:4,0x2bec10:4,0x2bec14:4,0x2bec18:4,0x2bec1c:4,0x2bec20:4,0x2bec24:4,0x2bec28:4,0x2bec2c:4,0x2bec30:4,0x2bec34:4,0x2bec38:4,0x2bec3c:4,0x2bec40:4,0x2bec44:4,0x2bec48:4,0x2bec4c:4,0x2bec50:4,0x2bec54:4,0x2bec58:4,0x2bec5c:4,0x2bec60:4,0x2bec64:4,0x2bec68:4,0x2bec6c:4,0x2bec70:4,0x2bec74:4,0x2bec78:4,0x2bec7c:4,0x2bec80:4,0x2bec84:4,0x2bec88:4,0x2bec8c:4,0x2bec90:4,0x2bec94:4,0x2bec98:4,0x2bec9c:4,0x2beca0:4,0x2beca4:4,0x2beca8:4,0x2becac:4,0x2becb0:4,0x2becb4:4,0x2becb8:4,0x2becbc:4,0x2becc0:4,0x2becc4:4,0x2becc8:4,0x2beccc:4,0x2becd0:4,0x2becd4:4,0x2becd8:4,0x2becdc:4,0x2bece0:4,0x2bece4:4,0x2bece8:4,0x2becec:4,0x2becf0:4,0x2becf4:4,0x2becf8:4,0x2becfc:4,0x2bed00:4,0x2bed04:4,0x2bed08:4,0x2bed0c:4,0x2bed10:4,0x2bed14:4,0x2bed18:4,0x2bed1c:4,0x2bed20:4,0x2bed24:4,0x2bed28:4,0x2bed2c:4,0x2bed30:4,0x2bed34:4,0x2bed38:4,0x2bed3c:4,0x2bed40:4,0x2bed44:4,0x2bed48:4,0x2bed4c:4,0x2bed50:4,0x2bed54:4,0x2bed58:4,0x2bed5c:4,0x2bed60:4,0x2bed64:4,0x2bed68:4,0x2bed6c:4,0x2bed70:4,0x2bed74:4,0x2bed78:4,0x2bed7c:4,0x2bed80:4,0x2bed84:4,0x2bed88:4,0x2bed8c:4,0x2bed90:4,0x2bed94:4,0x2bed98:4,0x2bed9c:4,0x2beda0:4,0x2beda4:4,0x2beda8:4,0x2bedac:4,0x2bedb0:4,0x2bedb4:4,0x2bedb8:4,0x2bedbc:4,0x2bedc0:4,0x2bedc4:4,0x2bedc8:4,0x2bedcc:4,0x2bedd0:4,0x2bedd4:4,0x2bedd8:4,0x2beddc:4,0x2bede0:4,0x2bede4:4,0x2bede8:4,0x2bedec:4,0x2bedf0:4,0x2bedf4:4,0x2bedf8:4,0x2bedfc:4,0x2bee00:4,0x2bee04:4,0x2bee08:4,0x2bee0c:4,0x2bee10:4,0x2bee14:4,0x2bee18:4,0x2bee1c:4,0x2bee20:4,0x2bee24:4,0x2bee28:4,0x2bee2c:4,0x2bee30:4,0x2bee34:4,0x2bee38:4,0x2bee3c:4,0x2bee40:4,0x2bee44:4,0x2bee48:4,0x2bee4c:4,0x2bee50:4,0x2bee54:4,0x2bee58:4,0x2bee5c:4,0x2bee60:4,0x2bee64:4,0x2bee68:4,0x2bee6c:4,0x2bee70:4,0x2bee74:4,0x2bee78:4,0x2bee7c:4,0x2bee80:4,0x2bee84:4,0x2bee88:4,0x2bee8c:4,0x2bee90:4,0x2bee94:4,0x2bee98:4,0x2bee9c:4,0x2beea0:4,0x2beea4:4,0x2beea8:4,0x2beeac:4,0x2beeb0:4,0x2beeb4:4,0x2beeb8:4,0x2beebc:4,0x2beec0:4,0x2beec4:4,0x2beec8:4,0x2beecc:4,0x2beed0:4,0x2beed4:4,0x2beed8:4,0x2beedc:4,0x2beee0:4,0x2beee4:4,0x2beee8:4,0x2beeec:4,0x2beef0:4,0x2beef4:4,0x2beef8:4,0x2beefc:4,0x2bef00:4,0x2bef04:4,0x2bef08:4,0x2bef0c:4,0x2bef10:4,0x2bef14:4,0x2bef18:4,0x2bef1c:4,0x2bef20:4,0x2bef24:4,0x2bef28:4,0x2bef2c:4,0x2bef30:4,0x2bef74:4,0x2bef78:4,0x2befac:4,0x2befb0:4,0x2bf000:4,0x2bf030:4,0x2bf038:4,0x2bf03c:4,0x2bf044:4,0x2bf048:4,0x2bf04c:4,0x2bf054:4,0x2bf07c:4,0x2bf080:4,0x2bf084:4,0x2bf088:4,0x2bf09c:4,0x2bf0a0:4,0x2bf0a4:4,0x2bf0a8:4,0x2bf0ac:4,0x2bf0b0:4,0x2bf0b4:4,0x2bf0b8:4,0x2bf0bc:4,0x2bf0c0:4,0x2bf0c4:4,0x2bf0c8:4,0x2bf0cc:4,0x2bf0d0:4,0x2bf0d4:4,0x2bf0d8:4,0x2bf0dc:4,0x2bf0ec:4,0x2bf0f0:4,0x2bf0f4:4,0x2bf0f8:4,0x2bf0fc:4,0x2bf100:4,0x2bf104:4,0x2bf108:4,0x2bf10c:4,0x2bf110:4,0x2bf114:4,0x2bf130:4,0x2bf14c:4,0x2bf150:4,0x2bf154:4,0x2bf158:4,0x2bf15c:4,0x2bf170:4,0x2bf1a8:4,0x2bf1ac:4,0x2bf1b0:4,0x2bf1b4:4,0x2bf1b8:4,0x2bf1c4:4,0x2bf1d0:4,0x2bf1d4:4,0x2bf1d8:4,0x2bf1dc:4,0x2bf1e0:4,0x2bf1e4:4,0x2bf1e8:4,0x2bf1ec:4,0x2bf1f0:4,0x2bf1f8:4,0x2bf1fc:4,0x2bf208:4,0x2bf20c:4,0x2bf210:4,0x2bf214:4,0x2bf218:4,0x2bf21c:4,0x2bf22c:4,0x2bf230:4,0x2bf234:4,0x2bf238:4,0x2bf23c:4,0x2bf240:4,0x2bf248:4,0x2bf24c:4,0x2bf250:4,0x2bf254:4,0x2bf258:4,0x2bf25c:4,0x2bf260:4,0x2bf290:4,0x2bf294:4,0x2bf298:4,0x2bf29c:4,0x2bf2a0:4,0x2bf2a4:4,0x2bf2a8:4,0x2bf2b4:4,0x2bf2bc:4,0x2bf2c0:4,0x2bf2c4:4,0x2bf2cc:4,0x2bf2d8:4,0x2bf2dc:4,0x2bf2fc:4,0x2bf304:4,0x2bf308:4,0x2bf30c:4,0x2bf310:4,0x2bf318:4,0x2bf358:4,0x2bf380:4,0x2bf388:4,0x2bf390:4,0x2bf394:4,0x2bf39c:4,0x2bf3a8:4,0x2bf3b4:4,0x2bf3bc:4,0x2bf3e4:4,0x2bf3e8:4,0x2bf3f4:4,0x2bf600:4,0x2bf604:4,0x2bf608:4,0x2bf60c:4,0x2bf610:4,0x2bf614:4,0x2bf618:4,0x2bf61c:4,0x2bf620:4,0x2bf624:4,0x2bf628:4,0x2bf62c:4,0x2bf630:4,0x2bf634:4,0x2bf638:4,0x2bf63c:4,0x2bf640:4,0x2bf644:4,0x2bf648:4,0x2bf64c:4,0x2bf650:4,0x2bf654:4,0x2bf658:4,0x2bf65c:4,0x2bf660:4,0x2bf6d4:4,0x2bf6e4:4,0x2bf704:4,0x2bf708:4,0x2bf72c:4,0x2bf730:4,0x2bf744:4,0x2bf74c:4,0x2bf754:4,0x2bf758:4,0x2bf75c:4,0x2bf760:4,0x2bf764:4,0x2bf76c:4,0x2bf770:4,0x2bf794:4,0x2bf798:4,0x2bf7b0:4,0x2bf7b4:4,0x2bf7b8:4,0x2bf7bc:4,0x2bf7c4:4,0x2bf7c8:4,0x2bf7cc:4,0x2bf7d0:4,0x2bf7d4:4,0x2bf7d8:4,0x2bf7dc:4,0x2bf7e0:4,0x2bf7e4:4,0x2bf7e8:4,0x2bf7ec:4,0x2bf7f0:4,0x2bf7f4:4,0x2bf7f8:4,0x2bf7fc:4,0x2bf800:4,0x2bf804:4,0x2bf814:4,0x2bf81c:4,0x2bf830:4,0x2bf84c:4,0x2bf850:4,0x2bf854:4,0x2bf858:4,0x2bf85c:4,0x2bf860:4,0x2bf864:4,0x2bf868:4,0x2bf86c:4,0x2bf870:4,0x2bf874:4,0x2bf878:4,0x2bf87c:4,0x2bf880:4,0x2bf884:4,0x2bf888:4,0x2bf88c:4,0x2bf890:4,0x2bf894:4,0x2bf8b0:4,0x2bf8b4:4,0x2bf8b8:4,0x2bf8bc:4,0x2bf8c0:4,0x2bf8c4:4,0x2bf8c8:4,0x2bf8cc:4,0x2bf8d0:4,0x2bf8e4:4,0x2bf8e8:4,0x2bf8f4:4,0x2bf900:4,0x2bf904:4,0x2bf908:4,0x2bf918:4,0x2bf978:4,0x2bf984:4,0x2bf988:4,0x2bf990:4,0x2bf994:4,0x2bf998:4,0x2bf99c:4,0x2bf9a0:4,0x2bf9a4:4,0x2bf9a8:4,0x2bf9c0:4,0x2bf9ec:4,0x2bfa04:4,0x2bfa0c:4,0x2bfa10:4,0x2bfa14:4,0x2bfa1c:4,0x2bfa20:4,0x2bfa24:4,0x2bfa48:4,0x2bfa60:4,0x2bfa64:4,0x2bfa68:4,0x2bfa6c:4,0x2bfa70:4,0x2bfa74:4,0x2bfa80:4,0x2bfa90:4,0x2bfa94:4,0x2bfaa0:4,0x2bfaa8:4,0x2bfaac:4,0x2bfab0:4,0x2bfac8:4,0x2bfad4:4,0x2bfad8:4,0x2bfadc:4,0x2bfaec:4,0x2bfaf4:4,0x2bfb04:4,0x2bfb08:4,0x2bfb0c:4,0x2bfb24:4,0x2bfb74:4,0x2bfbc0:4,0x2bfbe8:4,0x2bfbec:4,0x2bfbf4:4,0x2bfc28:4,0x2bfc30:4,0x2bfc38:4,0x2bfce0:4,0x2bfe00:4,0x2bfe04:4,0x2bfe08:4,0x2bfe18:4,0x2bfe24:4,0x2bfe2c:4,0x2bfe34:4,0x2bfe40:4,0x2bfe48:4,0x2bfe54:4,0x2bfe58:4,0x2bfe5c:4,0x2bfe64:4,0x2bfe68:4,0x2bfe70:4,0x2bfe74:4,0x2bfe80:4,0x2bfe88:4,0x2bfe8c:4,0x2bfe90:4,0x2bfe94:4,0x2bfe98:4,0x2bfe9c:4,0x2bfea8:4,0x2bfeac:4,0x2bfeb4:4,0x2bfeb8:4,0x2bfebc:4,0x2bfec0:4,0x2bfec4:4,0x2bfec8:4,0x2bfed0:4,0x2bfedc:4,0x2bfee0:4,0x2bfee4:4,0x2bfee8:4,0x2bfeec:4,0x2bfef0:4,0x2bfef8:4,0x2bfefc:4,0x2bff00:4,0x2bff04:4,0x2bff08:4,0x2bff10:4,0x2bff30:4,0x2bff3c:4,0x2bff40:4,0x2bff44:4,0x2bff48:4,0x2bff4c:4,0x2bff54:4,0x2bff60:4,0x2bff6c:4,0x2bff90:4,0x2bffa8:4,0x2bffb0:4,0x2bffb8:4,0x2bffc0:4,0x2bffc8:4,0x2bffcc:4,0x2bffd0:4,0x2bffd4:4,0x2bffe0:4,0x2bffe4:4,0x2bffe8:4,0x2bfff4:4},{},{0x2d4110:4,0x2d4114:4,0x2d4118:4,0x2d411c:4,0x2d7084:4,0x2d70bc:4,0x2d70d0:4,0x2d70d4:4,0x2d70d8:4,0x2d70dc:4,0x2d70e4:4,0x2d70e8:4,0x2d70ec:4,0x2d710c:4,0x2d7110:4,0x2d7114:4,0x2d7118:4,0x2d711c:4,0x2d7128:4,0x2d7134:4,0x2d7138:4,0x2d7148:4,0x2d716c:4,0x2d7190:4,0x2d7194:4,0x2d71a8:4,0x2d71b0:4,0x2d71b8:4,0x2d71c8:4,0x2d71cc:4,0x2d71d0:4,0x2d71d4:4,0x2d71d8:4,0x2d71dc:4,0x2d71e4:4,0x2d71f0:4,0x2d71fc:4,0x2d7200:4,0x2d720c:4,0x2d7220:4,0x2d7228:4,0x2d7234:4,0x2d7260:4,0x2d7268:4,0x2d7288:4,0x2d72c4:4,0x2d72c8:4,0x2d72e4:4,0x2d72ec:4,0x2d72fc:4,0x2d732c:4,0x2d7364:4,0x2d7378:4,0x2d7384:4,0x2d7390:4,0x2d739c:4,0x2d73a4:4,0x2d73c8:4,0x2d73d4:4,0x2d73d8:4,0x2d73e4:4,0x2d73ec:4,0x2d73f4:4,0x2d73f8:4,0x2d740c:4,0x2d7410:4,0x2d7414:4,0x2d7418:4,0x2d7420:4,0x2d7424:4,0x2d7434:4,0x2d743c:4,0x2d7440:4,0x2d7460:4,0x2d7464:4,0x2d748c:4,0x2d7498:4,0x2d74d0:4,0x2d7508:4,0x2d7514:4,0x2d7528:4,0x2d7544:4,0x2d757c:4,0x2d75fc:4,0x2d7734:4,0x2d773c:4,0x2d7740:4,0x2d7744:4,0x2d7748:4,0x2d7768:4,0x2d7774:4,0x2d77a0:4,0x2d77e8:4,0x2d7864:4,0x2d788c:4,0x2d789c:4,0x2d78a4:4,0x2d78dc:4,0x2d78f0:4,0x2d7914:4,0x2d7934:4,0x2d7940:4,0x2d7944:4,0x2d7948:4,0x2d795c:4,0x2d7960:4,0x2d7968:4,0x2d79ac:4,0x2d79b0:4,0x2d79d4:4,0x2d79f0:4,0x2d79f4:4,0x2d79f8:4,0x2d79fc:4,0x2d7a00:4,0x2d7a04:4,0x2d7a08:4,0x2d7a0c:4,0x2d7a10:4,0x2d7a14:4,0x2d7a18:4,0x2d7a1c:4,0x2d7a20:4,0x2d7a24:4,0x2d7a28:4,0x2d7a3c:4,0x2d7a40:4,0x2d7a44:4,0x2d7a48:4,0x2d7a4c:4,0x2d7a50:4,0x2d7a54:4,0x2d7a58:4,0x2d7a5c:4,0x2d7a60:4,0x2d7a64:4,0x2d7a68:4,0x2d7a6c:4,0x2d7a70:4,0x2d7a74:4,0x2d7aa0:4,0x2d7aa4:4,0x2d7aa8:4,0x2d7aac:4,0x2d7ab0:4,0x2d7ab4:4,0x2d7ab8:4,0x2d7abc:4,0x2d7ac0:4,0x2d7ac4:4,0x2d7ac8:4,0x2d7acc:4,0x2d7ad0:4,0x2d7ad4:4,0x2d7ad8:4,0x2d7b1c:4,0x2d7b20:4,0x2d7b24:4,0x2d7b2c:4,0x2d7b30:4,0x2d7b34:4,0x2d7b38:4,0x2d7b3c:4,0x2d7b40:4,0x2d7b44:4,0x2d7b48:4,0x2d7b4c:4,0x2d7b50:4,0x2d7b54:4,0x2d7b58:4,0x2d7b78:4,0x2d7b80:4,0x2d7b84:4,0x2d7b88:4,0x2d7b94:4,0x2d7b98:4,0x2d7b9c:4,0x2d7ba4:4,0x2d7ba8:4,0x2d7bac:4,0x2d7bb0:4,0x2d7bb4:4,0x2d7bb8:4,0x2d7bcc:4,0x2d7bd4:4,0x2d7be0:4,0x2d7be4:4,0x2d7be8:4,0x2d7bec:4,0x2d7bf0:4,0x2d7bf4:4,0x2d7bf8:4,0x2d7bfc:4,0x2d7c00:4,0x2d7c14:4,0x2d7c1c:4,0x2d7c20:4,0x2d7c24:4,0x2d7c2c:4,0x2d7c44:4,0x2d7c4c:4,0x2d7c50:4,0x2d7c64:4,0x2d7c7c:4,0x2d7cac:4,0x2d7cb0:4,0x2d7cd0:4,0x2d7cf8:4,0x2d7cfc:4,0x2d7d0c:4,0x2d7d10:4,0x2d7d18:4,0x2d7d1c:4,0x2d7d20:4,0x2d7d2c:4,0x2d7d34:4,0x2d7d38:4,0x2d7d4c:4,0x2d7d50:4,0x2d7d54:4,0x2d7d58:4,0x2d7d5c:4,0x2d7d60:4,0x2d7d64:4,0x2d7d68:4,0x2d7d88:4,0x2d7e30:4,0x2d7e34:4,0x2d7e64:4,0x2d7e6c:4,0x2d7e70:4,0x2d7e74:4,0x2d7e78:4,0x2d7ed4:4,0x2d7edc:4,0x2d7f08:4,0x2d7f0c:4,0x2d7f24:4,0x2d7f60:4,0x2d7f74:4,0x2d7f7c:4,0x2d7f80:4,0x2d7f90:4,0x2d7f94:4,0x2d7f9c:4,0x2d7fd8:4},{},{0x2f5c00:1024,0x2f6000:1024,0x2f6400:1024,0x2f6800:1024,0x2f6c00:1024,0x2f7000:1024,0x2f7400:1024,0x2f7800:1024,0x2f7c00:1024},{},{0x310400:1024,0x313300:256,0x313400:1024,0x314000:1024,0x314400:1024,0x314800:1024,0x314c00:1024,0x315000:1024,0x315400:1024,0x315800:1024,0x315c00:1024,0x317000:1024,0x317400:1024,0x317800:1024,0x318000:1,0x318002:1,0x318003:1,0x318004:4,0x318c00:256,0x318d00:256,0x319800:1024,0x31d000:256,0x31d100:256,0x31d200:256,0x31d300:256,0x31dc00:1024,0x31e800:1024,0x31ef00:64,0x31efc0:64,0x31f6e0:16,0x31f6f0:16},{},{},{0x345000:1024},{},{0x36de00:256,0x36df00:256},{},{},{},{0x3a0e00:256,0x3a0f00:256,0x3a1000:256,0x3a1100:64,0x3a1140:64,0x3a1180:64,0x3a11c0:64,0x3a1200:256,0x3a1300:256,0x3a1400:256,0x3a1500:256,0x3a1600:256,0x3a1700:256,0x3a1800:256,0x3a1900:256,0x3a1e00:256,0x3a1f00:256,0x3a2000:1024,0x3a2400:1024,0x3a2800:256,0x3a2900:256,0x3a2a00:256,0x3a2b00:256,0x3a2c00:1024,0x3a3000:1024,0x3a3400:1024,0x3a3800:256,0x3a3900:256,0x3a3a00:256,0x3a3b00:64,0x3a3b40:64,0x3a3b80:64,0x3a3bc0:64,0x3a3c00:1024,0x3a41e8:4,0x3a41ec:4,0x3a4200:256,0x3a4300:256,0x3a4480:64,0x3a44c0:64,0x3a5200:64,0x3a5240:64,0x3a5300:64,0x3a5340:64,0x3a5380:64,0x3a53c0:64,0x3a5740:64,0x3a6380:64,0x3a63c0:64,0x3a6400:256,0x3a6500:256,0x3a7400:1024,0x3a8000:1024,0x3a8400:1024,0x3a9000:256,0x3a9a00:256,0x3a9b00:256,0x3ac000:256,0x3ac100:256,0x3ac200:256,0x3ac300:256,0x3ac400:256,0x3ac500:256,0x3ac600:256,0x3ac700:256,0x3ac800:1024,0x3acc00:1024,0x3ad000:1024,0x3ad400:1024,0x3ad800:1024,0x3adc00:1024,0x3af000:256,0x3af100:256,0x3af200:256,0x3af300:256,0x3af400:256,0x3af500:256,0x3af600:256,0x3af700:256,0x3af800:1024,0x3afc00:1024},{0x3b2000:1024,0x3b2400:1024,0x3b2800:256,0x3b2900:256,0x3b2a00:256,0x3b2b00:256,0x3b2c00:1024,0x3b3000:256,0x3b3100:64,0x3b3140:64,0x3b3180:64,0x3b31c0:64,0x3b3200:256,0x3b3300:64,0x3b3340:64,0x3b3380:64,0x3b33c0:64,0x3b3400:1024,0x3b3800:1024,0x3b3c00:256,0x3b3d00:256,0x3b3e00:256,0x3b3f00:256,0x3b4000:1024,0x3b4400:1024,0x3b4800:256,0x3b4900:256,0x3b4a00:256,0x3b4b00:256,0x3b4c00:256,0x3b4d00:256,0x3b4e00:256,0x3b4f00:256,0x3b5000:256,0x3b5100:256,0x3b5200:256,0x3b5300:256,0x3b6b00:64,0x3b6b40:64,0x3b6b80:64,0x3b6bc0:64,0x3b6c00:256,0x3b6d00:256,0x3b6e00:256,0x3b6f00:256,0x3b9700:64,0x3b9740:64,0x3b9810:4,0x3b9814:4,0x3b9818:4,0x3b981c:4,0x3b9820:4,0x3b9824:4,0x3b9840:4,0x3b9844:4,0x3b9848:4,0x3b984c:4,0x3b9870:4,0x3b9874:4,0x3b9904:4,0x3b9920:4,0x3b993c:4,0x3b9940:4,0x3b9944:4,0x3b9948:4,0x3b995c:4,0x3b9974:4,0x3b9988:4,0x3b9998:4,0x3b999c:4,0x3b99a4:4,0x3b99a8:4,0x3b99ac:4,0x3b99b0:4,0x3b99b4:4,0x3b99b8:4,0x3b99bc:4,0x3b99c0:4,0x3b9b00:256,0x3bac00:256,0x3bad00:256,0x3bae00:256,0x3baf00:256,0x3bbf00:64,0x3bbf40:64,0x3bbff0:16,0x3bc000:1024,0x3bc400:1024,0x3bc800:1024,0x3bcc00:1024,0x3bd000:1024,0x3bd400:1024,0x3bd800:1024,0x3bdc00:1024,0x3be000:1024,0x3be400:1024,0x3be800:1024,0x3bec00:1024,0x3bf000:1024,0x3bf400:1024,0x3bf800:1024,0x3bfc00:1024},{0x3c0000:1024,0x3c0400:1024,0x3c0800:256,0x3c0900:256,0x3c0a00:256,0x3c0b00:256,0x3c0c00:256,0x3c0d00:64,0x3c0d40:64,0x3c0d80:64,0x3c0dc0:64,0x3c0e00:256,0x3c0f00:256,0x3c1000:1024,0x3c1400:1024,0x3c1800:1024,0x3c1c00:256,0x3c1d00:256,0x3c1e00:256,0x3c1f00:256,0x3c3700:256,0x3c3f00:256,0x3ca000:256,0x3ca100:256,0x3ca200:256,0x3ca300:256,0x3ca400:256,0x3ca500:256,0x3ca600:256,0x3ca700:256,0x3ca800:1024,0x3cac00:1024,0x3cb000:1024,0x3cb400:1024,0x3cb800:1024,0x3cbc00:1024,0x3cc200:256,0x3cc300:256,0x3cc800:1024,0x3ccc00:256,0x3ccd00:256,0x3cce00:256,0x3ccf00:256,0x3cd000:1024,0x3cd400:1024,0x3cd800:256,0x3cd900:256,0x3cda00:256,0x3cdb00:256,0x3cdc00:1024,0x3ce800:256,0x3ce900:256,0x3ceb00:256,0x3cf580:64,0x3cf5c0:64,0x3cf700:256,0x3cfc00:256,0x3cfd80:64,0x3cfdc0:64,0x3cff00:256},{0x3d0450:4,0x3d0454:4,0x3d0458:4,0x3d045c:4,0x3d04b0:16,0x3d08a0:16,0x3d0ed4:4,0x3d0ed8:4,0x3d0edc:4,0x3d0ef0:4,0x3d0ef4:4,0x3d1c00:16,0x3d1c10:16,0x3d1c20:16,0x3d1c30:16,0x3d1c40:64,0x3d1d80:64,0x3d1dc0:16,0x3d1dd0:16,0x3d1de0:16,0x3d1df0:16,0x3d2d80:64,0x3d2de0:16,0x3d2f80:64,0x3d3000:1024,0x3d3400:256,0x3d3500:256,0x3d3600:256,0x3d3700:256,0x3d57c0:64,0x3d8000:256,0x3d8100:256,0x3d8200:256,0x3d8300:256,0x3d8400:256,0x3d8500:64,0x3d8540:64,0x3d8580:64,0x3d85c0:64,0x3d8600:64,0x3d8640:16,0x3d8650:16,0x3d8660:16,0x3d8670:16,0x3d8680:64,0x3d86c0:64,0x3d8700:256,0x3d8800:64,0x3d8840:64,0x3d8880:64,0x3d88c0:64,0x3d8900:64,0x3d8940:64,0x3d8980:64,0x3d89c0:64,0x3d8a00:64,0x3d8a40:64,0x3d8a80:64,0x3d8ac0:64,0x3d8b00:64,0x3d8b40:64,0x3d8b80:64,0x3d8bc0:64,0x3d8c00:1024,0x3d9000:1024,0x3d9400:256,0x3d9500:256,0x3d9600:256,0x3d9700:256,0x3d9800:256,0x3d9900:256,0x3d9a00:256,0x3d9b00:256,0x3d9c00:256,0x3d9d00:256,0x3d9e00:64,0x3d9e40:64,0x3d9e80:64,0x3d9ec0:64,0x3d9f00:64,0x3d9f40:64,0x3d9f80:64,0x3d9fc0:64,0x3da000:256,0x3da100:64,0x3da140:64,0x3da180:64,0x3da1c0:64,0x3da200:256,0x3da300:256,0x3da400:256,0x3da500:256,0x3da600:256,0x3da700:256,0x3da800:256,0x3da900:256,0x3daa00:256,0x3dab00:256,0x3dac00:1024,0x3db000:256,0x3db100:256,0x3db200:256,0x3db300:256,0x3db400:64,0x3db440:64,0x3db480:64,0x3db4c0:64,0x3db500:256,0x3db600:256,0x3db700:256,0x3db800:1024,0x3dbc00:256,0x3dbd00:64,0x3dbd40:64,0x3dbd80:64,0x3dbdc0:64,0x3dbe00:256,0x3dbf00:256,0x3de800:1024,0x3dec00:256,0x3ded00:256,0x3df000:1024},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{0x650000:4,0x650100:4,0x6502ac:4,0x650400:1024,0x651000:1024,0x651400:1024,0x651800:1024,0x651c00:1024,0x652000:1024,0x652400:256,0x652500:256,0x652600:256,0x652700:256,0x652800:1024,0x652c00:1024,0x653000:256,0x653100:256,0x653208:4,0x65320c:4,0x653238:4,0x653400:256,0x653564:4,0x653600:256,0x6537e0:4,0x6537e4:4,0x654000:1024,0x654400:1024,0x654800:1024,0x654c00:256,0x654d00:256,0x654e00:4,0x654e20:16,0x654e30:16,0x655000:1024,0x655400:1024,0x655800:1024,0x655c00:1024,0x656000:4,0x656004:4,0x656008:4,0x656010:16,0x656080:64,0x6560c0:64,0x656360:16,0x656370:16,0x656540:16,0x656550:16,0x656564:1,0x656566:1,0x656567:1,0x656568:4,0x65656c:4,0x656570:16,0x656640:16,0x656650:16,0x656664:1,0x656665:1,0x656666:1,0x656668:4,0x65666c:4,0x656670:16,0x656800:1024,0x656e40:16,0x656e50:16,0x656e60:16,0x656e74:4,0x656e78:4,0x656e7c:4,0x657800:1024,0x657c00:256,0x657d00:256,0x657e00:256,0x658000:4,0x658008:4,0x65800c:4,0x658010:16,0x658020:16,0x658030:16,0x658100:256,0x658200:256,0x658300:256,0x658400:1024,0x659000:1024,0x659400:1024,0x659800:1024,0x659c00:1024,0x65c000:1024,0x65c400:1024,0x65c800:256,0x65c900:256,0x65cb80:16,0x65cb90:16,0x65cba0:4,0x65cba4:4,0x65cbac:4,0x65cbb0:16,0x65cc00:1024,0x65e000:1024,0x65e400:1024,0x65e800:256,0x65e900:256,0x65ea40:4,0x65ea44:4,0x65ea4c:4,0x65ea50:16,0x65ea60:16,0x65ea70:16,0x65ec00:1024,0x65f000:1024,0x65f400:1024,0x65f800:256,0x65f900:256,0x65fb00:4,0x65fb08:4,0x65fb0c:4,0x65fb10:16,0x65fb20:16,0x65fb30:16,0x65fb40:64,0x65fb80:64,0x65fbc0:64,0x65fc00:256,0x65fd00:256,0x65fe00:256},{},{0x670108:4,0x670114:4,0x670118:4,0x670148:4,0x670158:4,0x6701a8:4,0x67026c:4,0x67029c:4,0x6702a4:4,0x6702c8:4,0x6702cc:4,0x6702d0:4,0x6702d4:4,0x670354:4,0x670358:4,0x67035c:4,0x670360:4,0x670364:4,0x670368:4,0x67036c:4,0x670370:4,0x670374:4,0x670378:4,0x67037c:4,0x670380:4,0x670384:4,0x670388:4,0x67038c:4,0x670394:4,0x670398:4,0x67039c:4,0x670438:4,0x6704a8:4,0x6704b8:4,0x6704e0:4,0x670524:4,0x670534:4,0x670538:4,0x670598:4,0x6705a8:4,0x6705c0:4,0x6705fc:4,0x67064c:4,0x67066c:4,0x6706dc:4,0x6706e4:4,0x670704:4,0x67071c:4,0x67078c:4,0x6707d4:4,0x6707d8:4,0x6707dc:4,0x670804:4,0x670808:4,0x670820:4,0x670834:4,0x670844:4,0x67086c:4,0x67089c:4,0x6708c8:4,0x6708cc:4,0x6708dc:4,0x670908:4,0x670918:4,0x67096c:4,0x670998:4,0x6709f8:4,0x6709fc:4,0x670a00:4,0x670a10:4,0x670a54:4,0x670a8c:4,0x670ba8:4,0x670bb4:4,0x670c20:4,0x670c44:4,0x670c5c:4,0x670c88:4,0x670cb8:4,0x670ce8:4,0x670d0c:4,0x670d48:1,0x670d49:1,0x670d7c:4,0x670d90:4,0x670dc4:4,0x670ddc:4,0x670df4:4,0x670e54:4,0x670e64:4,0x670e70:4,0x670e84:4,0x670e88:4,0x670e9c:4,0x670ef0:4,0x670f04:4,0x670f08:4,0x670f10:4,0x670f60:4,0x670fc8:4,0x671034:4,0x671050:4,0x671054:4,0x671058:4,0x67106c:4,0x67107c:4,0x671128:4,0x671178:4,0x671188:4,0x6711a0:4,0x6711cc:4,0x6711e4:4,0x6712c0:4,0x6712d0:4,0x6712d4:4,0x6712e0:4,0x671300:4,0x67130c:4,0x671328:4,0x67132c:4,0x671340:4,0x671344:4,0x671348:4,0x6713e8:4,0x67140c:4,0x671420:4,0x67142c:4,0x671444:4,0x671470:4,0x671480:4,0x6714a0:4,0x6714f8:4,0x671570:4,0x671574:4,0x671588:4,0x67158c:4,0x6715b0:4,0x6715d0:4,0x6715f0:4,0x671600:4,0x671604:4,0x671608:4,0x67160c:4,0x671610:4,0x671614:4,0x671618:4,0x67161c:4,0x671620:4,0x671624:4,0x671628:4,0x67162c:4,0x671630:4,0x671634:4,0x671638:4,0x67163c:4,0x671640:4,0x671644:4,0x671648:4,0x67164c:4,0x671650:4,0x671654:4,0x671658:4,0x67165c:4,0x671664:4,0x671668:4,0x67166c:4,0x671670:4,0x671674:4,0x671678:4,0x67167c:4,0x6716bc:4,0x6716e4:4,0x6716fc:4,0x671708:4,0x671738:4,0x6717a0:4,0x6717a4:4,0x6717b0:4,0x6717e4:4,0x671874:4,0x671880:4,0x671890:4,0x6718b0:4,0x6718b8:4,0x6718dc:4,0x6718e4:4,0x6718f8:4,0x6718fc:4,0x671908:1,0x671909:1,0x671914:4,0x671918:4,0x67191c:4,0x671920:4,0x671924:4,0x671928:4,0x671930:4,0x671940:4,0x671944:4,0x671994:4,0x67199c:4,0x6719d8:4,0x671a00:4,0x671a40:4,0x671a4c:4,0x671a74:4,0x671a84:4,0x671a9c:4,0x671aa0:4,0x671ae4:4,0x671af0:4,0x671b04:4,0x671b0c:4,0x671b18:4,0x671b38:4,0x671b60:4,0x671bd0:4,0x671bf0:4,0x671c04:4,0x671c08:4,0x671ccc:4,0x671cd4:4,0x671d10:4,0x671d80:4,0x671d84:4,0x671d88:4,0x671e14:4,0x671e60:4,0x671e94:4,0x671ec8:4,0x671ee4:4,0x671eec:4,0x671f00:4,0x671f30:4,0x671f34:4,0x671f38:4,0x671f3c:4,0x671f40:4,0x671f44:4,0x671f94:4,0x671fa0:4,0x671fa8:4,0x671fc8:4,0x671fec:4,0x672000:4,0x672004:4,0x672008:4,0x67200c:4,0x672010:4,0x672014:4,0x672018:4,0x67201c:4,0x672020:4,0x672024:4,0x672028:4,0x67202c:4,0x672030:4,0x672034:4,0x672038:4,0x67203c:4,0x672040:4,0x672044:4,0x672048:4,0x67204c:4,0x672050:4,0x672054:4,0x672058:4,0x67205c:4,0x672060:4,0x672064:4,0x672068:4,0x67206c:4,0x672070:4,0x672074:4,0x672078:4,0x67207c:4,0x672080:4,0x672084:4,0x672088:4,0x67208c:4,0x672090:4,0x672094:4,0x672098:4,0x67209c:4,0x6720a0:4,0x6720a4:4,0x6720a8:4,0x6720ac:4,0x6720b0:4,0x6720b4:4,0x6720b8:4,0x6720bc:4,0x6720c0:4,0x6720c4:4,0x6720c8:4,0x6720cc:4,0x6720d0:4,0x6720d4:4,0x6720d8:4,0x6720dc:4,0x6720e0:4,0x6720e4:4,0x6720e8:4,0x6720ec:4,0x6720f0:4,0x6720f4:4,0x6720f8:4,0x6720fc:4,0x672100:4,0x672104:4,0x672108:4,0x67210c:4,0x672110:4,0x672114:4,0x672118:4,0x67211c:4,0x672120:4,0x672124:4,0x672128:4,0x67212c:4,0x672130:4,0x672134:4,0x672138:4,0x67213c:4,0x672140:4,0x672144:4,0x672148:4,0x67214c:4,0x672150:4,0x672154:4,0x672158:4,0x67215c:4,0x672160:4,0x672164:4,0x672168:4,0x67216c:4,0x672170:4,0x672174:4,0x672178:4,0x67217c:4,0x672180:4,0x672184:4,0x672188:4,0x67218c:4,0x672190:4,0x672194:4,0x672198:4,0x67219c:4,0x6721a0:4,0x6721a4:4,0x6721a8:4,0x6721ac:4,0x6721b0:4,0x6721b4:4,0x6721b8:4,0x6721bc:4,0x6721c0:4,0x6721c4:4,0x6721c8:4,0x6721cc:4,0x6721d0:4,0x6721d4:4,0x6721d8:4,0x6721dc:4,0x6721e0:4,0x6721e4:4,0x6721e8:4,0x6721ec:4,0x6721f0:4,0x6721f4:4,0x6721f8:4,0x6721fc:4,0x672200:4,0x672204:4,0x672208:4,0x67220c:4,0x672210:4,0x672214:4,0x672218:4,0x67221c:4,0x672220:4,0x672224:4,0x672228:4,0x67222c:4,0x672230:4,0x672234:4,0x672238:4,0x67223c:4,0x672240:4,0x672244:4,0x672248:4,0x67224c:4,0x672250:4,0x672254:4,0x672258:4,0x67225c:4,0x672260:4,0x672264:4,0x672268:4,0x67226c:4,0x672270:4,0x672274:4,0x672278:4,0x67227c:4,0x672280:4,0x672284:4,0x672288:4,0x67228c:4,0x672290:4,0x672294:4,0x672298:4,0x67229c:4,0x6722a0:4,0x6722a4:4,0x6722a8:4,0x6722ac:4,0x6722b0:4,0x6722b4:4,0x6722b8:4,0x6722bc:4,0x6722c0:4,0x6722c4:4,0x6722c8:4,0x6722cc:4,0x6722d0:4,0x6722d4:4,0x6722d8:4,0x6722dc:4,0x6722e0:4,0x6722e4:4,0x6722e8:4,0x6722ec:4,0x6722f0:4,0x6722f4:4,0x6722f8:4,0x6722fc:4,0x672300:4,0x672304:4,0x672308:4,0x67230c:4,0x672310:4,0x672314:4,0x672318:4,0x67231c:4,0x672320:4,0x672324:4,0x672328:4,0x67232c:4,0x672330:4,0x672368:4,0x672374:4,0x6723c8:4,0x6723dc:4,0x672414:4,0x67241c:4,0x672424:4,0x672438:4,0x67243c:4,0x672440:4,0x672448:4,0x672460:4,0x672484:4,0x672488:4,0x6724a0:4,0x6724a4:4,0x6724a8:4,0x6724ac:4,0x6724b0:4,0x6724b4:4,0x6724b8:4,0x6724bc:4,0x6724c0:4,0x6724c4:4,0x6724c8:4,0x6724cc:4,0x6724d0:4,0x6724d4:4,0x6724d8:4,0x6724dc:4,0x6724e0:4,0x6724e4:4,0x6724e8:4,0x6724ec:4,0x6724f0:4,0x6724f4:4,0x672500:4,0x67250c:4,0x672510:4,0x672518:4,0x67252c:4,0x672534:4,0x672538:4,0x672548:4,0x672564:4,0x672568:4,0x67257c:4,0x672588:4,0x67258c:4,0x672590:4,0x672594:4,0x672598:4,0x67259c:4,0x6725a0:4,0x6725a4:4,0x6725ac:4,0x6725b0:4,0x6725d0:4,0x6725d4:4,0x6725d8:4,0x6725dc:4,0x6725f8:4,0x6725fc:4,0x672600:4,0x672620:4,0x672628:4,0x67262c:4,0x672638:4,0x67264c:4,0x672654:4,0x67265c:4,0x672660:4,0x672674:4,0x672684:4,0x67268c:4,0x6726dc:4,0x6726e0:4,0x6726e4:4,0x6726e8:4,0x6726fc:4,0x672710:4,0x672740:4,0x672758:4,0x672764:4,0x672768:4,0x67276c:4,0x6727a0:4,0x6727a4:4,0x6727a8:4,0x6727ac:4,0x6727b0:4,0x6727b4:4,0x6727b8:4,0x6727bc:4,0x6727c8:4,0x6727cc:4,0x6727d0:4,0x6727d4:4,0x6727d8:4,0x6727dc:4,0x6727e0:4,0x6727e4:4,0x6727e8:4,0x67280c:4,0x672810:4,0x672814:4,0x672818:4,0x67281c:4,0x672820:4,0x672824:4,0x672828:4,0x67282c:4,0x672858:4,0x672864:4,0x672870:4,0x6728c0:4,0x6728d4:4,0x6728dc:4,0x6728e4:4,0x6728e8:4,0x6728ec:4,0x6728f0:4,0x6728f4:4,0x6728f8:4,0x6728fc:4,0x672900:4,0x672910:4,0x672934:4,0x672974:4,0x67298c:4,0x672994:4,0x672998:4,0x6729a0:4,0x6729a4:4,0x6729dc:4,0x6729e0:4,0x6729e4:4,0x6729e8:4,0x672a08:4,0x672a18:4,0x672a1c:4,0x672a20:4,0x672a40:4,0x672a44:4,0x672a4c:4,0x672a68:4,0x672ab4:4,0x672ae8:4,0x672b10:4,0x672b54:4,0x672b60:4,0x672b64:4,0x672b68:4,0x672b7c:4,0x672b84:4,0x672bb8:4,0x672bc0:4,0x672bc4:4,0x672bd0:4,0x672bdc:4,0x672be0:4,0x672be8:4,0x672bf0:4,0x672c38:4,0x672c50:4,0x672c58:4,0x672c78:4,0x672c7c:4,0x672c84:4,0x672c90:4,0x672ca8:4,0x672cb0:4,0x672cb4:4,0x672cb8:4,0x672cbc:4,0x672cc0:4,0x672cc4:4,0x672cc8:4,0x672ccc:4,0x672ce0:4,0x672cec:4,0x672cf0:4,0x672cf4:4,0x672cf8:4,0x672cfc:4,0x672d00:4,0x672d04:4,0x672d08:4,0x672d0c:4,0x672d10:4,0x672d14:4,0x672d18:4,0x672d1c:4,0x672d20:4,0x672d24:4,0x672d28:4,0x672d2c:4,0x672d30:4,0x672d34:4,0x672d38:4,0x672d3c:4,0x672d48:4,0x672d4c:4,0x672d50:4,0x672d54:4,0x672d58:4,0x672d5c:4,0x672d60:4,0x672d64:4,0x672d68:4,0x672d6c:4,0x672d70:4,0x672d74:4,0x672d78:4,0x672d7c:4,0x672d80:4,0x672d84:4,0x672d88:4,0x672d8c:4,0x672d90:4,0x672d94:4,0x672d98:4,0x672d9c:4,0x672da0:4,0x672da4:4,0x672da8:4,0x672dac:4,0x672db0:4,0x672db4:4,0x672db8:4,0x672dbc:4,0x672dc0:4,0x672dc4:4,0x672dc8:4,0x672dcc:4,0x672dd0:4,0x672dd4:4,0x672dd8:4,0x672ddc:4,0x672de0:4,0x672df8:4,0x672e00:4,0x672e0c:4,0x672e10:4,0x672e14:4,0x672e18:4,0x672e1c:4,0x672e20:4,0x672e24:4,0x672e28:4,0x672e2c:4,0x672e30:4,0x672e34:4,0x672e38:4,0x672e3c:4,0x672e40:4,0x672e44:4,0x672e48:4,0x672e4c:4,0x672e50:4,0x672e54:4,0x672e58:4,0x672e5c:4,0x672e60:4,0x672e64:4,0x672e68:4,0x672e6c:4,0x672e70:4,0x672e74:4,0x672e78:4,0x672e7c:4,0x672e80:4,0x672e84:4,0x672e88:4,0x672e98:4,0x672e9c:4,0x672ea0:4,0x672ea4:4,0x672ea8:4,0x672eac:4,0x672eb0:4,0x672eb4:4,0x672ef4:4,0x672ef8:4,0x672f04:4,0x672f14:4,0x672f24:4,0x672f28:4,0x672f30:4,0x672f50:4,0x672f60:4,0x672f6c:4,0x672f74:4,0x672f78:4,0x672f88:4,0x672f8c:4,0x672fc8:4,0x672fd4:4,0x672fdc:4,0x672ff8:4,0x673014:4,0x673034:4,0x67305c:4,0x673090:4,0x673094:4,0x673098:4,0x67309c:4,0x6730ca:1,0x6730cb:1,0x6730d8:4,0x6730dc:4,0x6730e0:4,0x6730e4:4,0x6730e8:4,0x6730ec:4,0x6730f0:4,0x6730f4:4,0x67310c:4,0x673114:4,0x673148:4,0x67314c:4,0x67315c:4,0x673160:4,0x67316c:4,0x673180:4,0x6731b0:4,0x6731b4:4,0x6731c4:4,0x6731f8:4,0x673224:4,0x67322c:4,0x673230:4,0x673234:4,0x673238:4,0x67323c:4,0x673240:4,0x673244:4,0x673248:4,0x67326c:4,0x673270:4,0x673274:4,0x673278:4,0x67327c:4,0x673284:4,0x673288:4,0x67328c:4,0x6732ac:4,0x6732b0:4,0x6732b4:4,0x6732b8:4,0x6732bc:4,0x6732c0:4,0x6732c4:4,0x6732c8:4,0x6732dc:4,0x6732e0:4,0x6732e4:4,0x6732e8:4,0x6732ec:4,0x6732f0:4,0x6732f4:4,0x6732f8:4,0x673428:4,0x673448:4,0x67344c:4,0x673450:4,0x673454:4,0x673460:4,0x673464:4,0x673468:4,0x6734a0:4,0x6734a4:4,0x6734ac:4,0x6734b0:4,0x6734b8:4,0x6734c4:4,0x673504:4,0x673540:4,0x673544:4,0x67355c:4,0x673564:4,0x67357c:4,0x673580:4,0x673584:4,0x673588:4,0x67358c:4,0x673590:4,0x6735a0:4,0x6735b4:4,0x6735cc:4,0x6735d0:4,0x6735d8:4,0x6735ec:4,0x6735f8:4,0x673608:4,0x673630:4,0x67363c:4,0x6736a0:4,0x6736a4:4,0x6736d4:4,0x6736e4:4,0x6736f0:4,0x673718:4,0x673750:4,0x673778:4,0x673798:4,0x6737ac:4,0x6737cc:4,0x6737d0:4,0x6737e4:4,0x6737ec:4,0x6737f0:4,0x673808:4,0x673810:4,0x673814:4,0x673820:4,0x673834:4,0x673838:4,0x67383c:4,0x673848:4,0x67384c:4,0x673864:4,0x673868:4,0x67388c:4,0x673898:4,0x6738b8:4,0x6738c8:4,0x6738d8:4,0x67390c:4,0x673934:4,0x673938:4,0x67394c:4,0x67396c:4,0x673988:4,0x6739c4:4,0x673a18:4,0x673ab6:1,0x673ab7:1,0x673b4c:4,0x673b64:4,0x673b70:4,0x673b74:4,0x673b78:4,0x673b7c:4,0x673b80:4,0x673b94:4,0x673ba4:4,0x673bd8:4,0x673c20:4,0x673c2c:4,0x673ca4:4,0x673ce4:4,0x673cec:4,0x673d3c:4,0x673d68:4,0x673d8c:4,0x673d98:4,0x673d9c:4,0x673da0:4,0x673dac:4,0x673db0:4,0x673db8:4,0x673dbc:4,0x673e18:4,0x673e34:4,0x673e48:4,0x673e4c:4,0x673e50:4,0x673e54:4,0x673e58:4,0x673e60:4,0x673e64:4,0x673e68:4,0x673e6c:4,0x673e70:4,0x673e74:4,0x673e78:4,0x673e7c:4,0x673e80:4,0x673e84:4,0x673e9c:4,0x673ea0:4,0x673ea4:4,0x673ea8:4,0x673eac:4,0x673eb0:4,0x673eb4:4,0x673eb8:4,0x673ebc:4,0x673ec0:4,0x673ecc:4,0x673ed0:4,0x673ed4:4,0x673ed8:4,0x673edc:4,0x673ee0:4,0x673f20:4,0x673f24:4,0x673f28:4,0x673f2c:4,0x673f30:4,0x673f34:4,0x673f38:4,0x673f3c:4,0x673f40:4,0x673f44:4,0x673f48:4,0x673f4c:4,0x673f50:4,0x673f54:4,0x673f58:4,0x673f8c:4,0x673f90:4,0x673f98:4,0x673fa0:4,0x673fa4:4,0x673fa8:4,0x673fac:4,0x673fb0:4,0x673fb4:4,0x673fb8:4,0x673fc0:4,0x673fc4:4,0x673fc8:4,0x673fcc:4,0x673fd0:4,0x673ff0:4,0x673ff4:4,0x673ff8:4,0x673ffc:4,0x67c000:4,0x67c004:4,0x67c008:4,0x67c00c:4,0x67c010:4,0x67c014:4,0x67c018:4,0x67c01c:4,0x67c030:4,0x67c034:4,0x67c038:4,0x67c054:4,0x67c058:4,0x67c05c:4,0x67c060:4,0x67c064:4,0x67c068:4,0x67c06c:4,0x67c070:4,0x67c080:4,0x67c084:4,0x67c088:4,0x67c08c:4,0x67c090:4,0x67c0a4:4,0x67c0bc:4,0x67c0d0:4,0x67c0d4:4,0x67c0d8:4,0x67c0fc:4,0x67c128:4,0x67c12c:4,0x67c178:4,0x67c17c:4,0x67c18c:4,0x67c190:4,0x67c194:4,0x67c1a0:4,0x67c1bc:4,0x67c1c0:4,0x67c1d4:4,0x67c1d8:4,0x67c1dc:4,0x67c1e0:4,0x67c1e4:4,0x67c1e8:4,0x67c1ec:4,0x67c1f0:4,0x67c210:4,0x67c2e6:1,0x67c2e7:1,0x67c368:4,0x67c370:4,0x67c388:4,0x67c394:4,0x67c398:4,0x67c3a0:4,0x67c3c0:4,0x67c43c:4,0x67c440:4,0x67c448:4,0x67c458:4,0x67c45c:4,0x67c460:4,0x67c4a8:4,0x67c4b8:4,0x67c4cc:4,0x67c5b4:4,0x67c5e4:4,0x67c5fc:4,0x67c614:4,0x67c63c:4,0x67c640:4,0x67c648:4,0x67c67c:4,0x67c69c:4,0x67c6b4:4,0x67c6c4:4,0x67c6c8:4,0x67c6d8:4,0x67c6dc:4,0x67c6e0:4,0x67c6e4:4,0x67c6e8:4,0x67c6ec:4,0x67c6f0:4,0x67c6f4:4,0x67c7a4:4,0x67c7c4:4,0x67c7e4:4,0x67c7f8:4,0x67c7fc:4,0x67c81c:4,0x67c820:4,0x67c834:4,0x67c840:4,0x67c844:4,0x67c888:4,0x67c88c:4,0x67c890:4,0x67c894:4,0x67c898:4,0x67c89c:4,0x67c8a0:4,0x67c8a4:4,0x67c8a8:4,0x67c8ac:4,0x67c8b0:4,0x67c8b4:4,0x67c8b8:4,0x67c8bc:4,0x67c8c0:4,0x67c8dc:4,0x67c8e0:4,0x67c8e4:4,0x67c8e8:4,0x67c8ec:4,0x67c8f0:4,0x67c8f4:4,0x67c8f8:4,0x67c8fc:4,0x67c900:4,0x67c904:4,0x67c908:4,0x67c90c:4,0x67c910:4,0x67c914:4,0x67c91c:4,0x67c920:4,0x67c924:4,0x67c928:4,0x67c92c:4,0x67c930:4,0x67c934:4,0x67c938:4,0x67c93c:4,0x67c940:4,0x67c94c:4,0x67c950:4,0x67c954:4,0x67c958:4,0x67c95c:4,0x67c960:4,0x67c964:4,0x67c968:4,0x67c96c:4,0x67c970:4,0x67c974:4,0x67c978:4,0x67c998:4,0x67c99c:4,0x67c9a0:4,0x67c9a4:4,0x67c9a8:4,0x67c9ac:4,0x67c9b0:4,0x67c9b4:4,0x67c9b8:4,0x67c9bc:4,0x67c9c0:4,0x67c9c4:4,0x67c9c8:4,0x67c9cc:4,0x67c9d0:4,0x67c9d4:4,0x67c9d8:4,0x67c9dc:4,0x67c9e0:4,0x67c9e4:4,0x67c9e8:4,0x67c9ec:4,0x67c9f0:4,0x67c9f4:4,0x67c9f8:4,0x67c9fc:4,0x67ca00:4,0x67ca04:4,0x67ca08:4,0x67ca0c:4,0x67ca10:4,0x67ca14:4,0x67ca18:4,0x67ca1c:4,0x67ca20:4,0x67ca24:4,0x67ca28:4,0x67ca2c:4,0x67ca38:4,0x67ca3c:4,0x67ca40:4,0x67ca44:4,0x67ca48:4,0x67ca4c:4,0x67ca50:4,0x67ca54:4,0x67ca58:4,0x67ca5c:4,0x67ca60:4,0x67ca64:4,0x67ca68:4,0x67ca6c:4,0x67ca70:4,0x67ca74:4,0x67ca78:4,0x67ca7c:4,0x67ca80:4,0x67ca84:4,0x67ca88:4,0x67ca8c:4,0x67ca90:4,0x67ca98:4,0x67ca9c:4,0x67caa0:4,0x67caa4:4,0x67caa8:4,0x67caac:4,0x67cab0:4,0x67cab4:4,0x67cab8:4,0x67cabc:4,0x67cac0:4,0x67cac4:4,0x67cac8:4,0x67cacc:4,0x67cad4:4,0x67cae4:4,0x67caec:4,0x67caf0:4,0x67caf4:4,0x67caf8:4,0x67cafc:4,0x67cb00:4,0x67cb04:4,0x67cb08:4,0x67cb0c:4,0x67cb10:4,0x67cb14:4,0x67cb18:4,0x67cb1c:4,0x67cb20:4,0x67cb34:4,0x67cb38:4,0x67cb60:4,0x67cb64:4,0x67cb68:4,0x67cb6c:4,0x67cb70:4,0x67cb74:4,0x67cb78:4,0x67cb7c:4,0x67cb80:4,0x67cb8c:4,0x67cba4:4,0x67cba8:4,0x67cbc0:4,0x67cbc8:4,0x67cbd4:4,0x67cbd8:4,0x67cc18:4,0x67cc48:4,0x67cc58:4,0x67cc70:4,0x67cc88:4,0x67cc8c:4,0x67cc90:4,0x67cc94:4,0x67cc98:4,0x67ccc4:4,0x67cce8:4,0x67ccec:4,0x67cd04:4,0x67cd08:4,0x67cd28:4,0x67cd2c:4,0x67cd34:4,0x67cd6c:4,0x67cd74:4,0x67cd78:4,0x67cd88:4,0x67cda2:1,0x67cdbc:4,0x67cdc0:4,0x67cdc4:4,0x67cdc8:4,0x67cdec:4,0x67cdf8:4,0x67cdfc:4,0x67ce00:4,0x67ce2c:4,0x67ce6c:4,0x67ce94:4,0x67cf30:4,0x67cf68:4,0x67cfa4:4,0x67cfb8:4,0x67cfbc:4,0x67cfc0:4,0x67cfc4:4,0x67cfc8:4,0x67cfcc:4,0x67cfd0:4,0x67cfd4:4,0x67cfdc:4,0x67cfe4:4,0x67cfe8:4,0x67d00c:4,0x67d010:4,0x67d01c:4,0x67d028:4,0x67d02c:4,0x67d030:4,0x67d094:4,0x67d170:4,0x67d188:4,0x67d1c8:4,0x67d1d0:4,0x67d1d8:4,0x67d1e8:4,0x67d200:4,0x67d260:4,0x67d29c:4,0x67d2a0:4,0x67d2a4:4,0x67d2a8:4,0x67d2ac:4,0x67d2b0:4,0x67d2b4:4,0x67d2b8:4,0x67d2bc:4,0x67d2d8:4,0x67d32c:4,0x67d360:4,0x67d364:4,0x67d39c:4,0x67d3a4:4,0x67d3a8:4,0x67d3c0:4,0x67d3dc:4,0x67d3e0:4,0x67d3e4:4,0x67e010:4,0x67e028:4,0x67e02c:4,0x67e03c:4,0x67e050:4,0x67e0dc:4,0x67e0e0:4,0x67e0e4:4,0x67e0e8:4,0x67e154:4,0x67e210:4,0x67e228:4,0x67e238:4,0x67e23c:4,0x67e250:4,0x67e274:4,0x67e284:4,0x67e29c:4,0x67e2b4:4,0x67e2c4:4,0x67e330:4,0x67e348:4,0x67e34c:4,0x67e350:4,0x67e364:4,0x67e378:4,0x67e384:4,0x67e388:4,0x67e3c4:4,0x67e3cc:4,0x67e3d4:4,0x67e3e4:4,0x67e40c:4,0x67e41c:4,0x67e444:4,0x67e458:4,0x67e480:4,0x67e4a0:4,0x67e4b0:4,0x67e4cc:4,0x67e4d0:4,0x67e4e4:4,0x67e4e8:4,0x67e514:4,0x67e588:4,0x67e594:4,0x67e5ac:4,0x67e5d4:4,0x67e5d8:4,0x67e5dc:4,0x67e5e4:4,0x67e5ec:4,0x67e5f0:4,0x67e600:4,0x67e61c:4,0x67e628:4,0x67e62c:4,0x67e660:4,0x67e6c4:4,0x67e6c8:4,0x67e6cc:4,0x67e6d4:4,0x67e6ec:4,0x67e710:4,0x67e714:4,0x67e740:4,0x67e744:4,0x67e790:4,0x67e7b4:4,0x67e7b8:4,0x67e7f4:4,0x67e804:4,0x67e890:4,0x67e8d4:4,0x67e904:4,0x67e92c:4,0x67e934:4,0x67e968:4,0x67e980:4,0x67e988:4,0x67e9e4:4,0x67ea00:4,0x67ea14:4,0x67ea38:4,0x67ea7c:4,0x67ea80:4,0x67eaac:4,0x67eab4:4,0x67eaf4:4,0x67eb10:4,0x67eb30:4,0x67eb38:4,0x67eb3c:4,0x67eb50:4,0x67eb54:4,0x67eb80:4,0x67eb84:4,0x67eb88:4,0x67eb8c:4,0x67eb90:4,0x67eb94:4,0x67ebb8:4,0x67ebc0:4,0x67ebc8:4,0x67ebdc:4,0x67ebe0:4,0x67ebe4:4,0x67ebe8:4,0x67ebec:4,0x67ebf0:4,0x67ebf4:4,0x67ebf8:4,0x67ebfc:4,0x67ec00:4,0x67ec04:4,0x67ec08:4,0x67ec0c:4,0x67ec10:4,0x67ec14:4,0x67ec18:4,0x67ec1c:4,0x67ec20:4,0x67ec24:4,0x67ec28:4,0x67ec2c:4,0x67ec30:4,0x67ec34:4,0x67ec38:4,0x67ec3c:4,0x67ec40:4,0x67ec44:4,0x67ec48:4,0x67ec4c:4,0x67ec50:4,0x67ec54:4,0x67ec58:4,0x67ec5c:4,0x67ec60:4,0x67ec78:4,0x67ecb8:4,0x67ecdc:4,0x67ece8:4,0x67ecf0:4,0x67ecf4:4,0x67ecf8:4,0x67ecfc:4,0x67ed00:4,0x67ed04:4,0x67ed08:4,0x67ed0c:4,0x67ed18:4,0x67ed1c:4,0x67ed44:4,0x67ed58:4,0x67ed98:4,0x67edb0:4,0x67edb4:4,0x67edb8:4,0x67edbc:4,0x67edc0:4,0x67edc4:4,0x67edc8:4,0x67edcc:4,0x67edd0:4,0x67edd4:4,0x67edd8:4,0x67eddc:4,0x67ede0:4,0x67ede4:4,0x67ede8:4,0x67edec:4,0x67edf0:4,0x67edf4:4,0x67edf8:4,0x67edfc:4,0x67ee00:4,0x67ee04:4,0x67ee10:4,0x67ee14:4,0x67ee18:4,0x67ee1c:4,0x67ee20:4,0x67ee24:4,0x67ee28:4,0x67ee2c:4,0x67ee30:4,0x67ee34:4,0x67ee38:4,0x67ee58:4,0x67ee5c:4,0x67ee60:4,0x67ee84:4,0x67ee8c:4,0x67ee90:4,0x67eea0:4,0x67eea4:4,0x67eea8:4,0x67eeac:4,0x67eeb0:4,0x67eeb4:4,0x67eeb8:4,0x67eebc:4,0x67eec4:4,0x67eecc:4,0x67eefc:4,0x67ef00:4,0x67ef28:4,0x67ef2c:4,0x67ef44:4,0x67ef60:4,0x67ef98:4,0x67ef9c:4,0x67efb0:4,0x67efb4:4,0x67efb8:4,0x67efc0:4,0x67efc4:4,0x67efcc:4,0x67efd0:4,0x67efe0:4,0x67eff4:4,0x67f010:4,0x67f024:4,0x67f048:4,0x67f054:4,0x67f07c:4,0x67f09c:4,0x67f0ac:4,0x67f0f4:4,0x67f10c:4,0x67f148:4,0x67f15c:4,0x67f160:4,0x67f1a0:4,0x67f1b8:4,0x67f1bc:4,0x67f1dc:4,0x67f208:4,0x67f240:4,0x67f280:4,0x67f284:4,0x67f2a0:4,0x67f2a8:4,0x67f2ac:4,0x67f2b0:4,0x67f2c8:4,0x67f2d4:4,0x67f2dc:4,0x67f2f0:4,0x67f388:4,0x67f3fc:4,0x67f410:4,0x67f43a:1,0x67f43b:1,0x67f43c:4,0x67f440:4,0x67f444:4,0x67f448:4,0x67f44c:4,0x67f450:4,0x67f454:4,0x67f474:4,0x67f4a4:4,0x67f4e8:4,0x67f4fc:4,0x67f517:1,0x67f534:4,0x67f53c:4,0x67f550:4,0x67f57c:4,0x67f580:4,0x67f608:4,0x67f60c:4,0x67f678:4,0x67f67c:4,0x67f684:4,0x67f698:4,0x67f69c:4,0x67f7a8:4,0x67f7ac:4,0x67f7b0:4,0x67f7c8:4,0x67f7d4:4,0x67f800:1,0x67f801:1,0x67f840:4,0x67f864:4,0x67f87c:4,0x67f898:4,0x67f8a8:4,0x67f8c0:4,0x67f8d4:4,0x67f8dc:4,0x67f8e0:4,0x67f8e4:4,0x67f908:4,0x67f90c:4,0x67f934:4,0x67f968:4,0x67f980:4,0x67f988:4,0x67f990:4,0x67f9a4:4,0x67f9a8:4,0x67f9ac:4,0x67f9b0:4,0x67f9bc:4,0x67f9c0:4,0x67f9f4:4,0x67f9fc:4,0x67fa20:4,0x67fa68:4,0x67fa7c:4,0x67fab4:4,0x67fac0:4,0x67fad8:4,0x67fae0:4,0x67faec:4,0x67faf8:4,0x67fafc:4,0x67fb20:4,0x67fb54:4,0x67fb60:4,0x67fb7c:4,0x67fb80:4,0x67fba0:4,0x67fbc0:4,0x67fbcc:4,0x67fbec:4,0x67fbf0:4,0x67fc1c:4,0x67fc24:4,0x67fc40:4,0x67fc68:4,0x67fcac:4,0x67fccc:4,0x67fcd0:4,0x67fce8:4,0x67fcf8:4,0x67fd04:4,0x67fd3c:4,0x67fdcc:4,0x67fddc:4,0x67fde0:4,0x67fde8:4,0x67fe08:4,0x67fe14:4,0x67fe40:4,0x67fe44:4,0x67fe48:4,0x67fe4c:4,0x67fe70:4,0x67feb0:4,0x67febc:4,0x67fec4:1,0x67fedc:4,0x67ff44:4,0x67ff58:4,0x67ff5c:4,0x67ff88:4,0x67ff8c:4,0x67ffb8:4,0x67ffc8:4,0x67ffd0:4,0x67ffd4:4,0x67ffe4:4},{},{},{0x6a0000:1,0x6a0002:1,0x6a0003:1,0x6a0004:4,0x6a0008:4,0x6a000c:4,0x6a0010:16,0x6a002c:4,0x6a0040:64,0x6a0200:256,0x6a0300:256,0x6a0400:1024,0x6a0800:256,0x6a0900:256,0x6a0b00:256,0x6a0c00:1024,0x6a1000:1024,0x6a1400:1024,0x6a1800:1024,0x6a1c00:1024,0x6a2000:1024,0x6a2400:1024,0x6a2800:1024,0x6a2c00:1024,0x6a3000:256,0x6a3100:256,0x6a3200:256,0x6a3400:1024,0x6a3800:1024,0x6a3c00:1024,0x6a4a00:256,0x6a4b00:256,0x6a5000:1024,0x6a5400:1024,0x6a5800:1024,0x6a5c00:1024,0x6a6c00:1024,0x6a7000:1024,0x6a7400:1024,0x6a7800:1024,0x6a7c00:1024,0x6ae000:1024,0x6ae400:1024,0x6ae800:1024,0x6aec00:1024},{},{},{},{0x6e0600:256,0x6e0700:256,0x6e1000:1024,0x6e2228:4,0x6e222c:4,0x6e2800:1024,0x6e2c0c:4,0x6e2c90:16,0x6e3000:256,0x6e3300:256,0x6e3400:256,0x6e3500:256,0x6e3800:1024,0x6e3c00:1024,0x6e4000:256,0x6e4100:256,0x6e4800:256,0x6e4900:256,0x6e4b00:64,0x6e4b40:64,0x6e4b80:16,0x6e4b90:16,0x6e4ba0:16,0x6e4bb0:16,0x6e4bc0:64,0x6e4c00:16,0x6e4c10:16,0x6e4c20:16,0x6e4c30:16,0x6e4c84:4,0x6e4c9c:4,0x6e4cb8:4,0x6e4cc0:64,0x6e4d00:64,0x6e4d40:64,0x6e5000:1024,0x6e5400:1024,0x6e5800:1024,0x6e5c44:4,0x6e5d20:16,0x6e5d30:16,0x6e5e00:256,0x6e5f00:256,0x6e6000:1024,0x6e6400:1024,0x6e6800:1024,0x6e6c00:1024,0x6e7000:1024,0x6e7400:1024,0x6e7800:1024,0x6e7c00:1024,0x6e9800:1024,0x6e9c00:256,0x6e9d00:256,0x6ea520:16,0x6ea530:16,0x6ea600:256,0x6ea700:256,0x6eacc0:64,0x6ead00:16,0x6ead10:16,0x6ead20:16,0x6ead40:16,0x6ead50:16,0x6ead60:16,0x6ead70:16,0x6eadc0:16,0x6eadd0:16,0x6eb000:1024,0x6eb400:1024,0x6eb800:1024,0x6ebc00:1024,0x6ec000:1024,0x6ec400:1024,0x6ec800:1024,0x6ecc00:1024,0x6ed000:1024,0x6ed400:1024,0x6ed800:1024,0x6edc00:1024,0x6ee400:1024,0x6ee820:16,0x6ee830:16,0x6eec00:256,0x6eed00:256,0x6ef000:1024,0x6ef400:1024,0x6ef800:1024,0x6efc00:1024},{0x6f0000:1024,0x6f0400:1024,0x6f0800:1024,0x6f0c00:1024,0x6f1000:1024,0x6f1400:1024,0x6f1800:1024,0x6f1c00:1024,0x6f2000:1024,0x6f2400:1024,0x6f2800:1024,0x6f2c00:1024,0x6f3000:1024,0x6f3400:1024,0x6f3800:1024,0x6f3c00:1024,0x6f4200:256,0x6f43c0:16,0x6f4440:16,0x6f4450:16,0x6f4800:1024,0x6f4c00:1024,0x6f5500:256,0x6f5bc0:16,0x6f5bd0:16,0x6f5cf8:4,0x6f5cfc:4,0x6f7000:256,0x6f7100:256,0x6f7200:256,0x6f7300:256,0x6f7400:256,0x6f7500:256,0x6f76c8:4,0x6f76cc:4,0x6f7740:64,0x6f7780:16,0x6f7790:16,0x6f7800:1024,0x6f7c00:256,0x6f7e00:256,0x6f7f00:256,0x6f8000:1024,0x6f8400:1024,0x6f8800:1024,0x6f8c00:1024,0x6f9000:1024,0x6f9400:1024,0x6f9800:1024,0x6f9c00:1024,0x6fa000:1024,0x6fa400:1024,0x6faa00:256,0x6fac00:1024,0x6fb000:1024,0x6fb400:1024,0x6fba00:256,0x6fbb00:256,0x6fc000:1024,0x6fc400:1024,0x6fc800:1024,0x6fcc00:1024,0x6fd000:1024,0x6fd400:1024,0x6fdd1c:1,0x6fdd80:64,0x6fddc0:64,0x6fde00:256,0x6fdf04:4,0x6fdf08:4,0x6fdf0c:4,0x6fdf10:4,0x6fdff0:4,0x6fdff8:4,0x6fe000:1024,0x6fe400:1024,0x6feb60:16,0x6feb70:16,0x6feb9c:4,0x6feba0:16,0x6febb0:16},{0x700000:1024,0x700400:1024,0x700800:1024,0x700c00:1024,0x701000:1024,0x701400:1024,0x701800:1024,0x701c00:1024,0x702000:1024,0x702400:1024,0x702800:1024,0x702c00:1024,0x703000:1024,0x703400:1024,0x703800:1024,0x703c00:1024,0x704000:256,0x704100:256,0x704200:256,0x704300:256,0x704900:256,0x704a00:256,0x704b00:256,0x705000:1024,0x705400:1024,0x705800:1024,0x705c00:1024,0x706000:256,0x706100:256,0x706200:256,0x706300:256,0x706400:1024,0x706d80:64,0x706dc0:64,0x706f00:256,0x707000:1024,0x707400:256,0x707500:256,0x707a00:256,0x707b00:256,0x707c00:1024,0x708000:1024,0x708400:256,0x708930:4,0x708934:4,0x70c000:1024,0x70e000:1024,0x70e400:1024,0x70e800:1024,0x70ec00:1024,0x70f000:1024,0x70f400:1024,0x70f800:1024,0x70fc00:1024},{0x710000:1024,0x710400:1024,0x710800:256,0x710900:256,0x710bc0:16,0x710bd0:16,0x710c00:1024,0x711000:256,0x711100:256,0x711200:256,0x7115e8:4,0x7115ec:4,0x711800:1024,0x711f00:256,0x712c00:1024,0x713000:1024,0x7134a0:16,0x7134b0:16,0x7134e4:4,0x713600:256,0x713700:256,0x713800:256,0x713900:256,0x713a00:256,0x713b00:64,0x713b40:64,0x713be0:4,0x713e00:256,0x713f00:256,0x714000:1024,0x714400:1024,0x714800:1024,0x714c00:1024,0x715000:1024,0x715400:1024,0x715800:1024,0x715c00:1024,0x716000:1024,0x716400:1024,0x716800:1024,0x716c00:1024,0x717000:1024,0x717400:1024,0x717800:1024,0x717c00:1024,0x718000:256,0x718100:256,0x718260:16,0x718270:4,0x718274:4,0x718400:1024,0x718800:1024,0x718c00:1024,0x71c200:256,0x71c300:256,0x71c564:4,0x71c800:256,0x71c900:256,0x71ca00:256,0x71cc00:1024,0x71d060:16,0x71d070:16,0x71d080:64,0x71d0c0:64,0x71d100:256,0x71d400:64,0x71d464:4,0x71d4b8:4,0x71d4bc:4,0x71d500:64,0x71d540:64,0x71d600:256,0x71d700:256,0x71da00:256,0x71db00:256,0x71dc00:1024,0x71e000:1024,0x71e400:1024,0x71e800:1024,0x71ec00:1024,0x71f000:1024,0x71f400:1024,0x71f800:1024},{0x721c00:256,0x721f40:4,0x721f44:4,0x723600:256,0x723700:256,0x723c00:1024,0x724000:1024,0x724400:256,0x724f40:64,0x725000:1024,0x725400:1024,0x725800:1024,0x725c00:1024,0x726000:1024,0x726400:1024,0x726800:1024,0x726e00:16,0x726e40:64,0x726f00:16,0x726f10:16,0x726fa0:16,0x726fb0:16,0x727000:1024,0x727400:256,0x727500:256,0x727600:256,0x727700:64,0x727740:64,0x727780:64,0x7277c0:4,0x7277c4:4,0x7277c8:4,0x7277cc:4,0x7277d0:16,0x7277e0:16,0x7277f0:16,0x728400:256,0x728700:256,0x728a00:256,0x728b00:256,0x728d40:4,0x728d44:4,0x728d50:4,0x728d54:4,0x728d80:64,0x72c400:256,0x72c500:256,0x72c6f8:4,0x72c6fc:4,0x72d000:1024,0x72d400:256,0x72d500:256,0x72d600:256,0x72d700:256,0x72d800:1024,0x72dc00:1024,0x72e000:1024,0x72e400:1024,0x72e800:1024,0x72ec00:1024,0x72f000:1024,0x72f400:1024,0x72f800:1024,0x72fc00:1024},{0x731800:1024,0x731c00:256,0x731d00:256,0x731f40:4,0x731f44:4,0x731f48:4,0x731f4c:4,0x732000:1024,0x732a38:4,0x732c00:256,0x732d00:256,0x732e00:256,0x732f00:256,0x733000:1024,0x733400:1024,0x733800:1024,0x733c00:1024,0x734540:16,0x735400:64,0x7354c0:16,0x7354d0:16,0x7355c0:64,0x736400:1024,0x736800:1024,0x737800:1024,0x737c10:16,0x739400:1024,0x739800:256,0x739900:256,0x739a00:256,0x739b00:256,0x739c00:256,0x739d00:256,0x739e00:256,0x739f00:256,0x73a640:16,0x73a650:16,0x73a800:1024,0x73ac00:1024,0x73b400:1024,0x73bb00:4,0x73bb04:4,0x73bb08:4,0x73bb0c:4,0x73be00:256,0x73bf00:256,0x73c000:1024,0x73c400:1024,0x73c800:1024,0x73cc00:1024,0x73d000:1024,0x73d400:1024,0x73d800:1024,0x73dc00:1024,0x73e000:1024,0x73e400:1024,0x73e800:1024,0x73ec00:1024},{0x740008:4,0x74000c:4,0x740018:4,0x74001c:4,0x740100:256,0x740200:256,0x740300:256,0x740400:1024,0x740800:1024,0x740d00:256,0x741000:1024,0x741400:1024,0x741800:1024,0x741c00:1024,0x743200:16,0x743400:1024,0x743800:256,0x743900:256,0x743a80:16,0x743ad0:16,0x743c00:1024,0x744200:64,0x744240:64,0x744488:4,0x74448c:4,0x7444b0:4,0x7444b4:4,0x744500:256,0x744600:64,0x744640:64,0x744c00:256,0x744d00:256,0x744e00:256,0x744f00:256,0x745500:256,0x745990:16,0x745a50:16,0x745ab8:4,0x745abc:4,0x745f00:256,0x747000:1024,0x747400:256,0x747500:256,0x748000:1024,0x748400:1024,0x748800:1024,0x748c00:1024,0x749000:1024,0x749400:1024,0x749800:1024,0x749c00:1024,0x74a000:1024,0x74a400:1024,0x74a800:1024,0x74ac00:1024,0x74b000:1024,0x74b400:1024,0x74b800:1024,0x74bc00:1024,0x74c000:256,0x74c110:16,0x74c120:16,0x74c130:16,0x74c198:4,0x74c1a4:4,0x74c1b0:4,0x74c1b4:4,0x74c200:256,0x74c300:256,0x74c400:256,0x74c5a0:4,0x74c5a4:4,0x74c600:256,0x74c700:64,0x74c740:64,0x74c780:16,0x74c790:16,0x74cc00:256,0x74cd00:256,0x74cf00:256,0x74d000:1024,0x74d4a0:16,0x74d528:4,0x74d52c:4,0x74d540:64,0x74d580:64,0x74d5c0:64,0x74d620:16,0x74d630:16,0x74d640:16,0x74d680:64,0x74d6c0:64,0x74d700:256,0x74d800:1024,0x74e000:1024,0x74e400:1024,0x74e800:1024,0x74ec00:1024,0x74f200:256,0x74f300:256,0x74f400:256,0x74f500:256,0x74f600:256,0x74f700:256,0x74f800:256,0x74f900:256,0x74fb40:64,0x74fc00:256,0x74fd00:256,0x74fe68:4,0x74fe6c:4,0x74fe80:64,0x74fec0:64,0x74ff80:64,0x74ffc0:64},{0x750800:1024,0x750c00:1024,0x751500:256,0x751600:256,0x751700:256,0x751800:1024,0x751c00:1024,0x752000:1024,0x752400:1024,0x752800:1024,0x752c00:256,0x752d00:256,0x753000:1024,0x753530:16,0x7535b0:16,0x753900:256,0x753a00:64,0x753a40:64,0x753b00:256,0x753c00:1024,0x754000:1024,0x754400:1024,0x754800:256,0x754900:256,0x754a40:16,0x754a50:16,0x754a80:64,0x754ac0:64,0x754b00:256,0x754c00:1024,0x755000:1024,0x755400:1024,0x755800:1024,0x755c00:1024,0x756400:256,0x756500:256,0x756710:16,0x756728:4,0x75672c:4,0x756748:4,0x75674c:4,0x756780:16,0x7568a8:4,0x7568ac:4,0x756a00:256,0x756b00:256,0x757000:1024,0x757400:1024,0x757840:64,0x757880:64,0x7578c0:64,0x757900:64,0x757940:64,0x757980:64,0x7579c0:4,0x7579c4:4,0x757a80:64,0x757ac0:64,0x757c00:1024,0x758000:1024,0x758400:1024,0x758800:1024,0x758c00:1024,0x759000:1024,0x759400:1024,0x759800:1024,0x759c00:1024,0x75a000:1024,0x75a400:1024,0x75a800:1024,0x75ac00:1024,0x75b000:1024,0x75b400:1024,0x75b800:1024,0x75bc00:1024},{0x761800:256,0x761900:256,0x761a00:256,0x761c00:256,0x761d00:256,0x761e00:256,0x761f00:256,0x764000:256,0x764100:256,0x764200:256,0x764370:16,0x764800:1024,0x764c00:1024,0x765000:256,0x765100:256,0x765400:256,0x765500:256,0x765820:16,0x765830:16,0x765840:64,0x765880:64,0x7658c0:64,0x765900:256,0x765bf0:16,0x766610:16,0x766620:4,0x766624:4,0x7667a4:4,0x7667a8:4,0x7667ac:4,0x7667b0:4,0x767000:1024,0x767400:1024,0x767800:1024,0x767c00:256,0x767d00:256,0x767e00:256,0x767f80:16,0x767f90:16,0x768400:1024,0x769000:1024,0x76b200:256,0x76b400:1024,0x76b800:64,0x76b840:64,0x76b880:64,0x76b8c0:64,0x76ba00:256,0x76bb00:256,0x76bc00:256,0x76be00:256,0x76bf00:256,0x76c000:256,0x76c100:16,0x76c120:16,0x76c130:16,0x76c140:16,0x76c160:16,0x76c170:16,0x76c180:64,0x76c1c0:64,0x76c200:64,0x76c240:64,0x76c280:64,0x76c2c0:64,0x76c300:64,0x76c340:64,0x76c380:64,0x76c3c0:64,0x76c400:1024,0x76ca00:256,0x76cb00:256,0x76cc00:1024,0x76d400:256,0x76d500:256,0x76e000:1024,0x76e400:256,0x76e500:256,0x76e600:256,0x76ef00:256,0x76f200:256,0x76f400:1024,0x76f800:1024,0x76fc00:1024},{0x770000:256,0x770100:256,0x770200:16,0x770210:16,0x770280:64,0x7702c0:64,0x770300:256,0x770400:1024,0x770800:256,0x770a00:64,0x770a40:64,0x770f88:4,0x770f8c:4,0x771000:256,0x7712c0:16,0x7712d0:4,0x7712d4:4,0x7712e0:16,0x7712f0:16,0x771300:256,0x771400:1024,0x771b40:64,0x771b80:16,0x771b90:16,0x771ba0:16,0x771bb0:16,0x771bc0:64,0x771c00:256,0x771d00:256,0x771e30:16,0x771fc0:16,0x771fd0:16,0x772000:1024,0x772400:256,0x772500:64,0x772540:64,0x772580:64,0x7725c0:64,0x772600:64,0x772640:64,0x772680:64,0x7726c0:16,0x7726d0:16,0x7726e0:16,0x7726f0:16,0x772700:256,0x772800:64,0x772840:16,0x772880:64,0x7728c0:64,0x772900:256,0x772a00:16,0x772a10:16,0x772a80:4,0x772a84:4,0x772a88:4,0x772a8c:4,0x772ae0:16,0x772af0:16,0x772c00:256,0x772d00:256,0x773000:1024,0x773400:1024,0x773900:256,0x773a00:256,0x773b80:64,0x773bc0:64,0x773c00:256,0x773d00:256,0x773e00:256,0x773f20:16,0x773f30:16,0x774bd0:16,0x774e00:256,0x774f00:256,0x775000:256,0x7752d0:16,0x775400:1024,0x775800:1024,0x776000:1024,0x776400:1024,0x776c00:256,0x776d00:256,0x777000:1024,0x777400:1024,0x777800:1024,0x777c00:1024,0x778000:1024,0x778400:1024,0x778800:1024,0x778c00:1024,0x779000:1024,0x7794a0:16,0x7794b0:16,0x7797c0:64,0x77a0c8:4,0x77a0cc:4,0x77a178:4,0x77a17c:4,0x77a180:64,0x77a1c0:64,0x77a200:256,0x77a300:256,0x77a400:1024,0x77b000:1024,0x77b400:1024,0x77b800:1024,0x77bc00:1024,0x77e800:256,0x77e900:256,0x77eb80:64,0x77f800:1024,0x77fc60:4,0x77fc64:4,0x77fcf0:16,0x77fd00:256,0x77fe00:256,0x77ff00:256},{0x780000:1024,0x780400:1024,0x780800:1024,0x780c00:1024,0x781800:1024,0x781e00:256,0x781f00:256,0x782000:1024,0x782400:1024,0x782800:1024,0x782c00:1024,0x783000:256,0x783100:256,0x783400:256,0x783500:256,0x783600:256,0x783700:256,0x784000:1024,0x784400:1024,0x784820:16,0x784830:16,0x784880:64,0x7848c0:64,0x784c00:1024,0x785000:1024,0x785400:1024,0x785808:4,0x78580c:4,0x785a00:256,0x785b00:256,0x785c00:256,0x785e00:256,0x785f00:256,0x788000:1024,0x788400:64,0x788440:64,0x788480:64,0x7884c0:64,0x788500:256,0x788600:256,0x788700:256,0x788810:4,0x788814:4,0x788880:64,0x788900:64,0x788940:64,0x788f80:16,0x788f90:16,0x78c000:1024,0x78c400:1024,0x78c800:1024,0x78cc00:1024,0x78d000:1024,0x78d400:1024,0x78d800:1024,0x78dc00:1024,0x78e000:1024,0x78e400:1024,0x78e800:1024,0x78ec00:1024,0x78f000:1024,0x78f400:1024,0x78f800:1024,0x78fc00:1024},{0x790008:4,0x79000c:4,0x790010:16,0x790400:256,0x790500:256,0x790800:1024,0x790c00:1024,0x791000:1024,0x791400:1024,0x791800:1024,0x791c00:256,0x791d00:256,0x791e00:256,0x791f00:256,0x792000:1024,0x792400:256,0x792500:256,0x792600:256,0x792700:256,0x792800:1024,0x792e00:64,0x792e4c:4,0x792e80:64,0x792ec0:64,0x792f00:256,0x793000:256,0x793100:256,0x793208:4,0x79320c:4,0x793300:256,0x7934a0:16,0x7934b0:16,0x7934d0:16,0x7934e0:16,0x7934f0:16,0x7936b0:4,0x7936b4:4,0x793700:64,0x793800:256,0x793900:256,0x793a00:64,0x793a40:64,0x793a88:4,0x793a8c:4,0x793a90:16,0x793aa0:4,0x793aa4:4,0x793b00:256,0x793c00:1024,0x794400:1024,0x794c00:256,0x794d00:256,0x794f80:64,0x795900:256,0x796480:64,0x7964c0:64,0x796500:64,0x7965d0:16,0x79c000:256,0x79c100:256,0x79c200:256,0x79c300:256,0x79c400:1024,0x79c8c0:4,0x79c8c4:4,0x79c900:256,0x79cc00:1024,0x79e000:1024,0x79e400:1024,0x79e800:1024,0x79ec00:1024,0x79f800:1024,0x79ff00:256},{0x7a0040:64,0x7a0080:64,0x7a00c0:64,0x7a0400:1024,0x7a0800:256,0x7a0900:256,0x7a0a00:64,0x7a0a40:64,0x7a0a80:4,0x7a0a84:1,0x7a0a85:1,0x7a0a86:1,0x7a0a87:1,0x7a0a88:1,0x7a0a89:1,0x7a0a8a:1,0x7a0a8b:1,0x7a0a8c:4,0x7a0a90:16,0x7a0aa0:16,0x7a0ab0:16,0x7a0ac0:64,0x7a0b00:64,0x7a0b40:64,0x7a0c00:256,0x7a0d00:256,0x7a0e00:256,0x7a3000:256,0x7a3100:64,0x7a3300:256,0x7a4000:1024,0x7a4400:1024,0x7a4800:1024,0x7a4c00:1024,0x7a5000:1024,0x7a5400:1024,0x7a5800:1024,0x7a5c00:1024,0x7a6000:256,0x7a6100:256,0x7a6600:16,0x7a6640:16,0x7a6650:16,0x7a7000:1024,0x7a7700:256,0x7a8064:4,0x7a8078:4,0x7a807c:4,0x7a8800:1024,0x7a8c00:1024,0x7a9080:64,0x7a90c0:64,0x7a98c0:64,0x7a9c00:1024,0x7abc00:1024,0x7ac000:1024,0x7ac600:256,0x7ac828:4,0x7ac82c:4,0x7ac840:64,0x7ac930:16,0x7acc00:1024,0x7ae000:1024,0x7ae400:1024,0x7ae800:1024,0x7aec00:1024,0x7af000:1024,0x7af400:1024,0x7af818:4,0x7af81c:4,0x7af830:16,0x7aff40:4,0x7aff44:4},{0x7b0080:64,0x7b0400:1024,0x7b0800:1024,0x7b0c00:1024,0x7b3180:64,0x7b31c0:64,0x7b32a0:16,0x7b32b0:16,0x7b3400:1024,0x7b3800:256,0x7b3900:256,0x7b3a00:64,0x7b3a40:64,0x7b3a80:64,0x7b3ac0:16,0x7b3ad0:16,0x7b3ae0:16,0x7b3af0:16,0x7b3b00:256,0x7b3c00:256,0x7b3d00:256,0x7b3e00:256,0x7b4000:1024,0x7b4400:1024,0x7b4800:1024,0x7b4c00:1024,0x7b5000:1024,0x7b5400:1024,0x7b5800:1024,0x7b5c00:1024,0x7b6000:256,0x7b6100:256,0x7b6200:64,0x7b6240:64,0x7b6380:64,0x7b63c0:64,0x7b6400:16,0x7b6410:16,0x7b6500:256,0x7b6700:64,0x7b6740:64,0x7b6c80:16,0x7b6cd0:16,0x7b7000:1024,0x7b7400:1024,0x7b7800:1024,0x7b7c00:1024,0x7b8000:1024,0x7b8400:1024,0x7b8850:16,0x7b8900:256,0x7b8a00:256,0x7b8b00:256,0x7b9000:1024,0x7b9400:256,0x7b9500:256,0x7b9600:256,0x7b9700:256,0x7b9800:1024,0x7b9c00:1024,0x7ba000:1024,0x7ba400:1024,0x7ba800:1024,0x7bac00:256,0x7bad00:256,0x7bae00:256,0x7baf00:256,0x7bb03c:4,0x7bb050:16,0x7bb100:256,0x7bb200:256,0x7bb300:256,0x7bb400:1024,0x7bb800:1024,0x7bbc00:1024,0x7bc400:256,0x7bc500:256,0x7bc780:64,0x7bc7c0:64,0x7bce00:256,0x7bcf00:256,0x7be800:1024,0x7bf200:64,0x7bf240:64,0x7bf2c0:4,0x7bf2c4:4,0x7bf400:1024,0x7bf900:256,0x7bfd00:256,0x7bfe60:4,0x7bfe64:4},{0x7c0640:64,0x7c0e00:256,0x7c0f00:256,0x7c1000:256,0x7c1100:256,0x7c1400:256,0x7c1500:16,0x7c1510:16,0x7c1520:16,0x7c1530:16,0x7c1540:64,0x7c1580:64,0x7c15c0:64,0x7c1600:256,0x7c1700:256,0x7c1cc0:64,0x7c1d00:64,0x7c1d40:64,0x7c1f00:256,0x7c2870:16,0x7c2880:64,0x7c28c0:16,0x7c28d0:16,0x7c28f0:4,0x7c2a00:64,0x7c2a40:64,0x7c2a80:64,0x7c2ac0:64,0x7c2f00:64,0x7c4000:256,0x7c4100:256,0x7c4200:64,0x7c4240:64,0x7c4300:256,0x7c4400:1024,0x7c4800:256,0x7c4900:256,0x7c4a00:256,0x7c4b00:256,0x7c4c00:1024,0x7c5800:256,0x7c5900:64,0x7c5940:64,0x7c5980:64,0x7c59c0:64,0x7c5a00:256,0x7c5b00:256,0x7c5c00:1024,0x7c6c08:4,0x7c6c0c:4,0x7c6c28:4,0x7c6c2c:4,0x7c6d60:4,0x7c6d64:4,0x7c7000:256,0x7c7100:256,0x7c7200:256,0x7c7300:256,0x7c7400:256,0x7c7500:256,0x7c7600:256,0x7c7700:256,0x7c7e00:256,0x7c7f00:256,0x7c8000:1024,0x7c8400:1024,0x7c9380:64,0x7c93c0:64,0x7c9700:256,0x7c9800:256,0x7c9c00:256,0x7ca000:256,0x7ca100:256,0x7ca200:256,0x7ca300:256,0x7ca400:1024,0x7cac00:256,0x7cad00:256,0x7cae00:256,0x7caf00:256,0x7cc000:256,0x7cc100:256,0x7cc400:256,0x7cc800:1024,0x7ccc00:1024,0x7cdc00:1024,0x7ce000:256,0x7ce100:256,0x7ce200:256,0x7ce300:256,0x7ce400:1024,0x7ce800:256,0x7ce900:256,0x7cea00:256,0x7ceb00:256,0x7cec00:1024,0x7cf000:64,0x7cf040:64,0x7cf080:64,0x7cf200:256,0x7cf3c0:64,0x7cf800:64,0x7cf840:64,0x7cf900:256,0x7cfa00:256,0x7cfb00:256,0x7cfe00:64},{0x7d1fc0:64,0x7d2000:256,0x7d2100:256,0x7d2200:256,0x7d2300:64,0x7d2340:64,0x7d2380:64,0x7d23c0:64,0x7d2400:1024,0x7d2800:1024,0x7d2c00:1024,0x7d3a80:64,0x7d3ac0:64,0x7d3d80:64,0x7d3dc0:64,0x7d3e00:64,0x7d4000:1024,0x7d4400:1024,0x7d4800:256,0x7d4900:256,0x7d4a00:256,0x7d4b00:256,0x7d4c00:64,0x7d4c40:64,0x7d4c80:64,0x7d4cc0:64,0x7d4d00:256,0x7d4e00:256,0x7d4f00:256,0x7d5000:1024,0x7d5400:1024,0x7d5800:1024,0x7d5c00:1024,0x7d6000:256,0x7d6100:256,0x7d6200:256,0x7d6800:1024,0x7d6c00:1024,0x7d7000:1024,0x7d7400:1024,0x7d7800:1024,0x7d7c00:1024,0x7da900:256,0x7dab00:256,0x7dd000:64,0x7dd200:256,0x7dd300:256,0x7dd500:64,0x7dd540:64,0x7dd660:16,0x7dd670:16,0x7dd700:64,0x7dd800:256,0x7dd900:256,0x7dda00:256,0x7ddb00:256,0x7ddc00:256,0x7ddd00:256,0x7dde00:256,0x7ddf00:256,0x7dfe80:64,0x7dfec0:64},{},{},{},{},{},{},{},{},{},{},{},{0x893b58:4},{},{0x8b0538:4,0x8b053c:4,0x8b0550:4,0x8b055c:4,0x8b056c:4,0x8b0900:256,0x8b8100:256,0x8b9400:256,0x8b9b00:256,0x8b9f00:256,0x8baa00:256,0x8bb000:256,0x8bb700:256,0x8bba00:256,0x8bbd00:256,0x8bc400:1024,0x8bc800:1024,0x8bcc00:1024,0x8bd000:1024,0x8bd400:1024,0x8bd900:256,0x8bdb00:256,0x8bdc00:256,0x8bdd00:256,0x8be000:256,0x8be200:256,0x8be300:256},{0x8c4b00:256,0x8c8f00:256,0x8ccd00:256,0x8cce00:256,0x8ccf00:256,0x8cd200:256,0x8ce000:256,0x8ced00:256,0x8cf000:256,0x8cf300:256,0x8cf600:256,0x8cf900:256,0x8cfa00:256,0x8cff00:256},{},{},{},{0x900000:256,0x900700:256,0x900c00:256,0x903400:256,0x907b00:256,0x90ff00:256},{},{0x92c438:4,0x92c444:4,0x92c448:4,0x92c44c:4},{},{},{},{0x960000:256,0x967300:256,0x967900:256,0x967a00:256,0x968188:4,0x968198:4,0x9681c0:4,0x9681d8:4,0x9681fc:4,0x968a00:256,0x968b00:256,0x96df00:256,0x96f200:4,0x96f204:4,0x96f208:4,0x96f21c:4,0x96f22c:4,0x96f230:4,0x96f234:4,0x96f238:4,0x96f24c:4,0x96f250:4,0x96f25c:4,0x96f260:4,0x96f270:4,0x96f274:4,0x96f278:4,0x96f298:4,0x96f29c:4,0x96f2a0:4,0x96f2a4:4,0x96f2a8:4,0x96f2b8:4,0x96f2bc:4,0x96f2c0:4,0x96f2d4:4,0x96f2e0:4,0x96f2e8:4,0x96f2ec:4,0x96f2f0:4,0x96f2f4:4,0x96f2f8:4,0x96ff00:256},{},{0x986880:64,0x9868c0:64},{0x990000:256,0x990300:256,0x992200:256,0x992300:256,0x992400:256,0x992500:256,0x996300:256,0x996500:256,0x997600:256,0x997700:256},{},{},{},{0x9d0000:256,0x9d1200:256,0x9d3d00:256,0x9d7a00:256,0x9d9400:256,0x9d9c00:256,0x9dff00:256},{},{0x9fe200:256},{0xa013d0:4,0xa013d4:4,0xa013d8:4,0xa01430:4,0xa0ca3c:4,0xa0ee40:4},{0xa1cf00:256},{0xa26900:256},{0xa30000:256,0xa32f04:4,0xa33500:4,0xa33504:4,0xa33508:4,0xa3350c:4,0xa33524:4,0xa33528:4,0xa3352c:4,0xa33530:4,0xa33534:4,0xa33538:4,0xa3353c:4,0xa33540:4,0xa33558:4,0xa3355c:4,0xa33560:4,0xa33564:4,0xa33568:4,0xa3356c:4,0xa33570:4,0xa33574:4,0xa33578:4,0xa3357c:4,0xa33580:4,0xa33584:4,0xa33588:4,0xa335a0:4,0xa335a4:4,0xa335a8:4,0xa335ac:4,0xa335bc:4,0xa335dc:4,0xa335f0:4,0xa37d00:256,0xa38e00:256,0xa3b100:256,0xa3b300:256,0xa3cc00:256},{},{},{0xa66f00:256},{0xa78b00:256,0xa7bd00:256,0xa7dcf4:4},{0xa8a000:256},{},{0xaab300:256},{0xab0800:1024,0xab0c00:1024,0xab2200:256,0xab2300:256,0xab2400:1024,0xab2800:1024,0xab2c00:1024,0xab5000:1024,0xab5400:1024,0xab5800:1024,0xab5c00:1024,0xab6800:1024,0xab6c00:1024,0xab7000:1024,0xab7400:1024,0xab7800:1024,0xab7c00:1024,0xabd000:1024,0xabd400:1024,0xabd800:1024,0xabdc00:1024},{},{},{},{0xaf0000:1024,0xaf0400:1024,0xaf0800:1024,0xaf0c00:1024,0xaf1000:1024,0xaf1400:1024,0xaf1800:1024,0xaf1e00:256,0xaf1f00:256,0xaf2a00:256,0xaf2b00:256,0xaf2c00:256,0xaf2e00:256,0xaf2f00:256,0xaf3000:1024,0xaf3400:1024,0xaf3800:1024,0xaf3c00:1024,0xaf4000:1024,0xaf4400:1024,0xaf4800:1024,0xaf4c00:1024,0xaf5000:1024,0xaf5400:1024,0xaf5800:1024,0xaf5c00:1024,0xaf6600:256,0xaf6a80:64,0xaf6ac0:64,0xaf6f6c:4,0xaf6f90:4,0xaf6f94:4,0xaf6f98:4,0xaf6f9c:4,0xaf6fa0:4,0xaf6fa4:4,0xaf6fa8:4,0xaf6fac:4,0xaf6fb8:4,0xaf9200:256,0xaf9300:256,0xaf9400:1024,0xaf9800:1024,0xaf9e60:4,0xafa000:1024,0xafa400:1024,0xafa800:1024,0xafac00:1024,0xafb09c:4,0xafb0b0:4,0xafb0bc:4,0xafb200:256,0xafb880:64,0xafb900:256,0xafba00:256,0xafbb00:256,0xafbc00:1024},{},{},{},{},{0xb44c00:256,0xb44d00:256,0xb44e00:256,0xb44f00:256,0xb45400:256,0xb45500:256,0xb45600:256,0xb45800:1024,0xb45e38:4,0xb45e3c:4,0xb45e60:16,0xb45e78:4,0xb45e7c:4,0xb45f80:64,0xb45fc0:64,0xb46000:1024,0xb46400:1024,0xb46800:1024,0xb46c00:1024,0xb47000:1024,0xb47400:1024,0xb47800:1024,0xb47c00:1024,0xb48180:64,0xb481c0:64,0xb48200:256,0xb48800:1024,0xb48c00:1024,0xb49410:4,0xb49414:4,0xb49498:4,0xb4949c:4,0xb494d8:4,0xb494dc:4,0xb494e0:16,0xb494f0:16,0xb49580:16,0xb49590:16,0xb496a0:16,0xb496b0:16,0xb49800:1024,0xb49c00:1024,0xb4a000:1024,0xb4a400:1024,0xb4a800:1024,0xb4ac00:1024,0xb4b270:4,0xb4b274:4,0xb4b2c0:64,0xb4b800:1024,0xb4bc00:64,0xb4bc40:64,0xb4bd94:4,0xb4c8fc:4,0xb4c900:256,0xb4ca00:256,0xb4cb00:256,0xb4d000:256,0xb4d100:256,0xb4d2d4:4,0xb4d2e0:16,0xb4d2f0:16,0xb4d400:256,0xb4d500:256,0xb4dee0:16,0xb4def0:16,0xb4df00:256,0xb4e900:64,0xb4e940:16,0xb4e950:16,0xb4e990:4,0xb4eb40:16,0xb4eb50:16,0xb4eb70:4,0xb4eb88:4},{},{0xb61090:4,0xb61094:4,0xb610c0:16,0xb610d0:16,0xb61200:64,0xb61240:64,0xb617b8:4,0xb617bc:4,0xb617c8:4,0xb617cc:4,0xb62000:1024,0xb62400:1024,0xb62800:1024,0xb62c00:1024,0xb63060:16,0xb63070:16,0xb63100:256,0xb63200:16,0xb63270:16,0xb63300:256,0xb63600:64,0xb63640:64,0xb636f4:4,0xb63d00:256,0xb65000:1024,0xb65400:1024,0xb65800:1024,0xb65c00:256,0xb66000:1024,0xb66400:1024,0xb66800:1024,0xb66c00:1024,0xb67000:1024,0xb67400:1024,0xb67800:1024,0xb67c00:1024,0xb68000:1024,0xb68400:1024,0xb68800:1024,0xb68c00:1024,0xb69000:1024,0xb69400:1024,0xb69d00:256,0xb6a040:16,0xb6a050:16,0xb6ae00:256,0xb6af00:256,0xb6c800:1024,0xb6cc00:1024,0xb6ec80:64,0xb6ecc0:64,0xb6ed18:4,0xb6ed1c:4,0xb6ee00:256,0xb6ef00:16,0xb6ef10:16,0xb6f000:1024,0xb6f400:1024,0xb6fe00:256},{0xb70000:1024,0xb70400:1024,0xb70800:1024,0xb70c00:1024,0xb71000:1024,0xb71400:1024,0xb71800:1024,0xb71c00:1024,0xb72000:1024,0xb72400:1024,0xb72800:1024,0xb72c00:1024,0xb73000:1024,0xb73400:1024,0xb73800:1024,0xb73c00:1024,0xb74000:1024,0xb74400:1024,0xb74ea0:4,0xb74ea4:4,0xb74eb4:4,0xb751ac:4,0xb751b4:4,0xb75400:256,0xb75500:256,0xb75b80:4,0xb75b88:4,0xb75b8c:4,0xb75b90:16,0xb75c00:1024,0xb78000:1024,0xb78400:1024,0xb78800:1024,0xb78c00:1024,0xb79000:1024,0xb79400:1024,0xb79800:1024,0xb79c00:1024,0xb7a000:1024,0xb7a400:1024,0xb7a800:256,0xb7a900:256,0xb7aa00:256,0xb7ac00:1024,0xb7b600:16,0xb7b610:16,0xb7b800:1024,0xb7bc00:1024,0xb7c000:1024,0xb7c400:1024,0xb7c800:1024,0xb7cc00:1024,0xb7d000:1024,0xb7d400:1024,0xb7d800:1024,0xb7dc00:1024,0xb7e000:1024,0xb7e400:1024,0xb7e800:1024,0xb7ec00:1024,0xb7f000:1024,0xb7f400:1024,0xb7f800:1024,0xb7fc00:1024},{},{},{},{},{},{},{},{},{0xc07c9a:1,0xc0bcaa:1},{},{},{},{},{},{},{},{},{},{0xca0064:1,0xca0065:1,0xca007a:1,0xca007b:1,0xca00b0:4,0xca0380:1,0xca0381:1,0xca0480:16,0xca0490:16,0xca04fc:4,0xca05d0:4,0xca05d4:4,0xca05d8:4,0xca0606:1,0xca0607:1,0xca0642:1,0xca0643:1,0xca0648:1,0xca0649:1,0xca0657:1,0xca0658:1,0xca0659:1,0xca065c:1,0xca065d:1,0xca0667:1,0xca066c:1,0xca066e:1,0xca066f:1,0xca0672:1,0xca06b0:16,0xca0800:1,0xca0802:1,0xca0803:1,0xca0804:1,0xca0805:1,0xca080c:1,0xca0818:1,0xca084d:1,0xca0880:16,0xca0890:16,0xca08c0:16,0xca0920:1,0xca0922:1,0xca0923:1,0xca0930:1,0xca0931:1,0xca0933:1,0xca0934:1,0xca0935:1,0xca0936:1,0xca0939:1,0xca093a:1,0xca093b:1,0xca0a40:16,0xca0a70:4,0xca0a74:4,0xca0a78:4,0xca0a7c:4,0xca0c01:1,0xca0c02:1,0xca0c11:1,0xca0c12:1,0xca0c13:1,0xca0c48:1,0xca0c54:1,0xca0c55:1,0xca0c60:1,0xca0c62:1,0xca0c63:1,0xca0c6a:1,0xca0c6f:1,0xca0c74:1,0xca0e40:1,0xca0e41:1,0xca0e45:1,0xca0e49:1,0xca0e4a:1,0xca0e4b:1,0xca0e4c:1,0xca0e4e:1,0xca0e4f:1,0xca0e58:1,0xca0e61:1,0xca0e68:1,0xca0e69:1,0xca0e6c:1,0xca0e6d:1,0xca0e6f:1,0xca0e72:1,0xca0e73:1,0xca0e76:1,0xca0e77:1,0xca0e7c:1,0xca0e7d:1,0xca0e7f:1,0xca0e81:1,0xca0e87:1,0xca0e88:1,0xca0e95:1,0xca0e97:1,0xca0e9d:1,0xca0e9e:1,0xca0e9f:1,0xca0ea9:1,0xca0eaa:1,0xca0eab:1,0xca0eac:4,0xca0eb0:1,0xca0eb8:1,0xca0eb9:1,0xca0ed0:1,0xca0ed1:1,0xca0ed5:1,0xca0edb:1,0xca0edc:1,0xca0ede:1,0xca0edf:1,0xca0ee1:1,0xca0ee2:1,0xca0ee3:1,0xca0ee7:1,0xca0eeb:1,0xca0eec:1,0xca0eed:1,0xca0eee:1,0xca0eef:1,0xca0ef6:1,0xca0efb:1,0xca1442:1,0xca144f:1,0xca1457:1,0xca1458:1,0xca1459:1,0xca145a:1,0xca145e:1,0xca145f:1,0xca1472:1,0xca1475:1,0xca1478:1,0xca147d:1,0xca147f:1,0xca1530:4,0xca1534:4,0xca1538:4,0xca153c:4,0xca1583:1,0xca1584:1,0xca158d:1,0xca158e:1,0xca1593:1,0xca1594:1,0xca1596:1,0xca1597:1,0xca1598:1,0xca1599:1,0xca159a:1,0xca159c:1,0xca16f8:4,0xca16fc:4,0xca1b88:1,0xca1b89:1,0xca2600:1,0xca2601:1,0xca2602:1,0xca2603:1,0xca2608:4,0xca260c:4,0xca2630:16,0xca2640:16,0xca2650:16,0xca2660:16,0xca2670:16,0xca2680:1,0xca2681:1,0xca2682:1,0xca2683:1,0xca2684:1,0xca2685:1,0xca2686:1,0xca2687:1,0xca2688:1,0xca2689:1,0xca268a:1,0xca268c:1,0xca268d:1,0xca268e:1,0xca268f:1,0xca2692:1,0xca2693:1,0xca2695:1,0xca2696:1,0xca2697:1,0xca2698:1,0xca2699:1,0xca269a:1,0xca269b:1,0xca269c:1,0xca269e:1,0xca269f:1,0xca26a0:1,0xca26a1:1,0xca26a4:4,0xca26a8:1,0xca26a9:1,0xca26aa:1,0xca26ab:1,0xca26b0:1,0xca26b1:1,0xca26b8:4,0xca26bc:4,0xca26c0:64,0xca2804:1,0xca2805:1,0xca2807:1,0xca280f:1,0xca2887:1,0xca2888:1,0xca288c:1,0xca288f:1,0xca2890:1,0xca2891:1,0xca2896:1,0xca289b:1,0xca289c:1,0xca289e:1,0xca289f:1,0xca28a2:1,0xca2908:1,0xca2909:1,0xca290b:1,0xca290c:1,0xca290d:1,0xca2980:1,0xca2982:1,0xca2983:1,0xca2998:4,0xca299c:4,0xca29c0:1,0xca29c4:4,0xca29c8:4,0xca29f0:16,0xca2b4c:4,0xca2b90:16,0xca2c10:16,0xca2c30:4,0xca2c43:1,0xca2c4a:1,0xca2c81:1,0xca2c84:1,0xca2c85:1,0xca2c92:1,0xca2c93:1,0xca2d00:1,0xca2d01:1,0xca2d02:1,0xca2d0f:1,0xca2d10:16,0xca2e10:1,0xca2e11:1,0xca2e12:1,0xca2e14:1,0xca2e15:1,0xca2e20:16,0xca2e30:16,0xca2e80:1,0xca2ee0:16,0xca2f52:1,0xca2f53:1,0xca2f60:4,0xca2f64:4,0xca2f68:4,0xca2f6c:4,0xca2f7e:1,0xca2f80:1,0xca2f82:1,0xca2f83:1,0xca39c0:4,0xca39c4:4,0xca39c8:4,0xca39cc:4,0xca39d4:4,0xca39d8:4,0xca39f0:16,0xca3a00:1,0xca3a68:4,0xca3a70:4,0xca3b00:1,0xca3bd4:4,0xca3be8:1,0xca3be9:1,0xca3bec:1,0xca3c30:4,0xca3c34:4,0xca3c60:4,0xca3c64:4,0xca3c70:16,0xca3c84:4,0xca3c88:4,0xca3c8c:4,0xca3c90:16,0xca3d44:4,0xca3d4c:4,0xca3d58:4,0xca3e70:4,0xca3ef8:4,0xca3efc:1,0xca3eff:1,0xca3f51:1,0xca3f52:1,0xca3f53:1,0xca3f54:4,0xca3f58:4,0xca3f5c:4,0xca3fa0:16,0xca3fb0:16,0xca3ff8:4,0xca4100:4,0xca4104:4,0xca4108:1,0xca4109:1,0xca4160:4,0xca4164:4,0xca4168:4,0xca416c:4,0xca42a8:4,0xca4300:4,0xca4504:4,0xca4510:16,0xca4600:16,0xca4610:16,0xca4660:16,0xca46c0:16,0xca4720:4,0xca4724:4,0xca4728:4,0xca472c:4,0xca4828:4,0xca482c:4,0xca4850:16,0xca4870:4,0xca4874:4,0xca4878:4,0xca487c:4,0xca4980:4,0xca49f0:4,0xca49f4:4,0xca49f8:4,0xca49fc:4,0xca4a08:4,0xca4a0c:4,0xca4a50:16,0xca4ae8:4,0xca4afe:1,0xca4aff:1,0xca4bd0:16,0xca4bfc:4,0xca4cfc:4,0xca4d50:4,0xca4d54:4,0xca4d5c:4,0xca4e08:4,0xca4e0c:4,0xca4fe0:4,0xca4fe4:4,0xca4ff8:4,0xca50c0:4,0xca50c4:4,0xca50c8:4,0xca50cc:4,0xca5100:4,0xca51b0:4,0xca51b4:4,0xca51b8:4,0xca51bc:4,0xca53fc:4,0xca5400:4,0xca5404:4,0xca5408:4,0xca540c:4,0xca5410:1,0xca5411:1,0xca5418:4,0xca541c:4,0xca55d0:16,0xca56f9:1,0xca56fc:4,0xca5750:16,0xca5820:4,0xca5908:4,0xca590c:4,0xca5960:4,0xca596c:4,0xca59e8:4,0xca59ec:4,0xca5a00:4,0xca5a10:4,0xca5a14:4,0xca5a18:4,0xca5a1c:4,0xca5a60:4,0xca5a64:4,0xca5a68:4,0xca5a6c:4,0xca5a70:16,0xca5ac4:1,0xca5ae0:16,0xca5b00:4,0xca5b60:16,0xca5b80:4,0xca5bb0:16,0xca5be0:16,0xca5bf0:16,0xca5c00:4,0xca5c08:4,0xca5c0c:4,0xca5c30:16,0xca5cfc:4,0xca5d00:4,0xca5dfc:4,0xca5e5c:4,0xca5f00:4,0xca5f04:4,0xca5f08:4,0xca5f0c:4,0xca5f10:16,0xca5ff0:4,0xca5ff4:4,0xca5ffc:4,0xca6000:64,0xca6040:4,0xca6044:4,0xca6048:4,0xca604c:4,0xca6050:16,0xca6060:4,0xca6064:4,0xca6068:4,0xca606c:4,0xca6070:16,0xca6080:4,0xca6084:4,0xca6088:4,0xca608c:4,0xca6090:16,0xca60a0:4,0xca60a4:4,0xca60a8:4,0xca60ac:4,0xca60b0:16,0xca60c0:4,0xca60c4:4,0xca60c8:4,0xca60cc:4,0xca60d0:16,0xca60e0:4,0xca60e4:4,0xca60e8:4,0xca60ec:4,0xca60f0:16,0xca6100:4,0xca6104:4,0xca6108:4,0xca610c:4,0xca6110:16,0xca6120:16,0xca6130:16,0xca6140:16,0xca6150:16,0xca6160:16,0xca6170:16,0xca6180:64,0xca61c0:16,0xca61d0:16,0xca61e0:4,0xca61e4:4,0xca61e8:4,0xca61ec:4,0xca61f0:16,0xca6200:4,0xca6204:4,0xca6208:4,0xca620c:4,0xca6210:16,0xca6220:4,0xca6224:4,0xca6228:4,0xca622c:4,0xca6230:16,0xca6240:16,0xca6250:16,0xca6260:4,0xca6264:4,0xca6268:4,0xca626c:4,0xca6270:16,0xca6280:16,0xca6290:16,0xca62a0:4,0xca62a4:4,0xca62a8:4,0xca62ac:4,0xca62b0:16,0xca62c0:4,0xca62c4:4,0xca62c8:4,0xca62cc:4,0xca62d0:16,0xca62e0:4,0xca62e4:4,0xca62e8:4,0xca62ec:4,0xca62f0:16,0xca6300:64,0xca6340:16,0xca6350:16,0xca6360:4,0xca6364:4,0xca6368:4,0xca636c:4,0xca6370:16,0xca6380:16,0xca6390:16,0xca63a0:4,0xca63a4:4,0xca63a8:4,0xca63ac:4,0xca63b0:16,0xca63c0:4,0xca63c4:4,0xca63c8:4,0xca63cc:4,0xca63d0:16,0xca63e0:4,0xca63e4:4,0xca63e8:4,0xca63ec:4,0xca63f0:16,0xca6400:4,0xca6404:4,0xca6408:4,0xca640c:4,0xca6410:16,0xca6420:16,0xca6430:16,0xca6440:4,0xca6444:4,0xca6448:4,0xca644c:4,0xca6450:16,0xca6460:4,0xca6464:4,0xca6468:4,0xca646c:4,0xca6470:16,0xca6480:4,0xca6484:4,0xca6488:4,0xca648c:4,0xca6490:16,0xca64a0:4,0xca64a4:4,0xca64a8:4,0xca64ac:4,0xca64b0:16,0xca64c0:4,0xca64c4:4,0xca64c8:4,0xca64cc:4,0xca64d0:16,0xca64e0:16,0xca64f0:16,0xca6500:64,0xca6540:16,0xca6550:16,0xca6560:16,0xca6570:16,0xca6580:64,0xca65c0:16,0xca65d0:16,0xca65e0:4,0xca65e4:4,0xca65e8:4,0xca65ec:4,0xca65f0:16,0xca6600:16,0xca6610:16,0xca6620:16,0xca6630:16,0xca6640:64,0xca6680:4,0xca6684:4,0xca6688:4,0xca668c:4,0xca6690:16,0xca66a0:16,0xca66b0:16,0xca66c0:4,0xca66c4:4,0xca66c8:4,0xca66cc:4,0xca66d0:16,0xca66e0:4,0xca66e4:4,0xca66e8:4,0xca66ec:4,0xca66f0:16,0xca6700:4,0xca6704:4,0xca6708:4,0xca670c:4,0xca6710:16,0xca6720:16,0xca6730:16,0xca6740:16,0xca6750:16,0xca6760:4,0xca6764:4,0xca6768:4,0xca676c:4,0xca6770:16,0xca6780:64,0xca67c0:16,0xca67d0:16,0xca67e0:4,0xca67e4:4,0xca67e8:4,0xca67ec:4,0xca67f0:16,0xca6800:256,0xca6900:256,0xca6a00:256,0xca6b00:64,0xca6b40:64,0xca6b80:64,0xca6bc0:64,0xca6c00:256,0xca6d00:256,0xca6e00:64,0xca6e40:64,0xca6e80:64,0xca6ec0:64,0xca6f00:64,0xca6f40:64,0xca6f80:16,0xca6f90:16,0xca6fa0:16,0xca6fb0:16,0xca6fc0:64,0xca7000:256,0xca7100:16,0xca7110:16,0xca7120:16,0xca7130:16,0xca7140:64,0xca7180:64,0xca71c0:16,0xca71d0:16,0xca71e0:16,0xca71f0:16,0xca7200:16,0xca7210:16,0xca7220:16,0xca7230:16,0xca7240:64,0xca7280:64,0xca72c0:64,0xca7300:16,0xca7310:16,0xca7320:16,0xca7330:16,0xca7340:64,0xca7380:64,0xca73c0:64,0xca7400:16,0xca7410:16,0xca7420:16,0xca7430:16,0xca7440:16,0xca7450:16,0xca7460:16,0xca7470:16,0xca7480:64,0xca74c0:64,0xca7500:64,0xca7540:64,0xca7580:64,0xca75c0:64,0xca7600:16,0xca7610:16,0xca7620:16,0xca7630:16,0xca7640:64,0xca7680:64,0xca76c0:64,0xca7700:16,0xca7710:16,0xca7720:16,0xca7730:16,0xca7740:16,0xca7750:16,0xca7760:16,0xca7770:16,0xca7780:64,0xca77c0:64,0xca7800:64,0xca7840:64,0xca7880:64,0xca78c0:64,0xca7900:256,0xca7a00:4,0xca7a04:4,0xca7a20:4,0xca7a24:4,0xca7a40:16,0xca7a50:16,0xca7a70:4,0xca7a74:4,0xca7a78:4,0xca7a7c:4,0xca7a80:1,0xca7a84:1,0xca7b60:16,0xca7b74:4,0xca7b78:4,0xca7c10:4,0xca7c14:4,0xca7c18:4,0xca7d70:16,0xca7db0:16,0xca7f00:1,0xca7f01:1,0xca7f02:1,0xca7f03:1,0xca7f04:1,0xca7f05:1,0xca7f06:1,0xca7f07:1,0xca7f0c:4,0xca7f10:16,0xca7f28:4,0xca7f2c:4,0xca7f30:16,0xca7f70:16,0xca7f80:16,0xca7f90:16,0xca7fa0:4,0xca7fa4:4,0xca7fc0:1,0xca7fc1:1,0xca7fc2:1,0xca7fc3:1,0xca7fc4:4,0xca7fc8:4,0xca7fcc:4,0xca7fd0:1,0xca7fd1:1,0xca7fd4:4,0xca7fd8:4,0xca7fdc:4,0xca7fe0:16,0xca7ff0:16,0xca8200:16,0xca8210:16,0xca82e0:16,0xca82f0:16,0xca8310:4,0xca8314:4,0xca8330:16,0xca83d0:16,0xca8520:16,0xca863a:1,0xca8680:16,0xca86d0:4,0xca86d4:4,0xca86d8:4,0xca86dc:4,0xca8830:16,0xca88d0:16,0xca88e0:16,0xca88f8:4,0xca89e7:1,0xca8c8c:4,0xca8c90:4,0xca8c94:4,0xca8c98:4,0xca8c9c:4,0xca8da0:16,0xca8db0:16,0xca8e10:16,0xca8f04:4,0xca8f10:16,0xca8f20:16,0xca8f38:4,0xca8f3c:4,0xca8f64:4,0xca8f68:4,0xca92a0:16,0xca92bc:4,0xca92c4:4,0xca92c8:4,0xca92cc:4,0xca9390:16,0xca9420:16,0xca9440:16,0xca9450:16,0xca9460:16,0xca9470:16,0xca9520:16,0xca9530:16,0xca95a0:16,0xca95b0:16,0xca95e0:16,0xca95f0:16,0xca9610:16,0xca9620:16,0xca9638:4,0xca96c0:16,0xca96e0:16,0xca96f0:16,0xca9700:4,0xca9780:16,0xca9790:16,0xca98b0:16,0xca9900:4,0xca9930:16,0xca9dc0:16,0xca9dd0:16,0xca9ea0:16,0xca9eb0:16,0xcaa08c:4,0xcaa09c:4,0xcaa0b0:16,0xcaa243:1,0xcaa24b:1,0xcaa400:16,0xcaa460:16,0xcaa470:16,0xcaa560:16,0xcaa5b0:16,0xcaa5d0:16,0xcaa5ef:1,0xcaa5f0:1,0xcaa5f1:1,0xcaa5f3:1,0xcaa5f5:1,0xcaa5fb:1,0xcaa5fc:4,0xcaa6e0:16,0xcaa6f0:16,0xcaa850:4,0xcaa880:4,0xcaa884:4,0xcaa888:4,0xcaa88c:4,0xcaa8a0:16,0xcaa8b0:16,0xcaaa80:16,0xcaaa90:16,0xcaaad8:4,0xcaaadc:4,0xcaaae0:16,0xcaaaf0:16,0xcaabd8:4,0xcaabdc:4,0xcaabeb:1,0xcaac00:4,0xcaad00:4,0xcaad08:4,0xcaad0c:4,0xcaad70:4,0xcaad78:4,0xcaade0:16,0xcaadf0:16,0xcaae40:16,0xcaae7c:4,0xcab0e0:16,0xcab0f0:16,0xcab3a0:4,0xcab3a4:4,0xcab3a8:4,0xcab3ac:4,0xcab3f0:16,0xcab480:16,0xcab490:16,0xcab4d0:4,0xcab4d4:4,0xcab508:4,0xcab51c:4,0xcab570:16,0xcab620:16,0xcab6c0:16,0xcab6d0:16,0xcabd00:64,0xcabd50:16,0xcabdb8:4,0xcabdbc:4,0xcabf00:1,0xcabf44:4,0xcabf48:4,0xcabf4c:4,0xcabf50:16,0xcac000:1024,0xcac400:1024,0xcac800:1024,0xcacc00:1024},{0xcb0004:4,0xcb000a:1,0xcb000b:1,0xcb0012:1,0xcb0018:1,0xcb002a:1,0xcb002b:1,0xcb002d:1,0xcb002e:1,0xcb002f:1,0xcb0051:1,0xcb0052:1,0xcb0053:1,0xcb005a:1,0xcb005b:1,0xcb0060:1,0xcb0061:1,0xcb0068:4,0xcb006c:4,0xcb0072:1,0xcb0073:1,0xcb007a:1,0xcb0080:1,0xcb0082:1,0xcb0083:1,0xcb0084:4,0xcb0089:1,0xcb008e:1,0xcb0090:1,0xcb0092:1,0xcb0094:1,0xcb0096:1,0xcb0097:1,0xcb0098:1,0xcb00b1:1,0xcb00e0:1,0xcb0104:4,0xcb0112:1,0xcb011a:1,0xcb011b:1,0xcb0141:1,0xcb0142:1,0xcb0143:1,0xcb0146:1,0xcb0147:1,0xcb014c:1,0xcb014d:1,0xcb015a:1,0xcb0161:1,0xcb0162:1,0xcb0163:1,0xcb0164:4,0xcb016c:1,0xcb01fd:1,0xcb01fe:1,0xcb0240:4,0xcb0244:4,0xcb0249:1,0xcb0270:4,0xcb0274:4,0xcb027e:1,0xcb027f:1,0xcb028c:1,0xcb0296:1,0xcb0298:4,0xcb029c:1,0xcb029d:1,0xcb02a0:4,0xcb02a4:4,0xcb02b4:1,0xcb02b5:1,0xcb02c4:1,0xcb02c5:1,0xcb02d1:1,0xcb02d6:1,0xcb02d7:1,0xcb02e2:1,0xcb02e3:1,0xcb02e5:1,0xcb02ec:1,0xcb02ed:1,0xcb0344:1,0xcb0348:1,0xcb0349:1,0xcb034b:1,0xcb0350:4,0xcb0354:4,0xcb0360:4,0xcb0369:1,0xcb0370:4,0xcb0374:4,0xcb0378:1,0xcb037b:1,0xcb0387:1,0xcb038b:1,0xcb038f:1,0xcb0484:1,0xcb0485:1,0xcb0486:1,0xcb0497:1,0xcb0498:4,0xcb04ae:1,0xcb04af:1,0xcb04b4:1,0xcb04ba:1,0xcb04cd:1,0xcb04d0:4,0xcb04e3:1,0xcb04e6:1,0xcb04e7:1,0xcb0504:1,0xcb0505:1,0xcb0507:1,0xcb0508:1,0xcb0509:1,0xcb050b:1,0xcb0515:1,0xcb0516:1,0xcb052c:1,0xcb052e:1,0xcb052f:1,0xcb0534:4,0xcb0538:1,0xcb0539:1,0xcb053c:1,0xcb053d:1,0xcb0572:1,0xcb0573:1,0xcb0576:1,0xcb0578:1,0xcb05ac:1,0xcb05b4:1,0xcb05b5:1,0xcb05b6:1,0xcb05b9:1,0xcb05ba:1,0xcb05bc:1,0xcb05bd:1,0xcb05be:1,0xcb05c3:1,0xcb05d6:1,0xcb05d7:1,0xcb05da:1,0xcb05db:1,0xcb0683:1,0xcb0688:1,0xcb068a:1,0xcb068b:1,0xcb068e:1,0xcb0696:1,0xcb0697:1,0xcb069d:1,0xcb069f:1,0xcb06e0:16,0xcb06f8:1,0xcb06f9:1,0xcb0781:1,0xcb078a:1,0xcb078b:1,0xcb0793:1,0xcb0796:1,0xcb0797:1,0xcb079e:1,0xcb07c0:1,0xcb07c1:1,0xcb07c8:1,0xcb0800:1,0xcb0808:1,0xcb0817:1,0xcb0818:4,0xcb081c:4,0xcb0846:1,0xcb0852:1,0xcb0856:1,0xcb0857:1,0xcb085b:1,0xcb086e:1,0xcb086f:1,0xcb0873:1,0xcb08a6:1,0xcb08a7:1,0xcb08a9:1,0xcb08ad:1,0xcb08b8:1,0xcb08ba:1,0xcb08bb:1,0xcb08be:1,0xcb08bf:1,0xcb08c0:1,0xcb08c5:1,0xcb08c6:1,0xcb08c7:1,0xcb08cb:1,0xcb08d1:1,0xcb08d2:1,0xcb08d3:1,0xcb08d4:4,0xcb08d9:1,0xcb08dc:1,0xcb0920:1,0xcb0924:1,0xcb0925:1,0xcb0939:1,0xcb093f:1,0xcb0941:1,0xcb0946:1,0xcb0947:1,0xcb0948:1,0xcb094b:1,0xcb094c:1,0xcb094d:1,0xcb0960:4,0xcb0964:1,0xcb0965:1,0xcb096c:1,0xcb099e:1,0xcb0a22:1,0xcb0a38:1,0xcb0a4a:1,0xcb0a4b:1,0xcb0a54:4,0xcb0a58:1,0xcb0a5f:1,0xcb0a7d:1,0xcb0b46:1,0xcb0b4c:4,0xcb0b52:1,0xcb0b54:4,0xcb0b64:4,0xcb0b6d:1,0xcb0b75:1,0xcb0b7a:1,0xcb0b7e:1,0xcb0b88:4,0xcb0b8d:1,0xcb0b8e:1,0xcb0b8f:1,0xcb0bb4:4,0xcb0bd0:4,0xcb0c10:1,0xcb0c13:1,0xcb0c18:1,0xcb0c39:1,0xcb0c41:1,0xcb0c42:1,0xcb0c46:1,0xcb0c47:1,0xcb0c57:1,0xcb0c58:4,0xcb0c5c:4,0xcb0c64:1,0xcb0c65:1,0xcb0c67:1,0xcb0c72:1,0xcb0c76:1,0xcb0c82:1,0xcb0c89:1,0xcb0cc4:4,0xcb0cc8:4,0xcb0ccc:4,0xcb0cd3:1,0xcb0cdb:1,0xcb0ce2:1,0xcb0cf0:4,0xcb0d12:1,0xcb0d18:1,0xcb0d2c:1,0xcb0d2d:1,0xcb0d50:4,0xcb0d54:4,0xcb0d58:1,0xcb0d59:1,0xcb0d5c:4,0xcb0dad:1,0xcb0de0:1,0xcb0de1:1,0xcb0de3:1,0xcb0de9:1,0xcb0e18:4,0xcb0e21:1,0xcb0e38:1,0xcb0e3d:1,0xcb0e3e:1,0xcb0e68:1,0xcb0e72:1,0xcb0e73:1,0xcb0e76:1,0xcb0ea2:1,0xcb0eb8:4,0xcb0ebc:4,0xcb0ec0:1,0xcb0ec2:1,0xcb0ec3:1,0xcb0ed6:1,0xcb0ee7:1,0xcb0ef6:1,0xcb0f00:16,0xcb0f14:1,0xcb0f15:1,0xcb0f16:1,0xcb0f57:1,0xcb0f58:1,0xcb0f59:1,0xcb0f69:1,0xcb0f70:4,0xcb0f74:4,0xcb0f82:1,0xcb0f83:1,0xcb0f95:1,0xcb0f97:1,0xcb0f9c:4,0xcb0fae:1,0xcb0fe3:1,0xcb0fe8:4,0xcb0fec:4,0xcb0ff0:1,0xcb0ff1:1,0xcb0ff6:1,0xcb100a:1,0xcb100c:1,0xcb100d:1,0xcb1010:4,0xcb1014:4,0xcb101b:1,0xcb1026:1,0xcb1031:1,0xcb1032:1,0xcb1033:1,0xcb103a:1,0xcb1085:1,0xcb10a1:1,0xcb10a2:1,0xcb10ba:1,0xcb10bb:1,0xcb10e4:1,0xcb10ee:1,0xcb10f0:1,0xcb10f5:1,0xcb1102:1,0xcb1112:1,0xcb111c:1,0xcb1127:1,0xcb1138:1,0xcb114a:1,0xcb114b:1,0xcb1158:1,0xcb1159:1,0xcb1188:1,0xcb11a4:1,0xcb11bb:1,0xcb11be:1,0xcb11bf:1,0xcb11e7:1,0xcb11e9:1,0xcb11f8:1,0xcb11ff:1,0xcb1202:1,0xcb1203:1,0xcb1204:1,0xcb1207:1,0xcb121f:1,0xcb1225:1,0xcb1230:1,0xcb1231:1,0xcb1234:1,0xcb1248:4,0xcb1250:1,0xcb1251:1,0xcb1257:1,0xcb1264:1,0xcb1265:1,0xcb1269:1,0xcb126b:1,0xcb126e:1,0xcb1281:1,0xcb1283:1,0xcb1284:1,0xcb1285:1,0xcb1290:1,0xcb1299:1,0xcb12c7:1,0xcb12d0:1,0xcb12d3:1,0xcb12d7:1,0xcb1312:1,0xcb1318:1,0xcb131e:1,0xcb1320:4,0xcb1324:4,0xcb1329:1,0xcb132c:1,0xcb132d:1,0xcb132e:1,0xcb133a:1,0xcb133c:1,0xcb133d:1,0xcb1340:1,0xcb1344:1,0xcb1348:1,0xcb1365:1,0xcb136f:1,0xcb1383:1,0xcb1385:1,0xcb1390:1,0xcb1395:1,0xcb139c:1,0xcb13b0:1,0xcb13b2:1,0xcb13b3:1,0xcb13d0:1,0xcb13e4:4,0xcb13e9:1,0xcb13f2:1,0xcb13f8:1,0xcb13f9:1,0xcb13ff:1,0xcb1411:1,0xcb1428:1,0xcb1429:1,0xcb1430:1,0xcb143d:1,0xcb1441:1,0xcb1454:1,0xcb1455:1,0xcb1459:1,0xcb146a:1,0xcb146b:1,0xcb1473:1,0xcb1475:1,0xcb1476:1,0xcb1477:1,0xcb147a:1,0xcb147e:1,0xcb147f:1,0xcb1487:1,0xcb1488:4,0xcb148c:4,0xcb1496:1,0xcb14e6:1,0xcb14e8:1,0xcb14ec:1,0xcb1500:1,0xcb1501:1,0xcb1502:1,0xcb1508:1,0xcb150a:1,0xcb1512:1,0xcb1521:1,0xcb1522:1,0xcb1529:1,0xcb152c:1,0xcb1544:1,0xcb1552:1,0xcb1560:4,0xcb157c:1,0xcb1588:1,0xcb1589:1,0xcb1591:1,0xcb15ce:1,0xcb1618:1,0xcb161c:1,0xcb161d:1,0xcb161f:1,0xcb1644:1,0xcb164c:1,0xcb164e:1,0xcb1654:1,0xcb1657:1,0xcb165c:4,0xcb1663:1,0xcb166a:1,0xcb167a:1,0xcb167b:1,0xcb1683:1,0xcb16a3:1,0xcb16a6:1,0xcb16aa:1,0xcb16b0:4,0xcb16b4:4,0xcb16c2:1,0xcb16f2:1,0xcb16f3:1,0xcb16f5:1,0xcb16f6:1,0xcb16fc:1,0xcb16fd:1,0xcb1700:1,0xcb172f:1,0xcb173d:1,0xcb173e:1,0xcb173f:1,0xcb1749:1,0xcb1755:1,0xcb175c:4,0xcb1762:1,0xcb176b:1,0xcb1770:1,0xcb1782:1,0xcb178c:1,0xcb178d:1,0xcb17ac:1,0xcb17b6:1,0xcb17ba:1,0xcb17bb:1,0xcb17c0:1,0xcb17c5:1,0xcb17c6:1,0xcb17cc:4,0xcb17e0:1,0xcb17e2:1,0xcb17e3:1,0xcb17e4:4,0xcb17f9:1,0xcb17fb:1,0xcb180d:1,0xcb1812:1,0xcb181b:1,0xcb182b:1,0xcb1838:1,0xcb183a:1,0xcb1843:1,0xcb184a:1,0xcb184f:1,0xcb1850:1,0xcb1851:1,0xcb1854:1,0xcb1855:1,0xcb1856:1,0xcb185a:1,0xcb186f:1,0xcb1870:1,0xcb1874:1,0xcb187a:1,0xcb187b:1,0xcb1891:1,0xcb1898:1,0xcb1899:1,0xcb189d:1,0xcb18a1:1,0xcb18a7:1,0xcb18ba:1,0xcb18bb:1,0xcb18c7:1,0xcb18ca:1,0xcb18d4:1,0xcb18d5:1,0xcb18d9:1,0xcb18db:1,0xcb18f4:1,0xcb1913:1,0xcb1914:1,0xcb1915:1,0xcb192e:1,0xcb1930:4,0xcb1934:4,0xcb1940:1,0xcb1941:1,0xcb195b:1,0xcb1963:1,0xcb1964:1,0xcb196a:1,0xcb1983:1,0xcb1987:1,0xcb198a:1,0xcb1993:1,0xcb1999:1,0xcb199a:1,0xcb199b:1,0xcb19a4:1,0xcb19a6:1,0xcb19ae:1,0xcb19af:1,0xcb19b4:1,0xcb19b6:1,0xcb19bf:1,0xcb19c7:1,0xcb19c8:1,0xcb19ca:1,0xcb19cb:1,0xcb19d0:16,0xcb19e5:1,0xcb19eb:1,0xcb19ec:1,0xcb19f2:1,0xcb1a0c:1,0xcb1a22:1,0xcb1a31:1,0xcb1a32:1,0xcb1a37:1,0xcb1a38:1,0xcb1a39:1,0xcb1a3c:1,0xcb1a41:1,0xcb1a44:1,0xcb1a4c:1,0xcb1a50:1,0xcb1a54:1,0xcb1a61:1,0xcb1a66:1,0xcb1a67:1,0xcb1a73:1,0xcb1a74:1,0xcb1a81:1,0xcb1a8f:1,0xcb1a90:1,0xcb1a94:1,0xcb1a95:1,0xcb1a9a:1,0xcb1a9e:1,0xcb1a9f:1,0xcb1aaa:1,0xcb1aad:1,0xcb1ab0:1,0xcb1ab9:1,0xcb1aca:1,0xcb1acb:1,0xcb1ad2:1,0xcb1ad6:1,0xcb1ade:1,0xcb1ae0:1,0xcb1ae4:1,0xcb1ae8:1,0xcb1b00:1,0xcb1b0a:1,0xcb1b0f:1,0xcb1b10:1,0xcb1b14:1,0xcb1b16:1,0xcb1b17:1,0xcb1b28:1,0xcb1b2d:1,0xcb1b35:1,0xcb1b41:1,0xcb1b42:1,0xcb1b51:1,0xcb1b58:1,0xcb1b66:1,0xcb1b6d:1,0xcb1b75:1,0xcb1b79:1,0xcb1b7a:1,0xcb1b7b:1,0xcb1b7d:1,0xcb1bc8:1,0xcb1bca:1,0xcb1be9:1,0xcb1bf1:1,0xcb1bfa:1,0xcb1c0a:1,0xcb1c0c:1,0xcb1c21:1,0xcb1c22:1,0xcb1c23:1,0xcb1c2b:1,0xcb1c2c:1,0xcb1c36:1,0xcb1c38:1,0xcb1c49:1,0xcb1c4a:1,0xcb1c4c:1,0xcb1c56:1,0xcb1c58:1,0xcb1c70:1,0xcb1c83:1,0xcb1c88:1,0xcb1c8c:1,0xcb1c91:1,0xcb1ca5:1,0xcb1ca9:1,0xcb1caa:1,0xcb1cb2:1,0xcb1cb3:1,0xcb1cb9:1,0xcb1cbb:1,0xcb1cc4:1,0xcb1ce2:1,0xcb1ce3:1,0xcb1cef:1,0xcb1d02:1,0xcb1d08:1,0xcb1d09:1,0xcb1d0d:1,0xcb1d0e:1,0xcb1d1c:1,0xcb1d2e:1,0xcb1d39:1,0xcb1d3d:1,0xcb1d3f:1,0xcb1d45:1,0xcb1d49:1,0xcb1d51:1,0xcb1d5a:1,0xcb1d5f:1,0xcb1d64:1,0xcb1d67:1,0xcb1d70:1,0xcb1d78:4,0xcb1db6:1,0xcb1db7:1,0xcb1dbb:1,0xcb1dbd:1,0xcb1dbe:1,0xcb1dcd:1,0xcb1dd2:1,0xcb1dd9:1,0xcb1de3:1,0xcb1de7:1,0xcb1de9:1,0xcb1dea:1,0xcb1df8:1,0xcb1dfe:1,0xcb1dff:1,0xcb1e10:1,0xcb1e11:1,0xcb1e19:1,0xcb1e1b:1,0xcb1e1d:1,0xcb1e42:1,0xcb1e51:1,0xcb1e57:1,0xcb1e6f:1,0xcb1e79:1,0xcb1e7b:1,0xcb1e98:1,0xcb1e9c:1,0xcb1ea2:1,0xcb1ead:1,0xcb1eaf:1,0xcb1ebb:1,0xcb1ec2:1,0xcb1ed9:1,0xcb1edc:1,0xcb1ede:1,0xcb1ee8:1,0xcb1ee9:1,0xcb1eeb:1,0xcb1ef0:1,0xcb1ef1:1,0xcb1ef6:1,0xcb1efa:1,0xcb1efb:1,0xcb1f2d:1,0xcb1f2e:1,0xcb1f31:1,0xcb1f33:1,0xcb1f36:1,0xcb1f37:1,0xcb1f45:1,0xcb1f48:1,0xcb1f50:1,0xcb1f55:1,0xcb1f61:1,0xcb1f69:1,0xcb1f6a:1,0xcb1f6c:1,0xcb1f6d:1,0xcb1f7c:1,0xcb1fa2:1,0xcb1fae:1,0xcb1fb1:1,0xcb1fb5:1,0xcb1fbb:1,0xcb1fbd:1,0xcb1fcc:1,0xcb1fdc:1,0xcb1fde:1,0xcb1fdf:1,0xcb1fe1:1,0xcb1fe5:1,0xcb1ff8:1,0xcb1ff9:1,0xcb1ffd:1,0xcb2014:1,0xcb2030:1,0xcb2031:1,0xcb2038:1,0xcb203c:1,0xcb203e:1,0xcb2044:1,0xcb2045:1,0xcb204c:1,0xcb2051:1,0xcb2054:1,0xcb2055:1,0xcb205f:1,0xcb2066:1,0xcb2069:1,0xcb2082:1,0xcb2085:1,0xcb208c:1,0xcb2098:1,0xcb20ba:1,0xcb20bb:1,0xcb20c0:1,0xcb20c4:1,0xcb20cb:1,0xcb20cc:1,0xcb20cd:1,0xcb20d4:1,0xcb2104:1,0xcb2107:1,0xcb2108:4,0xcb210c:4,0xcb2115:1,0xcb211a:1,0xcb2120:1,0xcb213f:1,0xcb2140:1,0xcb2143:1,0xcb2144:1,0xcb2149:1,0xcb214f:1,0xcb2164:1,0xcb217a:1,0xcb2181:1,0xcb2183:1,0xcb2191:1,0xcb219c:1,0xcb219e:1,0xcb219f:1,0xcb21ae:1,0xcb21b9:1,0xcb21c8:1,0xcb21ca:1,0xcb21cb:1,0xcb21cc:1,0xcb21ce:1,0xcb21cf:1,0xcb21d6:1,0xcb21d7:1,0xcb21e0:1,0xcb21e1:1,0xcb21e2:1,0xcb21e9:1,0xcb21f3:1,0xcb21fa:1,0xcb2204:1,0xcb2215:1,0xcb221b:1,0xcb2227:1,0xcb2230:1,0xcb2231:1,0xcb2236:1,0xcb2238:1,0xcb2239:1,0xcb2243:1,0xcb2245:1,0xcb224c:1,0xcb225c:1,0xcb226a:1,0xcb2271:1,0xcb2293:1,0xcb2296:1,0xcb2298:1,0xcb2299:1,0xcb22a1:1,0xcb22a2:1,0xcb22bb:1,0xcb22c0:4,0xcb22c4:4,0xcb22cc:4,0xcb22e8:1,0xcb22f0:1,0xcb22f2:1,0xcb22f5:1,0xcb22fb:1,0xcb3702:1,0xcb3703:1,0xcb3704:1,0xcb370a:1,0xcb370d:1,0xcb3716:1,0xcb371e:1,0xcb375d:1,0xcb3765:1,0xcb376d:1,0xcb376e:1,0xcb3774:1,0xcb3775:1,0xcb3777:1,0xcb3780:1,0xcb3781:1,0xcb3792:1,0xcb3793:1,0xcb37c0:1,0xcb37c4:1,0xcb37da:1,0xcb37db:1,0xcb37dd:1,0xcb37e0:1,0xcb3801:1,0xcb3804:1,0xcb380c:1,0xcb3818:1,0xcb3826:1,0xcb3828:1,0xcb382e:1,0xcb3830:4,0xcb3834:4,0xcb3844:1,0xcb3845:1,0xcb3852:1,0xcb3853:1,0xcb3854:1,0xcb3855:1,0xcb385f:1,0xcb386e:1,0xcb3879:1,0xcb38a1:1,0xcb38a9:1,0xcb38ac:1,0xcb38ad:1,0xcb38af:1,0xcb38b7:1,0xcb38b9:1,0xcb38bb:1,0xcb38c0:1,0xcb38c6:1,0xcb38c9:1,0xcb38d0:1,0xcb38d1:1,0xcb38d2:1,0xcb38d6:1,0xcb38d8:1,0xcb38e3:1,0xcb38e4:1,0xcb38e8:1,0xcb38f0:1,0xcb38fc:1,0xcb38fe:1,0xcb3905:1,0xcb3906:1,0xcb390c:1,0xcb390d:1,0xcb391c:1,0xcb3927:1,0xcb392e:1,0xcb393a:1,0xcb393d:1,0xcb3942:1,0xcb3945:1,0xcb3946:1,0xcb3947:1,0xcb3949:1,0xcb395a:1,0xcb3965:1,0xcb396d:1,0xcb397b:1,0xcb399d:1,0xcb39c8:1,0xcb39ca:1,0xcb39ce:1,0xcb39de:1,0xcb39e0:16,0xcb39f6:1,0xcb39f7:1,0xcb39f9:1,0xcb39fd:1,0xcb39fe:1,0xcb39ff:1,0xcb3e02:1,0xcb3e83:1,0xcb3e8b:1,0xcb3ea1:1,0xcb3ec5:1,0xcb3ee4:4,0xcb3eea:1,0xcb3ef6:1,0xcb4ca0:4,0xcb4ca8:4,0xcb4cd0:4,0xcb4cd4:4,0xcb4cd8:4,0xcb4cf0:4,0xcb4cf4:4,0xcb4db4:4,0xcb4e30:16,0xcb4e9c:4,0xcb4f00:16,0xcb4f20:16,0xcb5004:1,0xcb5005:1,0xcb5020:16,0xcb5039:1,0xcb5084:4,0xcb5088:4,0xcb508c:4,0xcb5090:16,0xcb5100:4,0xcb5104:4,0xcb5110:16,0xcb51f4:4,0xcb5200:1,0xcb5201:1,0xcb5210:4,0xcb5214:4,0xcb5270:4,0xcb5274:4,0xcb5278:4,0xcb527c:4,0xcb52e0:4,0xcb52e4:4,0xcb52e8:4,0xcb52ec:4,0xcb5300:4,0xcb5308:4,0xcb530c:4,0xcb5338:4,0xcb533c:4,0xcb53e0:16,0xcb5600:16,0xcb5610:16,0xcb5620:16,0xcb5630:16,0xcb5640:16,0xcb5650:16,0xcb5660:16,0xcb5670:16,0xcb56fe:1,0xcb56ff:1,0xcb5820:16,0xcb5830:16,0xcb58c0:16,0xcb58d0:16,0xcb5900:4,0xcb5908:4,0xcb590c:4,0xcb5988:4,0xcb5a00:4,0xcb5a08:4,0xcb5a0c:4,0xcb5a80:16,0xcb5a90:16,0xcb5aa0:16,0xcb5ab0:16,0xcb5ac0:16,0xcb5ad0:16,0xcb5b20:16,0xcb5b30:16,0xcb5b60:16,0xcb5b78:4,0xcb5b7c:4,0xcb5c00:4,0xcb5ca0:16,0xcb5cb0:16,0xcb5d00:4,0xcb5d04:4,0xcb5d08:1,0xcb5d09:1,0xcb5d0a:1,0xcb5d0b:1,0xcb5d0c:4,0xcb5d10:16,0xcb5d20:16,0xcb5d30:16,0xcb5d40:64,0xcb5d80:4,0xcb5d84:4,0xcb5d88:4,0xcb5d8c:1,0xcb5d8d:1,0xcb5d8e:1,0xcb5d8f:1,0xcb5d90:16,0xcb5da0:16,0xcb5db0:16,0xcb5dc0:64,0xcb5e00:4,0xcb5e04:4,0xcb5e08:4,0xcb5e0c:4,0xcb5e10:16,0xcb5f00:4,0xcb5f04:4,0xcb5f60:16,0xcb5f70:16,0xcb5f80:64,0xcb5fc8:4,0xcb5fcc:4,0xcb5fd0:4,0xcb5fe0:16,0xcb5ff0:16,0xcb6308:4,0xcb630c:4,0xcb6310:16,0xcb6350:16,0xcb6420:16,0xcb6430:4,0xcb6434:4,0xcb643f:1,0xcb6450:16,0xcb6460:16,0xcb6470:16,0xcb64c0:16,0xcb6820:16,0xcb6960:16,0xcb6970:16,0xcb6980:16,0xcb6990:16,0xcb6b00:64,0xcb6b40:64,0xcb6ea0:16,0xcb6eb0:16,0xcb6ed0:16,0xcb6ee8:1,0xcb6ee9:1,0xcb6eea:1,0xcb7250:4,0xcb7254:4,0xcb7258:4,0xcb725c:4,0xcb72f4:4,0xcb76c0:16,0xcb76d0:16,0xcb76f1:1,0xcb76f8:4,0xcb7718:4,0xcb771c:4,0xcb7720:4,0xcb7750:4,0xcb7755:1,0xcb7771:1,0xcb7772:1,0xcb7773:1,0xcb7774:4,0xcb7778:4,0xcb777c:4,0xcb7780:64,0xcb77c0:64,0xcb8020:16,0xcb8030:16,0xcb8060:16,0xcb8070:16,0xcb80e0:4,0xcb80e4:4,0xcb8108:4,0xcb810c:4,0xcb8220:16,0xcb8230:16,0xcb8420:16,0xcb8430:16,0xcb86f0:4,0xcb86f4:4,0xcb8760:16,0xcb8770:16,0xcb87a0:16,0xcb8ee0:16,0xcb8ef0:16,0xcb9060:16,0xcb9070:16,0xcb9100:16,0xcb9110:16,0xcb9400:64,0xcb9440:16,0xcb9450:4,0xcb9456:1,0xcb9457:1,0xcb955c:4,0xcb9840:16,0xcb9850:16,0xcb9880:16,0xcb9890:16,0xcb9900:4,0xcb9cc0:64,0xcb9e10:4,0xcb9e14:4,0xcba068:4,0xcba06c:4,0xcba081:1,0xcba0c0:16,0xcba0d0:16,0xcba100:4,0xcba1b4:1,0xcba1c0:16,0xcba1d0:16,0xcba6a0:16,0xcba6b0:16,0xcba71c:4,0xcba800:16,0xcba810:16,0xcbaa3a:1,0xcbaa3b:1,0xcbab00:4,0xcbabe0:16,0xcbae04:1,0xcbae07:1,0xcbae60:16,0xcbae70:16,0xcbaf80:16,0xcbaf90:16,0xcbafc0:64,0xcbb000:64,0xcbb040:16,0xcbb050:16,0xcbb0a8:4,0xcbb0ac:4,0xcbb850:16,0xcbbba0:16,0xcbbbb0:16,0xcbbd00:1,0xcbbd01:1,0xcbbd06:1,0xcbbd07:1,0xcbbd70:4,0xcbbdc0:16,0xcbbdd0:16,0xcbbde8:4,0xcbbdec:4,0xcbbdf0:4,0xcbbe60:16,0xcbbef9:1,0xcbbf00:1,0xcbbf01:1,0xcbbf10:16,0xcbbf40:64,0xcbbf90:4,0xcbbf94:4,0xcbbf98:4,0xcbbf9c:4,0xcbc000:16,0xcbc010:16,0xcbc1e0:16,0xcbc1f0:16,0xcbc278:4,0xcbc27c:4,0xcbc340:16,0xcbc350:16,0xcbc370:4,0xcbc374:4,0xcbc380:64,0xcbc3c0:64,0xcbc400:4,0xcbc404:4,0xcbc408:4,0xcbc40c:4,0xcbc41c:4,0xcbcaec:4,0xcbcd40:16,0xcbcd50:16,0xcbcd80:64,0xcbcdc0:64,0xcbcf40:64,0xcbcf80:64,0xcbcfc0:64,0xcbd000:16,0xcbd010:4,0xcbd020:16,0xcbd030:16,0xcbd1e0:16,0xcbd1f0:16,0xcbd400:16,0xcbd450:16,0xcbd7e8:4,0xcbd7ec:4,0xcbd9a4:4,0xcbdec0:16,0xcbdf00:16,0xcbdf10:4,0xcbdf14:4},{},{},{},{},{},{},{0xd20200:16,0xd20210:16,0xd20500:16,0xd20510:16,0xd20538:4,0xd2053c:4,0xd20580:16,0xd20590:16,0xd20738:4,0xd2073c:4,0xd20c00:64,0xd20c40:64,0xd20c80:64,0xd20cc0:64,0xd20d00:64,0xd20d40:64,0xd20d80:64,0xd20dc0:64,0xd20e40:16,0xd20e50:16,0xd20e70:16,0xd20e80:16,0xd20e90:16,0xd20ea0:16,0xd20eb0:16,0xd20ec0:16,0xd20ed0:16,0xd20ee0:16,0xd20ef0:16,0xd20f00:16,0xd20f10:16,0xd20f20:16,0xd20f30:16,0xd20f40:16,0xd20f50:16,0xd20f60:16,0xd20f70:16,0xd20f80:64,0xd21068:4,0xd21080:64,0xd21500:64,0xd21540:64,0xd21580:64,0xd215c0:64,0xd21600:256,0xd21720:16,0xd21730:16,0xd21900:256,0xd21a00:256,0xd21b00:256,0xd21c00:1024,0xd22000:1024,0xd22400:1024,0xd22800:1024,0xd22c00:1024,0xd23300:256,0xd23400:64,0xd23440:64,0xd23480:64,0xd234c0:64,0xd23500:64,0xd23540:64,0xd23580:64,0xd235c0:64,0xd238c0:16,0xd238d0:16,0xd24800:64,0xd24840:64,0xd24880:16,0xd24890:16,0xd248a0:16,0xd248b0:16,0xd248c0:64,0xd24900:16,0xd24910:16,0xd24920:16,0xd24930:16,0xd24940:64,0xd24980:64,0xd249c0:64,0xd24a00:16,0xd24a10:16,0xd24a20:16,0xd24a30:16,0xd24a40:16,0xd24a50:16,0xd24a60:16,0xd24a70:16,0xd24a80:16,0xd24a90:16,0xd24aa0:16,0xd24ab0:16,0xd24ac0:64,0xd24b00:256,0xd24c00:16,0xd24c10:16,0xd24c20:16,0xd24c30:16,0xd24c40:64,0xd24c80:64,0xd24cc0:64,0xd24d00:256,0xd24e00:16,0xd24e10:16,0xd24e20:16,0xd24e30:16,0xd24e40:64,0xd24e80:16,0xd24e90:16,0xd24ea0:16,0xd24eb0:16,0xd24ec0:64,0xd24f40:64,0xd24fe0:16,0xd24ff0:16,0xd25200:256,0xd25300:256,0xd25780:16,0xd25790:16,0xd257a0:16,0xd257b0:16,0xd2b9c0:64,0xd2c060:16,0xd2c070:16},{0xd34000:1024,0xd34400:256,0xd34500:256,0xd34600:256,0xd34700:256,0xd35000:256,0xd35100:256,0xd35200:256,0xd35300:256,0xd35400:256,0xd35500:256,0xd35600:256,0xd35700:256,0xd35800:256,0xd35900:256,0xd35a00:256,0xd35b00:256,0xd35c00:256,0xd35d00:256,0xd35e00:256,0xd35f00:256,0xd36000:256,0xd36100:256,0xd36200:256,0xd36300:64,0xd36340:16,0xd36350:16,0xd36360:16,0xd36370:16,0xd36380:64,0xd363c0:64,0xd36400:256,0xd36500:64,0xd36540:64,0xd36580:64,0xd365c0:64,0xd36600:256,0xd36700:64,0xd36740:64,0xd36780:64,0xd367c0:64,0xd38800:1024,0xd38c00:256,0xd38d00:256,0xd38e00:64,0xd38e40:64,0xd38e80:64,0xd38ec0:64,0xd38f00:256,0xd39000:256,0xd39100:256,0xd39200:256,0xd39300:256,0xd39400:1024,0xd39800:256,0xd39900:256,0xd39a00:256,0xd39b00:64,0xd39b40:16,0xd39b50:16,0xd39b60:16,0xd39b70:16,0xd39b80:64,0xd39bc0:64,0xd39c00:1024,0xd3a000:1024,0xd3a400:1024},{},{},{},{},{},{},{0xda0000:256,0xda0100:256,0xda0200:256,0xda0300:256,0xda0400:256,0xda0500:256,0xda0600:256,0xda0700:256,0xda0800:256,0xda0900:256,0xda0a00:256,0xda0b00:256,0xda0c00:256,0xda0d00:256,0xda0e00:256,0xda0f00:256,0xda1000:1024,0xda1400:256,0xda1500:64,0xda1540:64,0xda1580:64,0xda15c0:64,0xda1600:256,0xda1700:256,0xda1800:256,0xda1900:256,0xda1a00:256,0xda1b00:256,0xda1c00:256,0xda1d00:256,0xda1e00:256,0xda1f00:256,0xda3800:1024,0xda3c00:256,0xda3d00:256,0xda3e00:64,0xda3e40:64,0xda3e80:64,0xda3ec0:64,0xda3f00:256,0xda4000:256,0xda4100:256,0xda4200:256,0xda4300:64,0xda4340:64,0xda4380:64,0xda43c0:64,0xda4400:256,0xda4500:256,0xda4600:256,0xda4700:256,0xda4800:1024,0xda4c00:256,0xda4d00:256,0xda4e00:256,0xda4f00:256,0xda5000:1024,0xda5400:1024,0xda5800:1024,0xda5c00:1024,0xda6000:256,0xda6100:256,0xda6200:64,0xda6240:64,0xda6280:64,0xda62c0:16,0xda62d0:16,0xda62e0:16,0xda62f0:16,0xda6300:256,0xda6458:4,0xda645c:4,0xda6460:16,0xda6470:16,0xda6480:64,0xda64c0:64,0xda6800:64,0xda6840:64,0xda6880:16,0xda6890:16,0xda68a0:16,0xda68b0:16,0xda68c0:4,0xda68c4:4,0xda68c8:4,0xda68cc:4,0xda68d0:16,0xda68e0:16,0xda68f0:16,0xda6900:256,0xda6a00:256,0xda6b00:256,0xda6c00:256,0xda6d00:256,0xdab9c0:16,0xdab9d0:16,0xdab9f0:4,0xdab9f4:4,0xdac000:256,0xdac100:256,0xdac200:256,0xdac300:256,0xdac400:1024,0xdac800:1024,0xdacc00:256,0xdacd00:256,0xdace00:256,0xdacf00:256,0xdaf000:1024,0xdaf400:256,0xdaf500:256,0xdaf600:256,0xdaf700:256,0xdaf900:256},{0xdb4800:256,0xdb5200:256,0xdb5380:64,0xdb53c0:64,0xdb5a44:4,0xdb5a48:4,0xdb5a4c:4,0xdb8000:1024,0xdb8400:1024,0xdb8800:1024,0xdb8c00:1024,0xdb9000:1024,0xdb9400:256,0xdb9500:64,0xdb9540:64,0xdb9580:64,0xdb95c0:64,0xdb9600:16,0xdb9610:16,0xdb9620:16,0xdb9630:16,0xdb9640:16,0xdb9650:16,0xdb9660:16,0xdb9670:16,0xdb9680:64,0xdb96c0:64,0xdb9700:16,0xdb9710:16,0xdb9720:16,0xdb9730:16,0xdb9740:64,0xdb9780:64,0xdb97c0:64,0xdb9800:256,0xdb9900:256,0xdb9a00:256,0xdb9b00:256,0xdb9c00:256,0xdb9d00:256,0xdb9e00:64,0xdb9e40:64,0xdb9e80:64,0xdb9ec0:64,0xdb9f00:64,0xdb9f40:64,0xdb9f80:64,0xdb9fc0:64,0xdbd800:256,0xdbd900:256,0xdbda00:256,0xdbdb00:256,0xdbdc00:256,0xdbdd00:256,0xdbde00:256,0xdbdf00:256,0xdbe000:256,0xdbe100:256,0xdbe200:256,0xdbe300:256,0xdbe400:256,0xdbe500:256,0xdbe600:256,0xdbe700:256,0xdbe800:1024,0xdbec00:256,0xdbed00:256,0xdbee00:256,0xdbef00:256,0xdbf200:256,0xdbf300:256,0xdbf400:1024},{0xdc65c0:64,0xdc7000:1024,0xdc9880:64,0xdc98c0:64,0xdc9a00:256,0xdc9b00:256,0xdc9ef0:4,0xdca000:1024,0xdca400:1024,0xdca800:1024,0xdcac00:1024,0xdcb000:1024,0xdcb400:1024,0xdcb800:1024,0xdcbc00:1024,0xdcc000:256,0xdcc100:256,0xdcc200:256,0xdcc300:256,0xdcc400:1024,0xdcc800:1024,0xdccc00:1024,0xdce700:64,0xdce780:64,0xdce7c0:64,0xdce840:64,0xdcea00:256,0xdcf200:256,0xdcf300:256,0xdcf788:4,0xdcf78c:4,0xdcf800:1024,0xdcfc00:256},{0xdd0000:256,0xdd0100:256,0xdd0200:256,0xdd0300:64,0xdd0340:64,0xdd0380:64,0xdd03c0:64,0xdd0400:256,0xdd0500:64,0xdd0540:64,0xdd0580:64,0xdd05c0:64,0xdd0600:256,0xdd0700:16,0xdd0710:16,0xdd0720:16,0xdd0730:16,0xdd0740:16,0xdd0750:16,0xdd0760:16,0xdd0770:16,0xdd0780:64,0xdd07c0:64,0xdd0800:256,0xdd0900:256,0xdd0a00:256,0xdd0b00:64,0xdd0b40:64,0xdd0b80:64,0xdd0bc0:16,0xdd0bd0:16,0xdd0be0:16,0xdd0bf0:16,0xdd0c00:64,0xdd0c40:64,0xdd0c80:64,0xdd0d00:64,0xdd0d40:16,0xdd0d50:16,0xdd0d60:16,0xdd0d70:16,0xdd0d80:64,0xdd0dc0:64,0xdd0e00:256,0xdd0f00:256,0xdd7a00:256,0xdd7b00:256,0xdd8080:64,0xdd80c0:64,0xdd8100:256,0xdd8200:256,0xdd8300:256,0xdd85e0:16,0xdd85f0:16,0xdd8800:256,0xdd8900:256,0xddac00:1024,0xddb000:1024,0xddb400:1024,0xddc000:256,0xddc100:256,0xddc200:256,0xddc300:256,0xddc400:256,0xddc500:256,0xddc600:256,0xddc700:16,0xddc710:16,0xddc720:16,0xddc730:16,0xddc740:64,0xddc780:64,0xddc7c0:16,0xddc7e0:16,0xddc7f0:16,0xddc800:1024,0xddcc00:256,0xddcd00:256,0xddce00:256,0xddcf00:64,0xddcf40:64,0xddcf80:64,0xddcfc0:64,0xddd000:1024,0xddd400:256,0xddd500:256,0xddd600:256,0xddd700:256,0xddd800:1024,0xdddc00:1024,0xdde000:1024,0xdde400:1024,0xdde800:1024,0xddec00:256,0xdded00:256,0xddee00:256,0xddef00:64,0xddef40:64,0xddef80:64,0xddefc0:64},{0xde1000:256,0xde1100:256,0xde1200:256,0xde1300:256,0xde1400:256,0xde1500:256,0xde1600:256,0xde1700:256,0xde1800:256,0xde1900:256,0xde1a00:256,0xde1b00:256,0xde1c00:1024,0xde2000:1024,0xde2400:1024,0xde2800:1024,0xde2c00:1024,0xde3000:1024,0xde3400:1024,0xde3800:1024,0xde3c00:1024,0xde4000:1024,0xde4400:1024,0xde4800:256,0xde4900:256,0xde4a00:256,0xde4b00:256,0xde4c00:1024,0xde5000:256,0xde5100:256,0xde5200:256,0xde5300:64,0xde5340:64,0xde5380:64,0xde53c0:64,0xde5400:256,0xde5500:64,0xde5540:64,0xde5580:64,0xde55c0:64,0xde5600:256,0xde5700:256,0xde5800:256,0xde5900:256,0xde5a00:256,0xde5b00:256,0xde5c00:1024,0xde7d00:256,0xde7e80:64,0xde7ec0:64,0xde8000:1024,0xde8400:1024,0xde8800:1024,0xde8c00:1024,0xdea000:256,0xdea100:256,0xdea200:256,0xdea300:16,0xdea310:16,0xdea320:16,0xdea330:16,0xdea340:64,0xdea380:64,0xdea3c0:64,0xdea800:256,0xdea900:256,0xdeaa00:256,0xdeab00:256,0xdeac00:64,0xdeac40:64,0xdeac80:64,0xdeacc0:64,0xdead00:256,0xdeae00:256,0xdeaf00:256,0xdeb000:1024,0xdeb400:1024,0xdeb800:1024,0xdebc00:1024,0xdec000:1024,0xdec400:256,0xdec500:256,0xdec600:256,0xdec700:256,0xdec800:1024,0xdecc00:256,0xdecd00:256,0xdece00:256,0xdecf00:256,0xded000:1024,0xded400:1024,0xded800:256,0xded900:256,0xdeda00:256,0xdedb00:256,0xdedc00:256,0xdedd00:256,0xdede00:256,0xdedf00:256,0xdef000:1024,0xdef400:1024,0xdef800:256,0xdef900:64,0xdef940:64,0xdef980:16,0xdef990:16,0xdef9a0:16,0xdef9b0:16,0xdef9c0:64},{0xdf0000:256,0xdf0100:256,0xdf0200:256,0xdf0300:256,0xdf0400:1024,0xdf0800:1024,0xdf0c00:1024,0xdf1400:256,0xdf1500:256,0xdf1bb8:4,0xdf1dd0:4,0xdf1dfc:4,0xdf4000:1024,0xdf4400:1024,0xdf4800:1024,0xdf4c00:1024,0xdf5000:1024,0xdf5400:1024,0xdf5800:1024,0xdf5c00:1024,0xdf6000:1024,0xdf6400:1024,0xdf6800:1024,0xdf6c00:1024,0xdf7000:1024,0xdf7400:256,0xdf7500:256,0xdf7800:1024,0xdf7c00:1024,0xdf8000:256,0xdf8100:256,0xdf8208:4,0xdf9000:1024,0xdf9400:1024,0xdf9800:1024,0xdf9c00:1024,0xdfa000:1024,0xdfa600:256,0xdfa700:256,0xdfc000:256,0xdfc100:256,0xdfc600:256,0xdfc700:256,0xdfc900:256,0xdfca00:256,0xdfcb00:256,0xdfd000:1024,0xdfd400:256,0xdfd500:256,0xdfd600:256,0xdfd700:256,0xdfdc00:256,0xdfdd00:256,0xdfdfb0:16,0xdfdfc0:16,0xdff000:1024,0xdff400:1024,0xdff800:1024,0xdffc80:64,0xdffcc0:64,0xdffe00:256,0xdfff00:64,0xdfff40:64,0xdfffec:4,0xdffffc:2}
];
var cnIp16Range = {
0x400:1,0x404:1,0x408:1,0x410:1,0x428:1,0x3800:1,0x3804:1,0x3805:1,0x399a:1,0x3b00:1,0x3b01:1,0x6c02:1,0x6c03:1,0x6c8b:1,0x6cc8:1,0x6cd9:1,0x6cda:1,0x6d8b:1,0x6dab:1,0x6db4:1,0x6db5:1,0x6dc1:1,0x6dd0:1,0x6de5:1,0x6e0f:1,0x9000:1,0x9094:1,0x93fd:1,0x93fe:1,0x93ff:1,0x9c00:1,0xa800:1,0xa804:1,0xa8fa:1,0xa94d:1,0xa981:1,0xa98d:1,0xa9ec:1,0xaa70:1,0xaaed:1,0xab08:1,0xaf80:1,0xaf81:1,0xaf82:1,0xaf83:1,0xaf85:1,0xaf86:1,0xaf87:1,0xaf88:1,0xaf89:1,0xaf8a:1,0xaf8b:1,0xaf8c:1,0xaf8d:1,0xaf8e:1,0xaf8f:1,0xaf90:1,0xaf91:1,0xaf92:1,0xaf93:1,0xaf94:1,0xaf95:1,0xaf96:1,0xaf97:1,0xaf98:1,0xaf99:1,0xaf9a:1,0xaf9b:1,0xaf9c:1,0xaf9d:1,0xaf9e:1,0xafb0:1,0xafb1:1,0xafb2:1,0xafb3:1,0xafb4:1,0xafb5:1,0xafb6:1,0xafb7:1,0xafb8:1,0xafb9:1,0xafba:1,0xafbb:1,0xafbc:1,0xafbd:1,0xafbe:1,0xafc0:1,0xafc1:1,0xafc2:1,0xafc3:1,0xafc4:1,0xafc5:1,0xafc6:1,0xafc7:1,0xafc8:1,0xafc9:1,0xafca:1,0xafcb:1,0xafcc:1,0xafcd:1,0xafce:1,0xafcf:1,0xafd8:1,0xafd9:1,0xafdb:1,0xafdc:1,0xafdd:1,0xafde:1,0xafdf:1,0xafe0:1,0xafe1:1,0xafe2:1,0xafe3:1,0xafe4:1,0xafe5:1,0xafe6:1,0xafe7:1,0xafe8:1,0xafe9:1,0xafea:1,0xafeb:1,0xafec:1,0xafed:1,0xafef:1,0xaff0:1,0xaff3:1,0xaff8:1,0xaff9:1,0xaffa:1,0xaffb:1,0xaffc:1,0xaffd:1,0xaffe:1,0xafff:1,0xb504:1,0xb5c2:1,0xb5c3:1,0xb5c4:1,0xb5c5:1,0xb5c6:1,0xb5c7:1,0xb5c8:1,0xb5c9:1,0xb5ca:1,0xb5cb:1,0xb5cc:1,0xb5cd:1,0xb5ce:1,0xb5cf:1,0xb5d0:1,0xb5d1:1,0xb5d2:1,0xb5d3:1,0xb5d4:1,0xb5d5:1,0xb5d7:1,0xb5dc:1,0xb5dd:1,0xb5de:1,0xb5df:1,0xb5e1:1,0xb5e2:1,0xb5e3:1,0xb5e4:1,0xb5e5:1,0xb5e6:1,0xb5e7:1,0xb5e8:1,0xb5e9:1,0xb5ea:1,0xb5eb:1,0xb5ec:1,0xb5ed:1,0xb5ee:1,0xb5ef:1,0xb5f0:1,0xb5f1:1,0xb5f2:1,0xb5f3:1,0xb5f4:1,0xb5f5:1,0xb5f6:1,0xb5f8:1,0xb5f9:1,0xb5fb:1,0xb5fc:1,0xb5fd:1,0xb5fe:1,0xb5ff:1,0xc600:1,0xc7db:1,0xe907:1,0xee60:1,0xee61:1,0xee64:1,0xee65:1,0xee66:1,0xee67:1,0xeeff:1,0xf411:1,0xf412:1,0xf422:1,0xf43b:1,0xf470:1,0xf477:1,0xf4b7:1,0xf619:1,0x19400:1,0x19404:1,0x1940a:1,0x194c8:1,0x194d5:1,0x194df:1,0x19538:1,0x19580:1,0x1958d:1,0x19595:1,0x19599:1,0x195b9:1,0x19600:1,0x1972e:1,0x197a9:1,0x197ec:1,0x19c04:1,0x19c05:1,0x19c06:1,0x19c09:1,0x19c0a:1,0x19c0b:1,0x19c0d:1,0x19c0e:1,0x19c10:1,0x19c12:1,0x19c13:1,0x19c14:1,0x19c16:1,0x19c17:1,0x19c19:1,0x19c1b:1,0x19c1c:1,0x19c1e:1,0x19c1f:1,0x19c20:1,0x19c21:1,0x19c22:1,0x19c23:1,0x19c24:1,0x19c25:1,0x19c26:1,0x19c27:1,0x19c28:1,0x19c29:1,0x19c2a:1,0x19c2e:1,0x19c30:1,0x19c31:1,0x19c32:1,0x19c33:1,0x19c34:1,0x19c35:1,0x19c36:1,0x19c37:1,0x19c39:1,0x19c3a:1,0x19c3b:1,0x19c3c:1,0x19c3d:1,0x19c3f:1,0x19c40:1,0x19c41:1,0x19c44:1,0x19c45:1,0x19c46:1,0x19c47:1,0x19c4b:1,0x19c4c:1,0x19c4d:1,0x19c4f:1,0x19c50:1,0x19c51:1,0x19c52:1,0x19c53:1,0x19c55:1,0x19c56:1,0x19c57:1,0x19c58:1,0x19c59:1,0x19c5a:1,0x19c5b:1,0x19c5c:1,0x19c5e:1,0x19c5f:1,0x19c61:1,0x19c62:1,0x19c63:1,0x19c64:1,0x19c65:1,0x19c66:1,0x19c67:1,0x19c68:1,0x19c69:1,0x19c6a:1,0x19c6b:1,0x19c6c:1,0x19c6d:1,0x19c6f:1,0x19c70:1,0x19c73:1,0x19c74:1,0x19c76:1,0x19c78:1,0x19c79:1,0x19c7a:1,0x19c7b:1,0x19c7c:1,0x19c7d:1,0x19c7e:1,0x19c7f:1,0x19c80:1,0x19c81:1,0x19c82:1,0x19c83:1,0x19c84:1,0x19c85:1,0x19c86:1,0x19c87:1,0x19c88:1,0x19c89:1,0x19c8a:1,0x19c8b:1,0x19c8c:1,0x19c8d:1,0x19c8f:1,0x19c90:1,0x19c91:1,0x19c92:1,0x19c93:1,0x19c94:1,0x19c95:1,0x19c96:1,0x19c97:1,0x19c98:1,0x19c99:1,0x19c9a:1,0x19c9b:1,0x19c9c:1,0x19c9d:1,0x19c9e:1,0x19c9f:1,0x19ca0:1,0x19ca1:1,0x19ca3:1,0x19ca4:1,0x19ca5:1,0x19ca6:1,0x19ca7:1,0x19ca8:1,0x19ca9:1,0x19caa:1,0x19cab:1,0x19cac:1,0x19cad:1,0x19cae:1,0x19caf:1,0x19cb0:1,0x19cb1:1,0x19cb2:1,0x19cb3:1,0x19cb4:1,0x19cb5:1,0x19cb6:1,0x19cb7:1,0x19cb8:1,0x19cb9:1,0x19cba:1,0x19cbb:1,0x19cbc:1,0x19cbd:1,0x19cbe:1,0x19cbf:1,0x19cc0:1,0x19cc1:1,0x19cc2:1,0x19cc3:1,0x19cc4:1,0x19cc5:1,0x19cc6:1,0x19cc7:1,0x19cc8:1,0x19cc9:1,0x19cca:1,0x19ccb:1,0x19cd0:1,0x19cd1:1,0x19cd2:1,0x19cd3:1,0x19cd4:1,0x19cd5:1,0x19cd6:1,0x19cd7:1,0x19cd8:1,0x19cda:1,0x19cdb:1,0x19cdc:1,0x19cdd:1,0x19cde:1,0x19cdf:1,0x19ce0:1,0x19ce1:1,0x19ce2:1,0x19ce3:1,0x19ce4:1,0x19ce5:1,0x19ce6:1,0x19ce7:1,0x19ce8:1,0x19cea:1,0x19ced:1,0x19cee:1,0x19cef:1,0x19cf0:1,0x19cf2:1,0x19cf3:1,0x19cf4:1,0x19cf5:1,0x19cf6:1,0x19cf8:1,0x19cf9:1,0x19cfa:1,0x19cfb:1,0x19cfc:1,0x19cfd:1,0x19cfe:1,0x19cff:1,0x19f00:1,0x19f01:1,0x19f02:1,0x19f03:1,0x19f04:1,0x19f05:1,0x19f06:1,0x19f07:1,0x19f08:1,0x19f0b:1,0x19f0d:1,0x19f0e:1,0x19f0f:1,0x19f10:1,0x19f11:1,0x19f12:1,0x19f13:1,0x19f16:1,0x19f17:1,0x19f18:1,0x19f19:1,0x19f1a:1,0x19f1b:1,0x19f1e:1,0x19f1f:1,0x19f20:1,0x19f21:1,0x19f22:1,0x19f23:1,0x19f24:1,0x19f25:1,0x19f26:1,0x19f27:1,0x19f28:1,0x19f29:1,0x19f2a:1,0x19f2b:1,0x19f2c:1,0x19f2d:1,0x19f2e:1,0x19f2f:1,0x19f30:1,0x19f31:1,0x19f32:1,0x19f33:1,0x19f34:1,0x19f35:1,0x19f36:1,0x19f37:1,0x19f38:1,0x19f39:1,0x19f3a:1,0x19f3c:1,0x19f3d:1,0x19f3e:1,0x19f3f:1,0x19f40:1,0x19f42:1,0x19f45:1,0x19f46:1,0x19f47:1,0x19f48:1,0x19f49:1,0x19f4a:1,0x19f4b:1,0x19f4c:1,0x19f4d:1,0x19f4e:1,0x19f4f:1,0x19f80:1,0x19f81:1,0x19f83:1,0x19f85:1,0x19f88:1,0x19f89:1,0x19f8a:1,0x19f8b:1,0x19f8c:1,0x19f8d:1,0x19f8e:1,0x19f8f:1,0x19f90:1,0x19f91:1,0x19f92:1,0x19f93:1,0x19f94:1,0x19f96:1,0x19f97:1,0x19f98:1,0x19f99:1,0x19f9b:1,0x19f9c:1,0x19f9d:1,0x19f9e:1,0x19f9f:1,0x19fa0:1,0x19fa2:1,0x19fa3:1,0x19fa4:1,0x19fa5:1,0x19fa6:1,0x19fa7:1,0x19fa8:1,0x19fa9:1,0x19faa:1,0x19fab:1,0x19fac:1,0x19fad:1,0x19fae:1,0x19faf:1,0x19fb0:1,0x19fb1:1,0x19fb2:1,0x19fb3:1,0x19fb4:1,0x19fb5:1,0x19fb6:1,0x19fb7:1,0x19fb8:1,0x19fb9:1,0x19fba:1,0x19fbb:1,0x19fbc:1,0x19fbd:1,0x19fbe:1,0x19fbf:1,0x19fc0:1,0x19fc1:1,0x19fc2:1,0x19fc3:1,0x19fc4:1,0x19fc5:1,0x19fc6:1,0x19fc7:1,0x19fc8:1,0x19fc9:1,0x19fca:1,0x19fcb:1,0x19fce:1,0x19fcf:1,0x19fd0:1,0x19fd1:1,0x19fd2:1,0x19fd3:1,0x19fd4:1,0x19fd5:1,0x19fd6:1,0x19fd8:1,0x19fd9:1,0x19fda:1,0x19fde:1,0x19fdf:1,0x19fe0:1,0x19fe1:1,0x19fe2:1,0x19fe3:1,0x19fe4:1,0x19fe5:1,0x19fe6:1,0x19fe7:1,0x19fe8:1,0x19fe9:1,0x19fea:1,0x19feb:1,0x19fec:1,0x19fed:1,0x19fee:1,0x19fef:1,0x19ff0:1,0x19ff1:1,0x19ff2:1,0x19ff3:1,0x19ff4:1,0x19ff7:1,0x19ff8:1,0x19ff9:1,0x19ffa:1,0x19ffb:1,0x19ffd:1,0x19ffe:1,0x19fff:1,0x1a800:1,0x1b888:1,0x1b8b0:1,0x1b8b2:1,0x1b92e:1,0x1b930:1,0x1b932:1,0x1b971:1,0x1b974:1,0x1ba94:1,0x1bab4:1,0x1bab5:1,0x1bab7:1,0x1bba0:1,0x1bd0f:1,0x1bd11:1,0x1bd6f:1,0x1bd73:1,0x1bddb:1,0x1bdde:1,0x1bf74:1,0x1bf7c:1,0x1bf7f:1,0x1bfad:1,0x1bfae:1,0x1c224:1,0x1c42f:1,0x1c457:1,0x1c4d2:1,0x1c4d3:1,0x1c4ef:1,0x1c609:1,0x1c715:1,0x1c741:1,0x1c751:1,0x1c752:1,0x1c87d:1,0x1c9b8:1,0x1c9bc:1,0x1c9be:1,0x1c9df:1,0x1ca35:1,0x1cb1b:1,0x1cc7d:1,0x1cca8:1,0x1cd15:1,0x1cd53:1,0x1cdf0:1,0x1ce99:1,0x1ceec:1,0x1d000:1,0x1d0c8:1,0x1d0ea:1,0x1d0eb:1,0x1d112:1,0x1d166:1,0x1d169:1,0x1d16a:1,0x1d304:1,0x1d306:1,0x1d316:1,0x1d31e:1,0x1d352:1,0x1d354:1,0x1d358:1,0x1d359:1,0x1d3f9:1,0x1d4d4:1,0x1d4d6:1,0x1d529:1,0x1d59c:1,0x1d59d:1,0x1d59e:1,0x1d5a2:1,0x1d5e7:1,0x1d90d:1,0x1d960:1,0x1d96f:1,0x1d998:1,0x1d99e:1,0x1d9fe:1,0x1db04:1,0x1db05:1,0x1dc08:1,0x1dc3e:1,0x1dc4b:1,0x1dc6e:1,0x1dc78:1,0x1dc7f:1,0x1dc9b:1,0x1dca1:1,0x1dca8:1,0x1dcaa:1,0x1dcab:1,0x1dcfc:1,0x1dd2f:1,0x1dd4b:1,0x1de52:1,0x1de83:1,0x1de85:1,0x1dff1:1,0x1dff3:1,0x1e120:1,0x1e160:1,0x1e220:1,0x1e23e:1,0x1e400:1,0x1e4b9:1,0x1e4c8:1,0x1e4d2:1,0x1e4d3:1,0x1e4da:1,0x1e4ea:1,0x1e597:1,0x1e723:1,0x1e82a:1,0x1e998:1,0x1e999:1,0x1ea01:1,0x1eb20:1,0x1eb24:1,0x1ebe0:1,0x1ebfd:1,0x1ecca:1,0x1eceb:1,0x1ed90:1,0x1edb2:1,0x1edb3:1,0x1ee21:1,0x1eec0:1,0x1eec1:1,0x1efcb:1,0x1eff9:1,0x1f054:1,0x1f0a1:1,0x1f0a3:1,0x1f1b0:1,0x1f1b5:1,0x1f759:1,0x224ed:1,0x22c14:1,0x22c15:1,0x24b10:1,0x24b11:1,0x25a06:1,0x25a07:1,0x25bc8:1,0x25bc9:1,0x25bca:1,0x25bcb:1,0x2804f:1,0x28050:1,0x28328:1,0x283b9:1,0x28cbc:1,0x28cd4:1,0x28cd5:1,0x28cd6:1,0x28cd7:1,0x29f73:1,0x2bdbd:1,0x2bdbe:1,0x2be79:1,0x2bec2:1,0x2d178:1,0x2d179:1,0x2d250:1,0x2d252:1,0x2d253:1,0x2d256:1,0x2d25a:1,0x2d2c9:1,0x2d2f6:1,0x2d323:1,0x2d34b:1,0x2d37b:1,0x2d3a5:1,0x2d3a6:1,0x2d3ad:1,0x2d3ae:1,0x2d842:1,0x2d843:1,0x2d85e:1,0x2d85f:1,0x2d8c1:1,0x2d8c8:1,0x2d8c9:1,0x2d8db:1,0x2da81:1,0x2dbb4:1,0x2dbbc:1,0x2dd3a:1,0x2dd46:1,0x2dd6e:1,0x2ded8:1,0x301f2:1,0x302f2:1,0x32801:1,0x32802:1,0x3280e:1,0x32812:1,0x32813:1,0x32817:1,0x32818:1,0x32819:1,0x3281a:1,0x32820:1,0x32821:1,0x32822:1,0x32823:1,0x32824:1,0x32829:1,0x32830:1,0x32831:1,0x32839:1,0x3283a:1,0x3283b:1,0x32851:1,0x32854:1,0x32856:1,0x3285b:1,0x3286e:1,0x32898:1,0x32899:1,0x3289a:1,0x328a0:1,0x328a2:1,0x328a4:1,0x328a6:1,0x328a7:1,0x328ad:1,0x328ae:1,0x328b0:1,0x328b1:1,0x328b2:1,0x328b4:1,0x328b8:1,0x328ba:1,0x328bb:1,0x328bd:1,0x328be:1,0x328e7:1,0x328e8:1,0x328e9:1,0x328ec:1,0x328ef:1,0x328f0:1,0x328f1:1,0x328f2:1,0x328f5:1,0x328f9:1,0x328fb:1,0x328fd:1,0x328fe:1,0x328ff:1,0x32904:1,0x32905:1,0x3290a:1,0x3290c:1,0x32914:1,0x32918:1,0x32919:1,0x3291b:1,0x3291c:1,0x32920:1,0x32921:1,0x32926:1,0x32927:1,0x32928:1,0x32929:1,0x3292b:1,0x3292f:1,0x32933:1,0x32935:1,0x32938:1,0x3293f:1,0x32943:1,0x32944:1,0x32946:1,0x3294f:1,0x32950:1,0x32957:1,0x3295b:1,0x3295d:1,0x32960:1,0x32964:1,0x32965:1,0x32967:1,0x32968:1,0x32969:1,0x3296b:1,0x3296c:1,0x3296d:1,0x3296e:1,0x3296f:1,0x32970:1,0x32973:1,0x32974:1,0x32977:1,0x32979:1,0x3297c:1,0x3297f:1,0x32981:1,0x32982:1,0x32983:1,0x32984:1,0x32985:1,0x32987:1,0x32988:1,0x32989:1,0x3298a:1,0x3298b:1,0x3298d:1,0x3298e:1,0x3298f:1,0x32990:1,0x32991:1,0x32992:1,0x32993:1,0x32995:1,0x32997:1,0x32998:1,0x3299a:1,0x3299b:1,0x3299c:1,0x3299d:1,0x3299f:1,0x329be:1,0x329c4:1,0x329c7:1,0x329c8:1,0x329cc:1,0x329d0:1,0x329d1:1,0x329d8:1,0x329dc:1,0x329dd:1,0x329e8:1,0x329e9:1,0x329ea:1,0x329ed:1,0x329f0:1,0x329f5:1,0x329f6:1,0x329fc:1,0x329fd:1,0x329fe:1,0x329ff:1,0x32a08:1,0x32a0b:1,0x32a0c:1,0x32a0f:1,0x32a14:1,0x32a18:1,0x32a1a:1,0x32a1b:1,0x32a20:1,0x32a23:1,0x32a27:1,0x32a32:1,0x32a36:1,0x32a38:1,0x32a3c:1,0x32a3d:1,0x32a4a:1,0x32a4b:1,0x32a4e:1,0x32a50:1,0x32a51:1,0x32a54:1,0x32a56:1,0x32a57:1,0x32a58:1,0x32a5b:1,0x32a5c:1,0x32a5e:1,0x32a62:1,0x32a64:1,0x32a77:1,0x32a7a:1,0x32a82:1,0x32a89:1,0x32a90:1,0x32a91:1,0x32a95:1,0x32a96:1,0x32a97:1,0x32a9b:1,0x32aa1:1,0x32aa2:1,0x32aaa:1,0x32aab:1,0x32aaf:1,0x32ab0:1,0x32ab4:1,0x32ab5:1,0x32ab7:1,0x32ab9:1,0x32ac3:1,0x32ace:1,0x32acf:1,0x32ad2:1,0x32ad3:1,0x32ad4:1,0x32ad5:1,0x32ad8:1,0x32adb:1,0x32af5:1,0x32af6:1,0x32afc:1,0x32afd:1,0x32c00:1,0x32c01:1,0x32c02:1,0x32c03:1,0x32c04:1,0x32c05:1,0x32c07:1,0x32c09:1,0x32c0a:1,0x32c0b:1,0x32c0d:1,0x32c0e:1,0x32c12:1,0x32c13:1,0x32c14:1,0x32c15:1,0x32c16:1,0x32c17:1,0x32c1a:1,0x32c1b:1,0x32c1e:1,0x32c1f:1,0x32c20:1,0x32c21:1,0x32c22:1,0x32c23:1,0x32c24:1,0x32c25:1,0x32c26:1,0x32c28:1,0x32c29:1,0x32c2d:1,0x32c2e:1,0x32c2f:1,0x32c30:1,0x32c31:1,0x32c32:1,0x32c33:1,0x32c34:1,0x32c35:1,0x32c36:1,0x32c37:1,0x32c38:1,0x32c39:1,0x32c3a:1,0x32c3b:1,0x32c3c:1,0x32c3d:1,0x32c3e:1,0x32c3f:1,0x32c40:1,0x32c42:1,0x32c43:1,0x32c44:1,0x32c45:1,0x32c46:1,0x32c47:1,0x32c48:1,0x32c49:1,0x32c4a:1,0x32c4b:1,0x32c4c:1,0x32c4d:1,0x32c4e:1,0x32c4f:1,0x32c50:1,0x32c51:1,0x32c52:1,0x32c53:1,0x32c54:1,0x32c55:1,0x32c56:1,0x32c57:1,0x32c58:1,0x32c59:1,0x32c5a:1,0x32c5b:1,0x32c5c:1,0x32c5d:1,0x32c5e:1,0x32c5f:1,0x32c60:1,0x32c61:1,0x32c62:1,0x32c63:1,0x32c64:1,0x32c65:1,0x32c66:1,0x32c67:1,0x32c68:1,0x32c69:1,0x32c6a:1,0x32c6b:1,0x32c6c:1,0x32c6d:1,0x32c6f:1,0x32c70:1,0x32c71:1,0x32c72:1,0x32c73:1,0x32c74:1,0x32c75:1,0x32c76:1,0x32c77:1,0x32c78:1,0x32c79:1,0x32c7a:1,0x32c7b:1,0x32c7c:1,0x32c7d:1,0x32c7e:1,0x32c7f:1,0x32c80:1,0x32c81:1,0x32c82:1,0x32c83:1,0x32c84:1,0x32c85:1,0x32c86:1,0x32c87:1,0x32c88:1,0x32c89:1,0x32c8a:1,0x32c8b:1,0x32cdc:1,0x32cdd:1,0x32cde:1,0x32cdf:1,0x32ce0:1,0x32ce1:1,0x32ce2:1,0x32ce3:1,0x32ce4:1,0x32ce5:1,0x32ce6:1,0x32ce7:1,0x32cf8:1,0x32cfa:1,0x32cfb:1,0x32d32:1,0x32d33:1,0x32d36:1,0x32d38:1,0x32d3a:1,0x32d3c:1,0x32d40:1,0x32d42:1,0x32d44:1,0x32d47:1,0x32d48:1,0x32d49:1,0x32d4b:1,0x32d4c:1,0x32d4f:1,0x32d58:1,0x32d59:1,0x32d5b:1,0x32d60:1,0x32d63:1,0x32d64:1,0x32d66:1,0x32d68:1,0x32d6a:1,0x32d6b:1,0x32d6c:1,0x32d6d:1,0x32d70:1,0x32d72:1,0x32d74:1,0x32d76:1,0x32d78:1,0x32d7c:1,0x32d7d:1,0x32d7f:1,0x32d8c:1,0x32d8d:1,0x32d90:1,0x32d91:1,0x32d93:1,0x32da0:1,0x32da5:1,0x32da6:1,0x32dba:1,0x32dbb:1,0x32dc9:1,0x32dcb:1,0x32ddb:1,0x32ddc:1,0x32ddd:1,0x32e00:1,0x32e01:1,0x32e03:1,0x32e04:1,0x32e08:1,0x32e10:1,0x32e1b:1,0x32e1d:1,0x32e1e:1,0x32e3b:1,0x32e41:1,0x32e44:1,0x32e51:1,0x32e55:1,0x32e61:1,0x32e62:1,0x32e64:1,0x32e78:1,0x32e81:1,0x32e82:1,0x32e83:1,0x32e84:1,0x32e86:1,0x32e87:1,0x32e9a:1,0x32e9c:1,0x32ea0:1,0x32ea8:1,0x32eac:1,0x32eaf:1,0x32eb8:1,0x32eb9:1,0x32ebe:1,0x32ec1:1,0x32ec2:1,0x32ee1:1,0x32eee:1,0x32ef4:1,0x32ef5:1,0x32ef7:1,0x32ef9:1,0x32efb:1,0x32efc:1,0x32efe:1,0x32f00:1,0x32f07:1,0x32f09:1,0x32f0d:1,0x32f10:1,0x32f2b:1,0x32f35:1,0x32f40:1,0x32f47:1,0x32f50:1,0x32f51:1,0x32f5f:1,0x32f66:1,0x32f7b:1,0x32f7c:1,0x34808:1,0x34814:1,0x34816:1,0x3481c:1,0x34839:1,0x3483a:1,0x3483b:1,0x3483c:1,0x3483d:1,0x34841:1,0x3485c:1,0x348e3:1,0x34922:1,0x34924:1,0x34928:1,0x34929:1,0x3492a:1,0x34930:1,0x34938:1,0x3493a:1,0x3493f:1,0x3495e:1,0x34b01:1,0x34d8d:1,0x34e6d:1,0x3698b:1,0x36991:1,0x369a2:1,0x369a3:1,0x36ae7:1,0x36d69:1,0x36e58:1,0x36e59:1,0x36e5c:1,0x3727b:1,0x373de:1,0x3741c:1,0x3741d:1,0x3742f:1,0x37435:1,0x37617:1,0x3771c:1,0x3771f:1,0x37a8c:1,0x37be6:1,0x37c6e:1,0x37c77:1,0x37e08:1,0x37f7e:1,0x37f7f:1,0x37fff:1
};

var whiteIpList = {
	"188.188.188.188":1,
	"100.100.100.100":1
};

var subnetIpRangeList = [
0,1,
167772160,184549376,	//10.0.0.0/8
2886729728,2887778304,	//172.16.0.0/12
3232235520,3232301056,	//192.168.0.0/16
2130706432,2130706688	//127.0.0.0/24
];

var white_domains = {"biz":{
"changan":1,
"kuangchan":1
},"cc":{
"2che":1,
"55g":1,
"7mo":1,
"chengche":1,
"dqccc":1,
"eqz":1,
"globalbuy":1,
"hao315":1,
"hefei":1,
"huxi":1,
"jiangxia":1,
"jinnong":1,
"lbx":1,
"liaoba":1,
"qcr":1,
"qxw":1,
"starbaby":1,
"teambuy":1,
"ujian":1
},"cm":{
"4":1,
"60":1
},"com":{
"001jm":1,
"001job":1,
"01-123":1,
"010lf":1,
"01hr":1,
"020job":1,
"022s":1,
"025ct":1,
"0411hd":1,
"0460":1,
"0577job":1,
"07073":1,
"0734":1,
"0739tt":1,
"0755888":1,
"0771td":1,
"08px":1,
"0917":1,
"09jz":1,
"100":1,
"10010":1,
"100ppi":1,
"100xiao":1,
"100xuexi":1,
"100ye":1,
"100zhuang":1,
"1010jz":1,
"101jiajiao":1,
"10yan":1,
"110":1,
"111jz":1,
"11315":1,
"11464":1,
"11467":1,
"114chn":1,
"114la":1,
"114piaowu":1,
"114px":1,
"115":1,
"115img":1,
"1188":1,
"118rc":1,
"11jk":1,
"122park":1,
"123cha":1,
"126":1,
"138job":1,
"139life":1,
"13ejob":1,
"148-law":1,
"15153":1,
"1518":1,
"156580":1,
"163":1,
"164580":1,
"1688":1,
"16888":1,
"168dc":1,
"168rc":1,
"17173":1,
"17173cdn":1,
"178":1,
"17dm":1,
"17game":1,
"17house":1,
"17k":1,
"17liansuo":1,
"17u":1,
"18183":1,
"197c":1,
"19lou":1,
"19zhan":1,
"1techan":1,
"1ting":1,
"2000888":1,
"2011n":1,
"21-sun":1,
"2197079":1,
"21cbh":1,
"21cn":1,
"21cp":1,
"21dagong":1,
"21dnn":1,
"21pw":1,
"21rcw":1,
"21rv":1,
"2345":1,
"2366":1,
"2500sz":1,
"25pp":1,
"265":1,
"265g":1,
"28":1,
"2881":1,
"2shequ":1,
"2smtc":1,
"301688":1,
"30edu":1,
"3158":1,
"315che":1,
"31huiyi":1,
"3234":1,
"32800":1,
"32wan":1,
"333job":1,
"33map":1,
"33or":1,
"35":1,
"3533":1,
"360buy":1,
"360buyimg":1,
"360che":1,
"360doc":1,
"360hx":1,
"360hy":1,
"360wbl":1,
"360wyw":1,
"361games":1,
"365128":1,
"36578":1,
"365auto":1,
"365azw":1,
"365cgw":1,
"365heart":1,
"365jilin":1,
"365rili":1,
"365zhaosheng":1,
"368tea":1,
"37":1,
"37cs":1,
"37wan":1,
"3conline":1,
"3dfc":1,
"3dkezhan":1,
"3dwwwgame":1,
"3ghuashang":1,
"3qhouse":1,
"3s001":1,
"4006666688":1,
"4008885166":1,
"400jz":1,
"40407":1,
"4399":1,
"45575":1,
"47365":1,
"4738":1,
"4779":1,
"49you":1,
"500":1,
"51":1,
"510560":1,
"5120":1,
"51240":1,
"51511":1,
"5156edu":1,
"5173":1,
"51766":1,
"518ad":1,
"51auto":1,
"51buy":1,
"51chudui":1,
"51credit":1,
"51cto":1,
"51daifu":1,
"51ditu":1,
"51hejia":1,
"51jam":1,
"51jiameng":1,
"51jiaxiao":1,
"51jiemeng":1,
"51jishu":1,
"51job":1,
"51mp3ring":1,
"51qc":1,
"51rc":1,
"51rencai":1,
"51sole":1,
"51taonan":1,
"51tie":1,
"51ttyy":1,
"51wan":1,
"51yes":1,
"51youcai":1,
"51yunli":1,
"51zhantai":1,
"51zjxm":1,
"51zsjc":1,
"51zupu":1,
"51zx":1,
"521g":1,
"52njl":1,
"52pk":1,
"531city":1,
"533":1,
"53kf":1,
"54114":1,
"55":1,
"55bbs":1,
"55tuan":1,
"55tuanimg":1,
"55weixiu":1,
"56":1,
"5617":1,
"5652":1,
"566855":1,
"5669":1,
"566job":1,
"56img":1,
"58":1,
"5858":1,
"586jz":1,
"5874":1,
"587766":1,
"58fenlei":1,
"58house":1,
"59120":1,
"591wed":1,
"5925car":1,
"597":1,
"597rcw":1,
"5d6d":1,
"5fen":1,
"5i5j":1,
"61":1,
"628":1,
"66163":1,
"668city":1,
"66diqiu":1,
"66house":1,
"66wz":1,
"66zhuang":1,
"678114":1,
"68hr":1,
"7192":1,
"71zs":1,
"7273":1,
"72ce":1,
"766":1,
"769car":1,
"7755":1,
"7788":1,
"77zxw":1,
"79":1,
"7937":1,
"7940":1,
"7caiyun":1,
"7jia2":1,
"7k7k":1,
"7su":1,
"7xz":1,
"800hr":1,
"800pai":1,
"8014":1,
"80881":1,
"8090yxs":1,
"80tian":1,
"8264":1,
"84ktv":1,
"862sc":1,
"8684":1,
"86jzjob":1,
"86office":1,
"86qc":1,
"86wan":1,
"86zsw":1,
"88":1,
"88152":1,
"88h3":1,
"88tc":1,
"89178":1,
"898tc":1,
"8le8le":1,
"8uuzg":1,
"91":1,
"911cha":1,
"917":1,
"9191mr":1,
"91canyin":1,
"91cps":1,
"91jm":1,
"91town":1,
"91wan":1,
"92gzc":1,
"9377":1,
"95081":1,
"9588":1,
"958shop":1,
"969g":1,
"96pk":1,
"973":1,
"98znz":1,
"99":1,
"99114":1,
"99166":1,
"9939":1,
"996":1,
"997788":1,
"998":1,
"999brain":1,
"99bill":1,
"99cfw":1,
"99inf":1,
"99pet":1,
"99sushe":1,
"99wed":1,
"9che":1,
"9chew":1,
"9chun":1,
"9ku":1,
"9qc":1,
"9u8u":1,
"9wee":1,
"9ye":1,
"9you":1,
"9zjob":1,
"a22":1,
"a67":1,
"a963":1,
"abab":1,
"abang":1,
"abchina":1,
"accgame":1,
"acfun":1,
"acgvideo":1,
"acs86":1,
"admaimai":1,
"admin5":1,
"adnxs":1,
"adroll":1,
"adsame":1,
"adsonar":1,
"adtechus":1,
"afzhan":1,
"ahjgxy":1,
"aibang":1,
"aicai":1,
"aifang":1,
"aifangke":1,
"aifcdn":1,
"aihandu":1,
"aili":1,
"ailiuxue":1,
"aipai":1,
"aizhan":1,
"ajkimg":1,
"alibaba":1,
"alibole":1,
"alicdn":1,
"aliexpress":1,
"alifabu":1,
"aliimg":1,
"aliloan":1,
"alimama":1,
"alipay":1,
"alipayobjects":1,
"alisoft":1,
"aliyiyao":1,
"aliyun":1,
"allyes":1,
"am89":1,
"andaike":1,
"anfensi":1,
"anhuijrw":1,
"anhuinews":1,
"anjuke":1,
"anjukestatic":1,
"anxjm":1,
"any2000":1,
"aoshu":1,
"aoyou":1,
"app111":1,
"app17":1,
"appgame":1,
"apple":1,
"artxun":1,
"aseantradecenter":1,
"atdmt":1,
"austarstudy":1,
"auto18":1,
"autosup":1,
"auyou":1,
"b2b168":1,
"bafangwang":1,
"baicai":1,
"baicmotor":1,
"baidajob":1,
"baidu":1,
"baidustatic":1,
"baifubao":1,
"baihe":1,
"baike":1,
"bailitop":1,
"baiqi008":1,
"baixing":1,
"baixinger":1,
"baiye5":1,
"bamaol":1,
"bamuyu":1,
"banggo":1,
"bankcomm":1,
"bankhr":1,
"banma":1,
"banwojia":1,
"baobei360":1,
"baofeng":1,
"baomihua":1,
"baoming":1,
"baoming88":1,
"baoyuntong":1,
"bcjy123":1,
"bdchina":1,
"bdimg":1,
"becod":1,
"beiguorc":1,
"beijingrc":1,
"beitaichufang":1,
"bendibao":1,
"benxi0414":1,
"betrad":1,
"bianmincn":1,
"bidchance":1,
"bieshu":1,
"bilibili":1,
"bilinstar":1,
"bitauto":1,
"bitautoimg":1,
"bitautotech":1,
"biz178":1,
"bjp321":1,
"bjrc":1,
"blemall":1,
"blogbus":1,
"blogchina":1,
"blshe":1,
"bluekai":1,
"bmlink":1,
"boai":1,
"bokee":1,
"bokerb":1,
"bossgoo":1,
"bqqm":1,
"brandcn":1,
"brightdairy":1,
"btc114":1,
"btd":1,
"buildhr":1,
"burberry":1,
"buyiju":1,
"bxgtd":1,
"bzw315":1,
"c-c":1,
"cago365":1,
"caihao":1,
"cailiao":1,
"caipopo":1,
"caixin":1,
"cang":1,
"car0575":1,
"carschina":1,
"cat898":1,
"cbe21":1,
"cbinews":1,
"cbsrc":1,
"ccb":1,
"ccement":1,
"ccidnet":1,
"cctiedu":1,
"cctv":1,
"cctvpic":1,
"cdnet110":1,
"cdyee":1,
"cebbank":1,
"cecb2b":1,
"cersp":1,
"cf668":1,
"chahaoba":1,
"chahaotai":1,
"changyou":1,
"chazidian":1,
"che-piao":1,
"che168":1,
"cheaa":1,
"cheduo":1,
"cheduoshao":1,
"chem17":1,
"chemishu":1,
"chemnet":1,
"chengshizg":1,
"chenhr":1,
"chepin88":1,
"chepinnet":1,
"cheshi":1,
"cheshi-img":1,
"chetx":1,
"chetxia":1,
"chewen":1,
"chexun":1,
"cheyian":1,
"china":1,
"china-b":1,
"china-ef":1,
"china-fire":1,
"china-nengyuan":1,
"china-slate":1,
"china2car":1,
"china3-d":1,
"chinaacc":1,
"chinabreed":1,
"chinabyte":1,
"chinacars":1,
"chinaceot":1,
"chinachugui":1,
"chinacxgd":1,
"chinadyt":1,
"chinafudaoban":1,
"chinahr":1,
"chinahrt":1,
"chinaiiss":1,
"chinairn":1,
"chinaitlab":1,
"chinalawedu":1,
"chinaluxus":1,
"chinamenwang":1,
"chinamobile":1,
"chinamsr":1,
"chinanews":1,
"chinapp":1,
"chinaren":1,
"chinasexq":1,
"chinaso":1,
"chinasspp":1,
"chinatibetnews":1,
"chinatsi":1,
"chinaunicom":1,
"chinavnet":1,
"chinawutong":1,
"chinaxiaokang":1,
"chinaxinge":1,
"chinaz":1,
"chnsuv":1,
"chuangye":1,
"ci123":1,
"city8":1,
"ciwong":1,
"cjyyw":1,
"class01":1,
"clotheshr":1,
"cmbchina":1,
"cn-122":1,
"cn21edu":1,
"cn2che":1,
"cnadtop":1,
"cnair":1,
"cnal":1,
"cnbeta":1,
"cnblogs":1,
"cncn":1,
"cnelc":1,
"cnfol":1,
"cngaosu":1,
"cngba":1,
"cnhan":1,
"cnhubei":1,
"cnipai":1,
"cnjj":1,
"cnmo":1,
"cnpkm":1,
"cnradio":1,
"cnrdn":1,
"cnsqzx":1,
"cnstock":1,
"cnsuv":1,
"cnta":1,
"cntrades":1,
"cnwav":1,
"cnwest":1,
"cnxiantao":1,
"cnzhantuan":1,
"cnzz":1,
"co188":1,
"coaoo":1,
"compete":1,
"comsenz":1,
"conshow":1,
"cp2y":1,
"cpdyj":1,
"cqvip":1,
"crsky":1,
"cs090":1,
"csbew":1,
"csc86":1,
"csvw":1,
"ct10000":1,
"cthy":1,
"ctrip":1,
"ctsho":1,
"cttsd":1,
"cunan":1,
"cuncun8":1,
"cutv":1,
"cwan":1,
"cycnet":1,
"cyol":1,
"cztv":1,
"czvv":1,
"d8wed":1,
"dachenglaw":1,
"dachengnet":1,
"dadipedia":1,
"dadou":1,
"dafengso":1,
"daikuane":1,
"dajie":1,
"dangdang":1,
"danzhaowang":1,
"daodao":1,
"daoxila":1,
"daqi":1,
"davinfo":1,
"dayoo":1,
"dbgtzx":1,
"dbtc888":1,
"ddcsh":1,
"ddmap":1,
"dedecms":1,
"denghuo":1,
"deyiso":1,
"dezhi":1,
"dezhoudaily":1,
"dianping":1,
"dianpingba":1,
"dianyuan":1,
"dichan":1,
"dili360":1,
"dionly":1,
"ditan369":1,
"diyifanwen":1,
"djob":1,
"dld":1,
"dm0571":1,
"dmcbd":1,
"doc88":1,
"dooland":1,
"doomii":1,
"douban":1,
"dq247":1,
"dqccc":1,
"dqcccc":1,
"dqguo":1,
"dqjob88":1,
"dsdod":1,
"dshrc":1,
"dtxmw":1,
"duoshitong":1,
"duoshuo":1,
"duote":1,
"duowan":1,
"dushifang":1,
"dv37":1,
"dwstatic":1,
"dxddcx":1,
"dzsc":1,
"dzwww":1,
"e0575":1,
"e118114":1,
"ea3w":1,
"eachnet":1,
"eahui":1,
"easiu":1,
"eastday":1,
"eastmoney":1,
"ebay":1,
"ebdoor":1,
"ec818":1,
"ecaihr":1,
"eccn":1,
"ecitic":1,
"ecqun":1,
"edai":1,
"edu-hb":1,
"edu24ol":1,
"eduease":1,
"eduglobal":1,
"edushi":1,
"edutt":1,
"eduu":1,
"eeju":1,
"eelly":1,
"eeyy":1,
"ef360":1,
"efwang":1,
"ehr99":1,
"ehvacr":1,
"eiiq":1,
"eju":1,
"elanw":1,
"ellechina":1,
"elong":1,
"eoffcn":1,
"eooioo":1,
"epjob88":1,
"epweike":1,
"ersoso":1,
"esfimg":1,
"eshow365":1,
"esnai":1,
"esongyuan":1,
"etao":1,
"ewsos":1,
"exam8":1,
"examw":1,
"eyuyao":1,
"eywedu":1,
"fabu114":1,
"fang":1,
"fangbx":1,
"fangchan":1,
"fangdd":1,
"fanging":1,
"fangjia":1,
"fanglimei":1,
"fangtan007":1,
"fangtoo":1,
"fanlihe":1,
"fanxuefei":1,
"fastcdn":1,
"favolist":1,
"fblife":1,
"fccs":1,
"fcjjr":1,
"fdkjgz":1,
"feelcars":1,
"feeyo":1,
"fenfen":1,
"fengj":1,
"fengniao":1,
"fengyunzhibo":1,
"fenlei168":1,
"fenlei265":1,
"fensui168":1,
"fjcoop":1,
"fjnacc":1,
"fjnet":1,
"fjsen":1,
"fjta":1,
"fl78":1,
"flashget":1,
"foodjx":1,
"fs121":1,
"ftchinese":1,
"funshion":1,
"fwzjia":1,
"fx678":1,
"fz597":1,
"fzbm":1,
"fzg360":1,
"g207":1,
"gaibar":1,
"gaitu":1,
"gaizhui":1,
"gamesville":1,
"ganhuoche":1,
"ganji":1,
"ganjiangrc":1,
"ganjistatic1":1,
"ganwan":1,
"ganzhe":1,
"gao7":1,
"gaofen":1,
"gaokao":1,
"gaosubao":1,
"gasgoo":1,
"gd-fishmarket":1,
"gdrc":1,
"gdsxxw":1,
"gdttc":1,
"geely":1,
"geo-show":1,
"gesep":1,
"gexing":1,
"gkzhan":1,
"glinfo":1,
"globalmarket":1,
"globrand":1,
"glyrc":1,
"go007":1,
"go2map":1,
"goepe":1,
"gogocn":1,
"gojiaju":1,
"gold678":1,
"gongcai":1,
"gongchang":1,
"gongjiao":1,
"gonren":1,
"goo2sc":1,
"goocun":1,
"google-analytics":1,
"googleadservices":1,
"googlesyndication":1,
"goufang":1,
"gougou":1,
"gqsoso":1,
"gridsumdissector":1,
"gsdpw":1,
"gtimg":1,
"gtobal":1,
"guangdongrc":1,
"guangxirc":1,
"guanzhongrc":1,
"gucheng":1,
"guhantai":1,
"guiguanrc":1,
"guijirc":1,
"guilinlife":1,
"guimi":1,
"guiqianrc":1,
"guolv":1,
"gx123":1,
"gxorg":1,
"gxrc":1,
"gzmanny":1,
"gzqnzyz":1,
"gzrencai":1,
"haibao":1,
"hainanfz":1,
"hancheng":1,
"hangye8":1,
"hanweb":1,
"hao123":1,
"hao315":1,
"haobangni":1,
"haochi123":1,
"haodai":1,
"haodf":1,
"haofz":1,
"haoliv":1,
"haopoo":1,
"haotijin":1,
"haotui":1,
"haowangpu":1,
"haozhanhui":1,
"harrenmedianetwork":1,
"haxiu":1,
"hbrc":1,
"hbsjz110":1,
"hbzhan":1,
"hc360":1,
"hd512":1,
"henanrc":1,
"hengqijy":1,
"herostart":1,
"hexun":1,
"hf365":1,
"hgrencai":1,
"hgzrc":1,
"hiapk":1,
"hipiao":1,
"hjenglish":1,
"hkproperty":1,
"hlpolice":1,
"hly":1,
"hnzssj":1,
"home77":1,
"homeinns":1,
"homekoo":1,
"hometex114":1,
"hongxiu":1,
"horsehr":1,
"house365":1,
"houxue":1,
"hqbpc":1,
"hqcr":1,
"hqew":1,
"hqsxy":1,
"hr006":1,
"hr1000":1,
"hr369":1,
"hrbit":1,
"hrbuilds":1,
"hrpin":1,
"htexam":1,
"htinns":1,
"httpcn":1,
"huabian":1,
"hualady":1,
"hualongxiang":1,
"huamanche":1,
"huangye88":1,
"huanqiu":1,
"huapinwang":1,
"huatu":1,
"huaxirc":1,
"huayuejob":1,
"hubeirc":1,
"hudong":1,
"huiche":1,
"huimaiche":1,
"huishoushang":1,
"huixiaodai":1,
"hujiang":1,
"hunantv":1,
"hunlimama":1,
"hunt007":1,
"huochepiao":1,
"huowan":1,
"hupu":1,
"hx116":1,
"hx2car":1,
"hxyjw":1,
"hytechan":1,
"hzins":1,
"i1515":1,
"iask":1,
"ibangkf":1,
"ibicn":1,
"ic98":1,
"iciba":1,
"icson":1,
"icxo":1,
"idqqimg":1,
"ieche":1,
"iecity":1,
"iefang":1,
"ifeng":1,
"ifengimg":1,
"ihanhua":1,
"ijia360":1,
"ijinshan":1,
"ikaka":1,
"img.cctvpic":1,
"imqq":1,
"imrworldwide":1,
"infzm":1,
"invitemedia":1,
"ip138":1,
"ipadown":1,
"ipincai":1,
"ipinyou":1,
"iqilu":1,
"iqiyi":1,
"irs01":1,
"ishaanxi":1,
"it168":1,
"iteye":1,
"ithome":1,
"iyaxin":1,
"iyaya":1,
"iyizhai":1,
"izhufu":1,
"jaz581":1,
"jc35":1,
"jc68":1,
"jcoal":1,
"jcrb":1,
"jctrans":1,
"jd":1,
"jdcjsr":1,
"jdjob88":1,
"jdsc35":1,
"jdzj":1,
"jfdaily":1,
"jia":1,
"jia360":1,
"jia400":1,
"jiajiao114":1,
"jiajiao400":1,
"jiaju":1,
"jiameng":1,
"jiameng8":1,
"jiancai":1,
"jianghuairc":1,
"jiangshi":1,
"jiangsurc":1,
"jiangxirc":1,
"jiankongbao":1,
"jianzhi8":1,
"jianzhiabc":1,
"jiaomai":1,
"jiaoman":1,
"jiathis":1,
"jiatx":1,
"jiayuan":1,
"jiazhao":1,
"jidongrc":1,
"jilinfc":1,
"jinfr":1,
"jingchurc":1,
"jingjiawang":1,
"jingwumeishi":1,
"jinjianginns":1,
"jinmenrc":1,
"jinquktv":1,
"jinshangrc":1,
"jinti":1,
"jiu6":1,
"jiwu":1,
"jjjaaa":1,
"jnesc":1,
"job-sky":1,
"job10000":1,
"job1001":1,
"job120":1,
"job128":1,
"job369":1,
"job5156":1,
"job592":1,
"job910":1,
"jobcn":1,
"jobfn":1,
"jobuy":1,
"jobvvv":1,
"joobbe":1,
"joyes":1,
"jqw":1,
"jr18":1,
"jssjys":1,
"jstv":1,
"jsyks":1,
"jt122":1,
"jthysh":1,
"jtimg":1,
"jtlhome":1,
"jtxxol":1,
"ju51":1,
"juchang":1,
"jumei":1,
"juren":1,
"juxia":1,
"jxedt":1,
"jxga":1,
"jxgdw":1,
"jxjas":1,
"jxtutechan":1,
"jxwei":1,
"jyyuan":1,
"jzb":1,
"k18":1,
"k8008":1,
"kaba365":1,
"kaichewan":1,
"kaifu":1,
"kaiwind":1,
"kaixin001":1,
"kandian":1,
"kanglu":1,
"kanimg":1,
"kankan":1,
"kanshu":1,
"kds100":1,
"kdslife":1,
"kedou":1,
"kejiqi":1,
"kenfor":1,
"keqii":1,
"keyunzhan":1,
"kingdee":1,
"kmguolv":1,
"knowsky":1,
"koolearn":1,
"koubei":1,
"ktvcity":1,
"ku6":1,
"ku6cdn":1,
"ku6img":1,
"kuaidi100":1,
"kuaiji":1,
"kuaiyoujia":1,
"kuakao":1,
"kuche":1,
"kugou":1,
"kuwan8":1,
"kuyibu":1,
"kuyiso":1,
"lacpj":1,
"lady8844":1,
"laijiuye":1,
"laiwang":1,
"lan1001":1,
"landchina":1,
"lanfw":1,
"lanhii":1,
"lanrentuku":1,
"laoke":1,
"laoren":1,
"lashou":1,
"lashouimg":1,
"law-star":1,
"lecai":1,
"ledu":1,
"lefeng":1,
"legolas-media":1,
"lejj":1,
"leju":1,
"letfind":1,
"letv":1,
"lexun":1,
"li63":1,
"liansuo":1,
"liantu":1,
"liao1":1,
"liaoing":1,
"liaoshenrc":1,
"lie-che":1,
"liebiao":1,
"liecheng":1,
"lieju":1,
"liepin":1,
"lietou":1,
"linezing":1,
"lingnanrc":1,
"liqucn":1,
"liuxue360":1,
"liuxue3600":1,
"liuxue86":1,
"live800":1,
"liyi99":1,
"llzg":1,
"ln2car":1,
"locoso":1,
"lofter":1,
"logmein":1,
"lolbuku":1,
"longchengrc":1,
"longre":1,
"longshangrc":1,
"looedu":1,
"looyu":1,
"lotour":1,
"loupan":1,
"love21cn":1,
"loveinhere":1,
"lovingjob":1,
"lsgzn":1,
"lssdjt":1,
"lstcw":1,
"luosi":1,
"lvmama":1,
"lvse":1,
"lvseba":1,
"lvtu":1,
"lvyou114":1,
"lvziyao":1,
"lwcj":1,
"lxdns":1,
"ly":1,
"lycos":1,
"lygo":1,
"lzhuba":1,
"lzlj":1,
"lzsgaj":1,
"m1905":1,
"machine365":1,
"machjobs":1,
"made-in-china":1,
"maifang":1,
"maijipu":1,
"makepolo":1,
"malmam":1,
"mamacn":1,
"mangocity":1,
"manmankan":1,
"manyou":1,
"manzuo":1,
"maoyigu":1,
"map456":1,
"mapabc":1,
"mapbar":1,
"marry5":1,
"mathtag":1,
"mbaobao":1,
"meadin":1,
"mediaplex":1,
"mediav":1,
"medic360":1,
"medzpw":1,
"meet99":1,
"meigui3":1,
"meijw":1,
"meilele":1,
"meilishuo":1,
"meinvjz":1,
"meishichina":1,
"meitu":1,
"meituan":1,
"meizu":1,
"menkou":1,
"menmian":1,
"messebbs":1,
"mfdyy":1,
"miaomudi":1,
"miaozhen":1,
"microsoft":1,
"mingluji":1,
"mingong123":1,
"mingzhurc":1,
"minjiangrc":1,
"mipang":1,
"mlt01":1,
"mmimm":1,
"mmstat":1,
"mnwww":1,
"mofang":1,
"mogujie":1,
"monfr":1,
"monternet":1,
"mookie1":1,
"moonbasa":1,
"mop":1,
"mosso":1,
"motorchina":1,
"moukao":1,
"msn":1,
"mtime":1,
"mtnets":1,
"mtw001":1,
"my0813":1,
"mybxg":1,
"mycar168":1,
"mycimt":1,
"mydrivers":1,
"myjmw":1,
"myjob":1,
"myrolan":1,
"mysteel":1,
"mysteelcdn":1,
"mytophome":1,
"myyouse":1,
"nandu":1,
"nba":1,
"nd597":1,
"neimengrc":1,
"net114":1,
"netease":1,
"netqin":1,
"newhua":1,
"newmaker":1,
"news18a":1,
"newsccn":1,
"newshainan":1,
"newsxy":1,
"nhshequ":1,
"nipic":1,
"nongji360":1,
"nongli":1,
"npckk":1,
"npicp":1,
"nrclady":1,
"nuomi":1,
"nvsheng":1,
"nz86":1,
"oadz":1,
"oeeee":1,
"offcn":1,
"ofweek":1,
"ohqly":1,
"ok619":1,
"okooo":1,
"olcdn":1,
"onccc":1,
"onlylady":1,
"or58":1,
"oranpage":1,
"orgcc":1,
"oujiangrc":1,
"ourgame":1,
"paipai":1,
"panjk":1,
"paody":1,
"paypal":1,
"pazx888":1,
"pcpop":1,
"pcwl":1,
"peixun360":1,
"pengchengrc":1,
"pengrc":1,
"pengyou":1,
"people258":1,
"petzp":1,
"pfwang":1,
"phoenixtv":1,
"phpwind":1,
"piaoliang":1,
"pingan":1,
"pinpai37":1,
"pixlr":1,
"podinns":1,
"pop800":1,
"ppstream":1,
"pptv":1,
"ppwan":1,
"psbc":1,
"ptbus":1,
"ptlogin2.qq":1,
"ptotour":1,
"pubmatic":1,
"puworld":1,
"px020":1,
"px0769":1,
"px58":1,
"pztuan":1,
"qc188":1,
"qctsw":1,
"qcwe":1,
"qcwz8":1,
"qdmm":1,
"qegee":1,
"qeqeqe":1,
"qhccw":1,
"qhimg":1,
"qhlly":1,
"qhnews":1,
"qi-che":1,
"qianlima":1,
"qianlong":1,
"qianqian":1,
"qianqishou":1,
"qianzhan":1,
"qiaopinche":1,
"qiaxing":1,
"qibosoft":1,
"qicou":1,
"qidian":1,
"qihoo":1,
"qinbei":1,
"qingdaonews":1,
"qiniucdn":1,
"qiniudn":1,
"qiongzhourc":1,
"qipeiren":1,
"qire123":1,
"qiushibaike":1,
"qiyipic":1,
"qjrc":1,
"qjy168":1,
"qlrc":1,
"qm120":1,
"qoomoo":1,
"qp110":1,
"qq":1,
"qq163":1,
"qqkqw":1,
"qqqooo":1,
"qqzssl":1,
"qstatic":1,
"qsztc":1,
"qu114":1,
"qu97":1,
"quanguoyoubian":1,
"quantserve":1,
"quanzhi":1,
"qudao":1,
"qudao168":1,
"qudong":1,
"quhua":1,
"qulv":1,
"qunar":1,
"qunarzz":1,
"qutouzi":1,
"quweiwu":1,
"qwjian":1,
"qxw18":1,
"qycn":1,
"qyer":1,
"qz828":1,
"qzcbs":1,
"raorao":1,
"rayp":1,
"rc365":1,
"rc929":1,
"rcwlm":1,
"readnovel":1,
"redidai":1,
"rencaijob":1,
"renren":1,
"renrenzhe":1,
"renrzx":1,
"renwen":1,
"renzheng":1,
"roadoor":1,
"rong360":1,
"roowei":1,
"rrimg":1,
"ruan8":1,
"runsky":1,
"s163":1,
"saicgroup":1,
"sanguosha":1,
"sanhaostreet":1,
"sanqin":1,
"scanscout":1,
"scanv":1,
"school51":1,
"scorecardresearch":1,
"scpolicec":1,
"scpspa":1,
"screenb2b":1,
"sctv":1,
"scxcxj":1,
"sdchina":1,
"sdo":1,
"seafang":1,
"seecq":1,
"seedit":1,
"serving-sys":1,
"sgamer":1,
"sh91":1,
"shanchengrc":1,
"shandongrc":1,
"shang360":1,
"shangdu":1,
"shanghairc":1,
"shangpusou":1,
"shangyici":1,
"shanxirc":1,
"shaqing":1,
"shchehang":1,
"she120":1,
"shejiben":1,
"shenchuang":1,
"shenzhenhr":1,
"shgao":1,
"shibaili":1,
"shmmw":1,
"shonsh":1,
"shoudurc":1,
"shoudurx":1,
"shouji":1,
"shouyou":1,
"showji":1,
"shufa":1,
"shuiniaoticket":1,
"sichuanrc":1,
"sina":1,
"sinaapp":1,
"sinaedge":1,
"sinaimg":1,
"sinajs":1,
"sinohydro":1,
"sisdown":1,
"sj998":1,
"sjfzxm":1,
"sjwg":1,
"sjwyx":1,
"sjxyx":1,
"skycn":1,
"sm597":1,
"smejs":1,
"snedu":1,
"snyu":1,
"so":1,
"soautos":1,
"sofang":1,
"sogou":1,
"sohu":1,
"sojike":1,
"somenmian":1,
"sonhoo":1,
"sooxue":1,
"soperson":1,
"soso":1,
"sososteel":1,
"soufun":1,
"soufunimg":1,
"souqian":1,
"southcn":1,
"souxuexiao":1,
"soxsok":1,
"speiyou":1,
"spzs":1,
"srtong":1,
"ssjzw":1,
"sswoo":1,
"standardcn":1,
"staticsdo":1,
"stcn":1,
"stdaily":1,
"stockstar":1,
"strong-study":1,
"studentboss":1,
"studydao":1,
"studyems":1,
"studyez":1,
"suanpi":1,
"subaonet":1,
"sulyxin":1,
"sun0769":1,
"suning":1,
"supei":1,
"suwurc":1,
"svisa":1,
"swjoy":1,
"sxrb":1,
"sxsme":1,
"syjiancai":1,
"szhk":1,
"szhufu":1,
"sznews":1,
"szooo":1,
"szpxe":1,
"szwudao":1,
"t139":1,
"takungpao":1,
"tantuw":1,
"tanx":1,
"tao123":1,
"taobao":1,
"taobaocdn":1,
"taoche":1,
"taofang":1,
"taojindi":1,
"taoktv":1,
"taotaocar":1,
"taowo2sc":1,
"tbscache":1,
"tcdai":1,
"tcpjw":1,
"tdimg":1,
"tdycr":1,
"tdzyw":1,
"tech-food":1,
"techanzhan":1,
"tencent":1,
"tenpay":1,
"texu1":1,
"tezhongzhuangbei":1,
"tgbus":1,
"thmz":1,
"tiandaoedu":1,
"tianjimedia":1,
"tianjinrc":1,
"tianqi":1,
"tianshanrc":1,
"tianyuimg":1,
"tiaohao":1,
"tieyou":1,
"timedg":1,
"tjkx":1,
"tmall":1,
"tmjob88":1,
"to8to":1,
"tobosu":1,
"tochgo":1,
"tom":1,
"tom365":1,
"tompda":1,
"tongbu":1,
"toocle":1,
"topfo":1,
"tourunion":1,
"toybaba":1,
"toysbaba":1,
"tqedu":1,
"tqkaoyan":1,
"tqmpacc":1,
"trade2cn":1,
"travelsky":1,
"tremormedia":1,
"trip8080":1,
"tt-ly":1,
"ttmeishi":1,
"ttys5":1,
"tuan800":1,
"tuanche":1,
"tuanweihui":1,
"tudinet":1,
"tudou":1,
"tuitui99":1,
"tujia":1,
"tuliu":1,
"tuniu":1,
"tuniucdn":1,
"tutechanw":1,
"tutu66":1,
"tvsou":1,
"txooo":1,
"tzkd":1,
"tzrl":1,
"u0762":1,
"u69cn":1,
"uc108":1,
"ufangw":1,
"ukecy":1,
"ule":1,
"ulinix":1,
"unionpay":1,
"upaiyun":1,
"useso":1,
"uu2car":1,
"uuu9":1,
"uuxoo":1,
"uzai":1,
"v2ex":1,
"v3gp":1,
"vancl":1,
"verycd":1,
"vip":1,
"vipshop":1,
"viptijian":1,
"vivijk":1,
"vizu":1,
"vsharing":1,
"waaku":1,
"wangdaizhijia":1,
"wangdaizhinan":1,
"wangpiao":1,
"wanmei":1,
"wanmeimr":1,
"wapurl":1,
"watchstor":1,
"wealink":1,
"webterren":1,
"webuuo":1,
"wechatnet":1,
"wed139":1,
"wedsoso":1,
"weibo":1,
"weizhangjilu":1,
"weizhuangxiu":1,
"wenjingjiaoyu":1,
"wenlingrc":1,
"wenzhouglasses":1,
"wifun":1,
"wincn":1,
"winshang":1,
"wnwb":1,
"wodingche":1,
"wofang":1,
"womai":1,
"woniu":1,
"worldscrap":1,
"wrating":1,
"wumii":1,
"wuyuan168":1,
"wxrb":1,
"wz2sc":1,
"wzms":1,
"xafc":1,
"xanet110":1,
"xbaixing":1,
"xbiao":1,
"xcarimg":1,
"xcy8":1,
"xdwan":1,
"xfwed":1,
"xhcedu":1,
"xiami":1,
"xiangmu":1,
"xianguo":1,
"xianweizhang":1,
"xiaoliangkou":1,
"xiaomishu":1,
"xiaonei":1,
"xiaoxiangrc":1,
"xiaozhi123":1,
"xiaozhu":1,
"xiche168":1,
"xichengrc":1,
"xihairc":1,
"xilu":1,
"ximalaya":1,
"xincheping":1,
"xinggan":1,
"xingshu":1,
"xinhua08":1,
"xinhuanet":1,
"xinniangjie":1,
"xinxiqu":1,
"xinyanju":1,
"xituan":1,
"xixiarc":1,
"xixik":1,
"xjtaobao":1,
"xkhouse":1,
"xmfish":1,
"xmhouse":1,
"xna8":1,
"xns315":1,
"xoyo":1,
"xsool":1,
"xtuan":1,
"xue2you":1,
"xueda":1,
"xueeu":1,
"xueshanrc":1,
"xuexi111":1,
"xuexiaodaquan":1,
"xuexun":1,
"xunlei":1,
"xunyangwang":1,
"xutour":1,
"xw365":1,
"xwie":1,
"xy":1,
"xywy":1,
"xzjyh":1,
"xzxx":1,
"xzyuhui":1,
"ya247":1,
"yangshitianqi":1,
"yangtse":1,
"yangzhi":1,
"yanzhaorc":1,
"yaoee":1,
"yaolan":1,
"yaolvyou":1,
"yaowan":1,
"yaozs":1,
"yc38":1,
"yccdn":1,
"ycwb":1,
"yes515":1,
"yesfr":1,
"yesky":1,
"yeyou":1,
"ygjj":1,
"yhachina":1,
"yhd":1,
"yi958":1,
"yicai":1,
"yiche":1,
"yichemall":1,
"yidaba":1,
"yieldmanager":1,
"yihaodian":1,
"yingjiesheng":1,
"yingmoo":1,
"yinlianbang":1,
"yinsha":1,
"yinyuetai":1,
"yiqifa":1,
"yisou":1,
"yiwubuy":1,
"yixuezp":1,
"yizhaopin":1,
"yizimg":1,
"yjbys":1,
"ykimg":1,
"yl1001":1,
"ymt360":1,
"ynet":1,
"yninfo":1,
"yntch":1,
"ynzp":1,
"yoher":1,
"yohobuy":1,
"yoka":1,
"yongjiangrc":1,
"youbian":1,
"youbianku":1,
"youboy":1,
"youdao":1,
"youhua":1,
"youhunan":1,
"youkee":1,
"youku":1,
"youshang":1,
"youtx":1,
"youxiake":1,
"youxiniao":1,
"youzu":1,
"yoyojie":1,
"ypall":1,
"yqbdt":1,
"ythuayi":1,
"yuanlin":1,
"yuduxx":1,
"yuloo":1,
"yundianrc":1,
"yunos":1,
"yunshipei":1,
"yupoo":1,
"yuqihuang":1,
"yy":1,
"yzrc":1,
"yzydt":1,
"zangao":1,
"zangyaofang":1,
"zanzw":1,
"zcheer":1,
"zcwz":1,
"zdmimg":1,
"zghqcy":1,
"zgjhjy":1,
"zgjsks":1,
"zgmod":1,
"zgpingshu":1,
"zgqczj":1,
"zgqpc":1,
"zgrcw":1,
"zgzcw":1,
"zhaochafa":1,
"zhaokaoku":1,
"zhaopin":1,
"zhaoshang800":1,
"zhaoshangbao":1,
"zhaosheng":1,
"zhaotie":1,
"zhcw":1,
"zhenai":1,
"zhibo8":1,
"zhiding8":1,
"zhigame":1,
"zhijia":1,
"zhimg":1,
"zhixiaoren":1,
"zhixuan":1,
"zhiyuanyun":1,
"zhongkao":1,
"zhongso":1,
"zhongsou":1,
"zhongzhourc":1,
"zhuangku":1,
"zhuannet":1,
"zhuapo":1,
"zhuaxia":1,
"zhubajie":1,
"zhujiangrc":1,
"zhulong":1,
"zhuokearts":1,
"zhuqike":1,
"zhuzao":1,
"zijiayoucn":1,
"zixia":1,
"zj":1,
"zjcyts":1,
"zjstv":1,
"zoioo":1,
"zol":1,
"zongheng":1,
"zoopda":1,
"zoossoft":1,
"zp365":1,
"zsezt":1,
"zshl":1,
"zsnets":1,
"zst365":1,
"ztedu":1,
"ztgame":1,
"zuche":1,
"zuchecdn":1,
"zufang":1,
"zuoche":1,
"zupuk":1,
"zuzhirenshi":1,
"zuzuche":1,
"zwtxnews":1,
"zxdyw":1,
"zxxk":1,
"zy":1,
"zyctd":1,
"zynews":1,
"zynw":1,
"zyue":1,
"zyzhan":1,
"zz597":1,
"zz91":1
},"edu":{
"snai":1
},"fm":{
"douban":1,
"jing":1
},"info":{
"lztech":1,
"williamlong":1
},"la":{
"51":1,
"55":1
},"me":{
"21me":1
},"net":{
"020p":1,
"126":1,
"1616":1,
"17u":1,
"263":1,
"2mdn":1,
"33map":1,
"360guakao":1,
"39":1,
"51la":1,
"51test":1,
"52xiaoyuan":1,
"54kefu":1,
"5d6d":1,
"84bus":1,
"8671":1,
"96519":1,
"999120":1,
"ali213":1,
"ankang":1,
"artron":1,
"baixing":1,
"bd365":1,
"bokee":1,
"c-ps":1,
"catv":1,
"ccen":1,
"ccmn":1,
"chinabug":1,
"chinacrane":1,
"chinagames":1,
"chinaunix":1,
"cifco":1,
"cn":1,
"cncn":1,
"cndog":1,
"cninfo":1,
"cnki":1,
"cnool":1,
"cnpension":1,
"cnzz":1,
"copperhome":1,
"cqnews":1,
"cqwu":1,
"csdn":1,
"cyol":1,
"daozhou":1,
"discuz":1,
"diwei":1,
"dltm":1,
"doubleclick":1,
"dqccc":1,
"dragon-guide":1,
"duba":1,
"dv37":1,
"dytt8":1,
"feijiu":1,
"fengj":1,
"foodmate":1,
"gcimg":1,
"gfedu":1,
"gotozjj":1,
"hainan":1,
"hlj":1,
"hngawj":1,
"hnjkw":1,
"hnnw":1,
"hnpi":1,
"hteacher":1,
"huoche":1,
"hynews":1,
"icar168":1,
"inhe":1,
"irs01":1,
"itcpn":1,
"itsogo":1,
"jandan":1,
"jiajushichang":1,
"jiaodong":1,
"jinrongren":1,
"jysq":1,
"jzcn":1,
"jzdd":1,
"kanghu":1,
"kdnet":1,
"ksgs":1,
"kuaidi100":1,
"liuxue51":1,
"lmjx":1,
"longhoo":1,
"longjiang":1,
"lotour":1,
"map456":1,
"meishij":1,
"meituan":1,
"mm111":1,
"newsmth":1,
"nmtravel":1,
"nxnews":1,
"onegreen":1,
"onlinedown":1,
"oschina":1,
"p5w":1,
"paixie":1,
"pchome":1,
"phpwind":1,
"qgyyzs":1,
"qincai":1,
"qp365":1,
"replays":1,
"rtbidder":1,
"scedu":1,
"scpv":1,
"sdinfo":1,
"shuajizhijia":1,
"shzfzz":1,
"sinahk":1,
"supfree":1,
"szedu":1,
"szonline":1,
"tczx":1,
"tiexue":1,
"tongxiehui":1,
"tqedu":1,
"weizhang":1,
"wzer":1,
"xdkb":1,
"xici":1,
"xinxijie":1,
"xue":1,
"xueche":1,
"xxsy":1,
"y80s":1,
"ylsw":1,
"yyzs":1,
"zbinfo":1,
"zdic":1,
"zhongsou":1,
"zljob":1,
"zoosnet":1,
"zprc":1,
"zq8":1,
"ztsfc":1,
"zyrc":1
},"org":{
"51honest":1,
"acftu":1,
"ailaba":1,
"ankang06":1,
"anquan":1,
"bjjubao":1,
"bjsdr":1,
"caiep":1,
"canjiren":1,
"ccpit":1,
"chengdu56":1,
"china-embassy":1,
"chinacct":1,
"chinacourt":1,
"chinadmoz":1,
"chinataiwan":1,
"chineseconsulate":1,
"chineseembassy":1,
"ci-bo":1,
"cngold":1,
"cnqr":1,
"cq315":1,
"gedu":1,
"gzzyz":1,
"huocheshikebiao":1,
"jiangshi":1,
"jinde":1,
"keywin":1,
"lohcn":1,
"neworiental":1,
"newssc":1,
"patachina":1,
"rtsac":1,
"sae-china":1,
"sqzx":1,
"sxly":1,
"szfw":1,
"tielu":1,
"trustutn":1,
"w3":1,
"wwfchina":1,
"xinhua":1,
"xinzhou":1,
"xuetian":1,
"zgba":1,
"zgshfljjh":1,
"zjedu":1,
"zx110":1
},"so":{
"soutudi":1
},"tv":{
"19888":1,
"5999":1,
"9928":1,
"9998":1,
"acfun":1,
"acg":1,
"bilibili":1,
"cnsb":1,
"hao315":1,
"pps":1
},"ws":{
"0798":1
}
};

var hasOwnProperty = Object.hasOwnProperty;

function check_ipv4(host) {
	var re_ipv4 = /^\d+\.\d+\.\d+\.\d+$/g;
	if (re_ipv4.test(host)) {
		return true;
	}
}
function check_ipv6(host) {
	var re_ipv6 = /^\[?([a-fA-F0-9]{0,4}\:){1,7}[a-fA-F0-9]{0,4}\]?$/g;
	if (re_ipv6.test(host)) {
		return true;
	}
}
function check_ipv6_dns(dnsstr) {
	var re_ipv6 = /([a-fA-F0-9]{0,4}\:){1,7}[a-fA-F0-9]{0,4}(%[0-9]+)?/g;
	if (re_ipv6.test(dnsstr)) {
		return true;
	}
}
function convertAddress(ipchars) {
	var bytes = ipchars.split('.');
	var result = (bytes[0] << 24) |
	(bytes[1] << 16) |
	(bytes[2] << 8) |
	(bytes[3]);
	return result >>> 0;
}
function isInSingleRange(ipRange, intIp) {
	if ( hasOwnProperty.call(cnIp16Range, intIp >>> 6) ) {
		for ( var range = 1; range < 64; range*=4 ) {
			var master = intIp & ~(range-1);
			if ( hasOwnProperty.call(ipRange, master) )
				return intIp - master < ipRange[master];
		}
	} else {
		for ( var range = 64; range <= 1024; range*=4 ) {
			var master = intIp & ~(range-1);
			if ( hasOwnProperty.call(ipRange, master) )
				return intIp - master < ipRange[master];
		}
	}
}
function isInSubnetRange(ipRange, intIp) {
	for ( var i = 0; i < 10; i += 2 ) {
		if ( ipRange[i] <= intIp && intIp < ipRange[i+1] )
			return true;
	}
}
function getProxyFromIP(strIp) {
	var intIp = convertAddress(strIp);
	if ( isInSubnetRange(subnetIpRangeList, intIp) ) {
		return direct;
	}
	var index = (intIp >>> 24) & 0xff;
	if ( isInSingleRange(cnIpRange[index], intIp >>> 8) ) {
		return nowall_proxy();
	}
	if (hasOwnProperty.call(whiteIpList, strIp)) {
		return nowall_proxy();
	}
	return ip_proxy();
}
function isInDomains(domain_dict, host) {
	var suffix;
	var pos1 = host.lastIndexOf('.');

	suffix = host.substring(pos1 + 1);
	if (suffix == "cn") {
		return true;
	}

	var domains = domain_dict[suffix];
	if ( domains === undefined ) {
		return false;
	}
	host = host.substring(0, pos1);
	var pos = host.lastIndexOf('.');

	while(1) {
		if (pos <= 0) {
			if (hasOwnProperty.call(domains, host)) {
				return true;
			} else {
				return false;
			}
		}
		suffix = host.substring(pos + 1);
		if (hasOwnProperty.call(domains, suffix)) {
			return true;
		}
		pos = host.lastIndexOf('.', pos - 1);
	}
}
function FindProxyForURL(url, host) {
	if ( isPlainHostName(host) === true ) {
		return direct;
	}
	if ( check_ipv4(host) === true ) {
		return getProxyFromIP(host);
	}
	if ( check_ipv6(host) === true ) {
		return ipv6_proxy();
	}
	if ( isInDomains(white_domains, host) === true ) {
		return nowall_proxy();
	}
	return wall_proxy();
}

function FindProxyForURLEx(url, host) {
	if ( isPlainHostName(host) === true ) {
		return direct;
	}
	if ( check_ipv4(host) === true ) {
		return getProxyFromIP(host);
	}
	if ( check_ipv6(host) === true ) {
		return ipv6_proxy();
	}
	if ( isInDomains(white_domains, host) === true ) {
		return nowall_proxy();
	}
	return wall_proxy();
}